/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVListener;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DAVRepository {
    private static final String ACCEPTABLE = "ABCDEFGHIJLKMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-!.~'()*,;:$&+=?/[]@";
    private File root = null;
    private URI base = null;
    private Set listeners = new HashSet();

    public DAVRepository(File root) throws IOException {
        if (root == null) {
            throw new NullPointerException("Null root");
        }
        if (!root.isDirectory()) {
            throw new IOException("Root \"" + root + "\" is not a directory");
        }
        this.root = root.getCanonicalFile();
        this.base = this.root.toURI().normalize();
    }

    protected URI getRepositoryURI() {
        return this.base;
    }

    public DAVResource getResource(String name) throws IOException {
        if (name == null) {
            return this.getResource((URI)null);
        }
        try {
            StringBuffer buffer = new StringBuffer();
            byte[] encoded = name.getBytes("UTF-8");
            for (int x = 0; x < encoded.length; ++x) {
                if (ACCEPTABLE.indexOf(encoded[x]) < 0) {
                    buffer.append('%');
                    buffer.append(DAVUtilities.toHexString(encoded[x]));
                    continue;
                }
                buffer.append((char)encoded[x]);
            }
            return this.getResource(new URI(buffer.toString()));
        }
        catch (URISyntaxException exception) {
            String message = "Invalid resource name \"" + name + "\"";
            throw (IOException)new IOException(message).initCause(exception);
        }
    }

    public DAVResource getResource(URI uri) throws IOException {
        if (uri == null) {
            return new DAVResource(this, this.root);
        }
        if (!uri.isAbsolute()) {
            uri = this.base.resolve(uri).normalize();
        }
        return new DAVResource(this, new File(uri).getAbsoluteFile());
    }

    public void addListener(DAVListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DAVListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void notify(DAVResource resource, int event) {
        if (resource == null) {
            throw new NullPointerException("Null resource");
        }
        if (resource.getRepository() != this) {
            throw new IllegalArgumentException("Invalid resource");
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((DAVListener)iterator.next()).notify(resource, event);
            }
            catch (RuntimeException exception) {}
        }
    }
}

