/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVException;
import it.could.webdav.DAVMethod;
import it.could.webdav.DAVRepository;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DAVProcessor {
    public static final String METHODS = "COPY,DELETE,GET,HEAD,MKCOL,MOVE,OPTIONS,PROPFIND,PROPPATCH,PUT";
    private static final Map INSTANCES = new HashMap();
    private DAVRepository repository = null;
    static /* synthetic */ Class class$it$could$webdav$DAVProcessor;

    public DAVProcessor(DAVRepository repository) {
        if (repository == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
    }

    public void process(DAVTransaction transaction) throws IOException {
        try {
            String method = transaction.getMethod();
            if (!INSTANCES.containsKey(method)) {
                String message = "Method \"" + method + "\" not implemented";
                throw new DAVException(501, message);
            }
            String path = transaction.getNormalizedPath();
            DAVResource resource = this.repository.getResource(path);
            DAVMethod instance = (DAVMethod)INSTANCES.get(method);
            instance.process(transaction, resource);
        }
        catch (DAVException exception) {
            exception.write(transaction);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String thisName = (class$it$could$webdav$DAVProcessor == null ? (class$it$could$webdav$DAVProcessor = DAVProcessor.class$("it.could.webdav.DAVProcessor")) : class$it$could$webdav$DAVProcessor).getName();
        int packageDelimiter = thisName.lastIndexOf(46);
        String packageName = packageDelimiter < 1 ? "methods." : thisName.substring(0, packageDelimiter) + ".methods.";
        StringTokenizer tokenizer = new StringTokenizer(METHODS, ",");
        ClassLoader classLoader = (class$it$could$webdav$DAVProcessor == null ? (class$it$could$webdav$DAVProcessor = DAVProcessor.class$("it.could.webdav.DAVProcessor")) : class$it$could$webdav$DAVProcessor).getClassLoader();
        while (tokenizer.hasMoreTokens()) {
            try {
                String method = tokenizer.nextToken();
                String className = packageName + method;
                Class<?> clazz = classLoader.loadClass(className);
                INSTANCES.put(method, (DAVMethod)clazz.newInstance());
            }
            catch (Throwable throwable) {
                InternalError error = new InternalError("Error loading method");
                throw (InternalError)error.initCause(throwable);
            }
        }
    }
}

