/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVException;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import it.could.webdav.DAVUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DAVMultiStatus
extends DAVException {
    private Set responses = new HashSet();

    public DAVMultiStatus() {
        super(207, "Multi-Status response");
    }

    public void write(DAVTransaction transaction) throws IOException {
        transaction.setStatus(207);
        transaction.setContentType("text/xml; charset=\"UTF-8\"");
        PrintWriter out = transaction.write("UTF-8");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<D:multistatus xmlns:D=\"DAV:\">");
        Iterator responses = this.responses.iterator();
        while (responses.hasNext()) {
            Response response = (Response)responses.next();
            out.println(" <D:response>");
            out.print("  <D:href>");
            out.print(transaction.lookup(response.resource));
            out.println("</D:href>");
            if (response.status != 0) {
                out.print("  <D:status>HTTP/1.1 ");
                out.print(DAVUtilities.getStatusMessage(response.status));
                out.println("</D:status>");
            }
            if (response.message != null) {
                out.print("  <D:responsedescription>");
                out.print(response.message);
                out.println("</D:responsedescription>");
            }
            out.println(" </D:response>");
        }
        out.println("</D:multistatus>");
        out.flush();
    }

    public int size() {
        return this.responses.size();
    }

    public void merge(DAVMultiStatus multistatus) {
        if (multistatus == null) {
            return;
        }
        Iterator iterator = multistatus.responses.iterator();
        while (iterator.hasNext()) {
            this.responses.add(iterator.next());
        }
    }

    public void merge(DAVException exception) {
        DAVResource resource = exception.getResource();
        if (resource == null) {
            throw exception;
        }
        int status = exception.getStatus();
        String message = exception.getMessage();
        this.responses.add(new Response(resource, status, message));
    }

    private static class Response
    implements Comparable {
        private DAVResource resource = null;
        private int status = 0;
        private String message = null;

        public Response(Response response) {
            this(response.resource, response.status, response.message);
        }

        public Response(DAVResource resource, int status, String message) {
            if (resource == null) {
                throw new NullPointerException();
            }
            this.resource = resource;
            this.status = status;
            this.message = message;
        }

        public int hashCode() {
            return this.resource.hashCode();
        }

        public int compareTo(Object object) {
            Response response = (Response)object;
            return this.resource.compareTo(response.resource);
        }

        public boolean equals(Object object) {
            if (object instanceof Response) {
                Response response = (Response)object;
                return this.resource.equals(response.resource);
            }
            return false;
        }
    }
}

