/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class DAVLogger {
    private final ServletContext context;
    private final String servletName;
    private final boolean debug;

    public DAVLogger(ServletConfig config, boolean debug) {
        this.context = config.getServletContext();
        this.servletName = config.getServletName();
        this.debug = debug;
    }

    public void debug(String message) {
        if (this.debug) {
            this.doLog(message, null);
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.debug) {
            this.doLog(message, throwable);
        }
    }

    public void log(String message) {
        this.doLog(message, null);
    }

    public void log(String message, Throwable throwable) {
        this.doLog(message, throwable);
    }

    private void doLog(String message, Throwable throwable) {
        if (message == null && throwable == null) {
            return;
        }
        if (message == null || "".equals(message)) {
            message = "No message";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        buffer.append(this.servletName);
        buffer.append("] ");
        buffer.append(message);
        if (throwable == null) {
            this.context.log(buffer.toString());
        } else {
            this.context.log(buffer.toString(), throwable);
        }
    }
}

