/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVException;
import it.could.webdav.DAVResource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DAVInputStream
extends InputStream {
    private InputStream input = null;
    private DAVResource resource = null;

    protected DAVInputStream(DAVResource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        try {
            this.input = new FileInputStream(resource.getFile());
        }
        catch (IOException e) {
            String message = "Unable to read from resource";
            throw new DAVException(403, message, e, resource);
        }
    }

    public int read() {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            return this.input.read();
        }
        catch (IOException e) {
            throw new DAVException(403, "Can't read data", e, this.resource);
        }
    }

    public int read(byte[] b) {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            return this.input.read(b);
        }
        catch (IOException e) {
            throw new DAVException(403, "Can't read data", e, this.resource);
        }
    }

    public int read(byte[] b, int off, int len) {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            return this.input.read(b, off, len);
        }
        catch (IOException e) {
            throw new DAVException(403, "Can't read data", e, this.resource);
        }
    }

    public long skip(long n) {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            return this.input.skip(n);
        }
        catch (IOException e) {
            throw new DAVException(403, "Can't skip over", e, this.resource);
        }
    }

    public int available() {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            return this.input.available();
        }
        catch (IOException e) {
            throw new DAVException(403, "Can't skip over", e, this.resource);
        }
    }

    public void close() {
        if (this.input == null) {
            return;
        }
        try {
            this.input.close();
        }
        catch (IOException e) {
            throw new DAVException(403, "Can't close", e, this.resource);
        }
        finally {
            this.input = null;
        }
    }

    public void mark(int readlimit) {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
        this.input.mark(readlimit);
    }

    public void reset() {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
        try {
            this.input.reset();
        }
        catch (IOException e) {
            throw new DAVException(403, "Can't reset", e, this.resource);
        }
    }

    public boolean markSupported() {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
        return this.input.markSupported();
    }
}

