/*
 * Decompiled with CFR 0.152.
 */
package it.could.util.location;

import it.could.util.StringTools;
import it.could.util.encoding.Encodable;
import it.could.util.encoding.EncodingTools;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Parameters
extends AbstractList
implements Encodable {
    public static final char DEFAULT_DELIMITER = '&';
    private final Parameter[] parameters;
    private final Map map;
    final Set names;
    private final char delimiter;
    private final String string;

    public Parameters(List parameters) {
        this(parameters, '&');
    }

    public Parameters(List parameters, char delimiter) {
        if (parameters.size() == 0) {
            throw new IllegalArgumentException();
        }
        Parameter[] array = new Parameter[parameters.size()];
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (int x = 0; x < array.length; ++x) {
            Parameter parameter = (Parameter)parameters.get(x);
            String key = parameter.getName();
            ArrayList<String> values = (ArrayList<String>)map.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                map.put(key, values);
            }
            values.add(parameter.getValue());
            array[x] = parameter;
        }
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            List list = (List)entry.getValue();
            entry.setValue(Collections.unmodifiableList(list));
        }
        this.delimiter = delimiter;
        this.map = Collections.unmodifiableMap(map);
        this.names = Collections.unmodifiableSet(map.keySet());
        this.parameters = array;
        this.string = EncodingTools.toString(this);
    }

    public static Parameters create(List parameters) {
        return Parameters.create(parameters, '&');
    }

    public static Parameters create(List parameters, char delimiter) {
        if (parameters == null) {
            return null;
        }
        ArrayList dedupes = new ArrayList();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (dedupes.contains(next)) continue;
            dedupes.add(next);
        }
        if (dedupes.size() == 0) {
            return null;
        }
        return new Parameters(dedupes, delimiter);
    }

    public static Parameters parse(String parameters) {
        try {
            return Parameters.parse(parameters, '&', "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public static Parameters parse(String parameters, char delimiter) {
        try {
            return Parameters.parse(parameters, delimiter, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            String message = "Unsupported encoding UTF-8";
            InternalError error = new InternalError("Unsupported encoding UTF-8");
            throw (InternalError)error.initCause(exception);
        }
    }

    public static Parameters parse(String parameters, String encoding) throws UnsupportedEncodingException {
        return Parameters.parse(parameters, '&', encoding);
    }

    public static Parameters parse(String parameters, char delimiter, String encoding) throws UnsupportedEncodingException {
        if (parameters == null) {
            return null;
        }
        if (parameters.length() == 0) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String[] split = StringTools.splitAll(parameters, delimiter);
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (int x = 0; x < split.length; ++x) {
            Parameter parameter;
            if (split[x] == null || split[x].length() == 0 || (parameter = Parameter.parse(split[x], encoding)) == null) continue;
            list.add(parameter);
        }
        if (list.size() == 0) {
            return null;
        }
        return new Parameters(list, delimiter);
    }

    public int size() {
        return this.parameters.length;
    }

    public Object get(int index) {
        return this.parameters[index];
    }

    public Set getNames() {
        return this.names;
    }

    public String getValue(String name) {
        List values = (List)this.map.get(name);
        return values == null ? null : (String)values.get(0);
    }

    public List getValues(String name) {
        return (List)this.map.get(name);
    }

    public String toString() {
        return this.string;
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        for (int x = 0; x < this.parameters.length; ++x) {
            buffer.append(this.delimiter);
            buffer.append(this.parameters[x].toString(encoding));
        }
        return buffer.substring(1);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Parameters) {
            return this.string.equals(((Parameters)object).string);
        }
        return false;
    }

    public static class Parameter
    implements Encodable {
        private final String name;
        private final String value;
        private final String string;

        public Parameter(String name, String value) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (name.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.value = value;
            this.string = EncodingTools.toString(this);
        }

        public static Parameter parse(String parameter) throws UnsupportedEncodingException {
            try {
                return Parameter.parse(parameter, "UTF-8");
            }
            catch (UnsupportedEncodingException exception) {
                String message = "Unsupported encoding UTF-8";
                InternalError error = new InternalError("Unsupported encoding UTF-8");
                throw (InternalError)error.initCause(exception);
            }
        }

        public static Parameter parse(String parameter, String encoding) throws UnsupportedEncodingException {
            String[] split;
            if (parameter == null) {
                return null;
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            if ((split = StringTools.splitOnce(parameter, '=', false))[0] == null) {
                return null;
            }
            return new Parameter(split[0], split[1]);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.string;
        }

        public String toString(String encoding) throws UnsupportedEncodingException {
            if (this.value != null) {
                return EncodingTools.urlEncode(this.name, encoding) + "=" + EncodingTools.urlEncode(this.value, encoding);
            }
            return EncodingTools.urlEncode(this.name, encoding);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Parameter) {
                return this.string.equals(((Parameter)object).string);
            }
            return false;
        }
    }
}

