/*
 * Decompiled with CFR 0.152.
 */
package it.could.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class StringTools {
    private static final String FORMAT_822 = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String FORMAT_ISO = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final TimeZone TIMEZONE = TimeZone.getTimeZone("GMT");
    private static final Locale LOCALE = Locale.US;

    private StringTools() {
    }

    public static String formatNumber(Number number) {
        if (number == null) {
            return null;
        }
        return number.toString();
    }

    public static Long parseNumber(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Long(string);
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    public static String formatHttpDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_822, LOCALE);
        formatter.setTimeZone(TIMEZONE);
        return formatter.format(date);
    }

    public static String formatIsoDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_ISO, LOCALE);
        formatter.setTimeZone(TIMEZONE);
        return formatter.format(date);
    }

    public static Date parseHttpDate(String string) {
        if (string == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_822, LOCALE);
        formatter.setTimeZone(TIMEZONE);
        try {
            return formatter.parse(string);
        }
        catch (ParseException exception) {
            return null;
        }
    }

    public static Date parseIsoDate(String string) {
        if (string == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_ISO, LOCALE);
        formatter.setTimeZone(TIMEZONE);
        try {
            return formatter.parse(string);
        }
        catch (ParseException exception) {
            return null;
        }
    }

    public static String[] splitOnce(String source, char delimiter, boolean noDelimReturnSecond) {
        if (source == null) {
            return new String[]{null, null};
        }
        int position = source.indexOf(delimiter);
        if (position < 0) {
            if (noDelimReturnSecond) {
                return new String[]{null, source};
            }
            return new String[]{source, null};
        }
        if (position == 0) {
            if (source.length() == 1) {
                return new String[]{null, null};
            }
            return new String[]{null, source.substring(1)};
        }
        String first = source.substring(0, position);
        if (source.length() - 1 == position) {
            return new String[]{first, null};
        }
        return new String[]{first, source.substring(position + 1)};
    }

    public static String[] splitAll(String source, char delimiter) {
        int length;
        ArrayList<String> strings = new ArrayList<String>();
        String current = source;
        while (current != null) {
            String[] split = StringTools.splitOnce(current, delimiter, false);
            strings.add(split[0]);
            current = split[1];
        }
        if (current != null) {
            strings.add(current);
        }
        if ((length = source.length()) > 0 && source.charAt(length - 1) == delimiter) {
            strings.add(null);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static int findFirst(String source, String delimiters) {
        char[] array = source.toCharArray();
        char[] delim = delimiters.toCharArray();
        for (int x = 0; x < array.length; ++x) {
            for (int y = 0; y < delim.length; ++y) {
                if (array[x] != delim[y]) continue;
                return x;
            }
        }
        return -1;
    }
}

