/*
 * Decompiled with CFR 0.152.
 */
package it.could.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamTools {
    private StreamTools() {
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return StreamTools.copy(in, out, true);
    }

    public static long copy(InputStream in, OutputStream out, boolean close) throws IOException {
        if (in == null) {
            throw new NullPointerException("Null input");
        }
        if (out == null) {
            throw new NullPointerException("Null output");
        }
        byte[] buffer = new byte[4096];
        int length = -1;
        long total = 0L;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
            total += (long)length;
        }
        if (close) {
            in.close();
            out.close();
        }
        return total;
    }
}

