/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.plugins.site.CategorySummaryDocumentRenderer;
import org.apache.maven.plugins.site.ReportDocumentRenderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractSiteRenderingMojo
extends AbstractSiteMojo {
    protected Map moduleExcludes;
    protected DecorationModelInheritanceAssembler assembler;
    protected ArtifactResolver artifactResolver;
    protected List repositories;
    protected ArtifactFactory artifactFactory;
    private File templateDirectory;
    private String template;
    private File templateFile;
    protected Map attributes;
    protected Renderer siteRenderer;
    protected List reports;
    private File xdocDirectory;
    protected File generatedSiteDirectory;

    protected DecorationModel getDecorationModel(MavenProject project, Locale locale, Map origProps) throws MojoExecutionException {
        MavenProject parentProject;
        File siteDescriptor;
        HashMap props = new HashMap(origProps);
        if (project.getBasedir() == null) {
            try {
                siteDescriptor = this.getSiteDescriptorFromRepository(project, locale);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("The site descriptor cannot be resolved from the repository: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("The site descriptor cannot be resolved from the repository: " + e.getMessage(), (Exception)e);
            }
        } else {
            siteDescriptor = this.getSiteDescriptorFile(project.getBasedir(), locale);
        }
        String siteDescriptorContent = null;
        try {
            if (siteDescriptor != null && siteDescriptor.exists()) {
                this.getLog().debug((CharSequence)("Reading site descriptor from " + siteDescriptor));
                XmlStreamReader siteDescriptorReader = ReaderFactory.newXmlReader(siteDescriptor);
                siteDescriptorContent = IOUtil.toString((Reader)siteDescriptorReader);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("The site descriptor cannot be read!", (Exception)e);
        }
        DecorationModel decoration = null;
        if (siteDescriptorContent != null) {
            try {
                siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(props, project, siteDescriptorContent);
            }
            catch (IOException e) {
                throw new MojoExecutionException("The site descriptor cannot interpolate properties: " + e.getMessage(), (Exception)e);
            }
            decoration = this.readDecorationModel(siteDescriptorContent);
        }
        if ((parentProject = this.getParentProject(project)) != null) {
            this.getLog().debug((CharSequence)"Parent project loaded ...");
            DecorationModel parent = this.getDecorationModel(parentProject, locale, props);
            if (decoration == null) {
                decoration = parent;
            } else {
                this.assembler.assembleModelInheritance(project.getName(), decoration, parent, project.getUrl(), parentProject.getUrl() == null ? project.getUrl() : parentProject.getUrl());
            }
            if (decoration != null) {
                this.populateProjectParentMenu(decoration, locale, parentProject, true);
            }
        }
        if (decoration != null && decoration.getSkin() != null) {
            this.getLog().debug((CharSequence)("Skin used: " + decoration.getSkin()));
        }
        return decoration;
    }

    private DecorationModel readDecorationModel(String siteDescriptorContent) throws MojoExecutionException {
        DecorationModel decoration;
        try {
            decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing site descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading site descriptor", (Exception)e);
        }
        return decoration;
    }

    private File getSiteDescriptorFromRepository(MavenProject project, Locale locale) throws ArtifactResolutionException, IOException {
        File result = null;
        try {
            result = this.resolveSiteDescriptor(project, locale);
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)("Unable to locate site descriptor: " + (Object)((Object)e)));
        }
        return result;
    }

    private File resolveSiteDescriptor(MavenProject project, Locale locale) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        File result;
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "xml", "site_" + locale.getLanguage());
        boolean found = false;
        try {
            this.artifactResolver.resolve(artifact, this.repositories, this.localRepository);
            result = artifact.getFile();
            if (result.length() > 0L) {
                found = true;
            } else {
                this.getLog().debug((CharSequence)"Skipped locale's site descriptor");
            }
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)("Unable to locate locale's site descriptor: " + (Object)((Object)e)));
            result = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
            result.createNewFile();
        }
        if (!found) {
            artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "xml", "site");
            try {
                this.artifactResolver.resolve(artifact, this.repositories, this.localRepository);
            }
            catch (ArtifactNotFoundException e) {
                result = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
                result.createNewFile();
                throw e;
            }
            result = artifact.getFile();
            if (result.length() == 0L) {
                this.getLog().debug((CharSequence)"Skipped remote site descriptor check");
                result = null;
            }
        }
        return result;
    }

    private File getSkinArtifactFile(DecorationModel decoration) throws MojoFailureException, MojoExecutionException {
        Artifact artifact;
        Skin skin = decoration.getSkin();
        if (skin == null) {
            skin = Skin.getDefaultSkin();
        }
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            artifact = this.artifactFactory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.artifactResolver.resolve(artifact, this.repositories, this.localRepository);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("The skin version '" + version + "' is not valid: " + e.getMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoFailureException("The skin does not exist: " + e.getMessage());
        }
        return artifact.getFile();
    }

    protected List filterReports(List reports) {
        ArrayList<MavenReport> filteredReports = new ArrayList<MavenReport>(reports.size());
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            try {
                if (!report.canGenerateReport()) continue;
                filteredReports.add(report);
            }
            catch (AbstractMethodError e) {
                this.getLog().warn((CharSequence)("Error loading report " + report.getClass().getName() + " - AbstractMethodError: canGenerateReport()"));
                filteredReports.add(report);
            }
        }
        return filteredReports;
    }

    protected SiteRenderingContext createSiteRenderingContext(Locale locale) throws MojoExecutionException, IOException, MojoFailureException {
        SiteRenderingContext context;
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (this.attributes.get("project") == null) {
            this.attributes.put("project", this.project);
        }
        if (this.attributes.get("inputEncoding") == null) {
            this.attributes.put("inputEncoding", this.inputEncoding);
        }
        if (this.attributes.get("outputEncoding") == null) {
            this.attributes.put("outputEncoding", this.outputEncoding);
        }
        this.attributes.putAll(this.project.getProperties());
        DecorationModel decorationModel = this.getDecorationModel(locale);
        if (this.template != null) {
            if (this.templateFile != null) {
                this.getLog().warn((CharSequence)"'template' configuration is ignored when 'templateFile' is set");
            } else {
                this.templateFile = new File(this.templateDirectory, this.template);
            }
        }
        File skinFile = this.getSkinArtifactFile(decorationModel);
        if (this.templateFile != null) {
            if (!this.templateFile.exists()) {
                throw new MojoFailureException("Template file '" + this.templateFile + "' does not exist");
            }
            context = this.siteRenderer.createContextForTemplate(this.templateFile, skinFile, this.attributes, decorationModel, this.project.getName(), locale);
        } else {
            context = this.siteRenderer.createContextForSkin(skinFile, this.attributes, decorationModel, this.project.getName(), locale);
        }
        if (!locale.getLanguage().equals(Locale.getDefault().getLanguage())) {
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "xdoc");
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "fml");
        } else {
            context.addSiteDirectory(this.siteDirectory);
            context.addModuleDirectory(this.xdocDirectory, "xdoc");
            context.addModuleDirectory(this.xdocDirectory, "fml");
        }
        if (this.moduleExcludes != null) {
            context.setModuleExcludes(this.moduleExcludes);
        }
        return context;
    }

    private DecorationModel getDecorationModel(Locale locale) throws MojoExecutionException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("reports", "<menu ref=\"reports\"/>\n");
        props.put("modules", "<menu ref=\"modules\"/>\n");
        DecorationModel decorationModel = this.getDecorationModel(this.project, locale, props);
        if (decorationModel == null) {
            String siteDescriptorContent;
            try {
                siteDescriptorContent = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/default-site.xml"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading default site descriptor: " + e.getMessage(), (Exception)e);
            }
            try {
                siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(props, this.project, siteDescriptorContent);
            }
            catch (IOException e) {
                throw new MojoExecutionException("The site descriptor cannot interpolate properties: " + e.getMessage(), (Exception)e);
            }
            decorationModel = this.readDecorationModel(siteDescriptorContent);
        }
        this.populateModules(decorationModel, locale, true);
        if (decorationModel.getBannerLeft() == null) {
            Banner banner = new Banner();
            banner.setName(this.project.getName());
            decorationModel.setBannerLeft(banner);
        }
        if (this.project.getUrl() != null) {
            this.assembler.resolvePaths(decorationModel, this.project.getUrl());
        } else {
            this.getLog().warn((CharSequence)"No URL defined for the project - decoration links will not be resolved");
        }
        return decorationModel;
    }

    protected Map locateReports(List reports, Map documents, Locale locale) {
        HashMap<String, MavenReport> reportsByOutputName = new HashMap<String, MavenReport>();
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            String outputName = report.getOutputName() + ".html";
            if (documents.containsKey(outputName)) {
                String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
                this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report, file \"" + outputName + "\" already exists for the " + displayLanguage + " version."));
                i.remove();
                continue;
            }
            reportsByOutputName.put(report.getOutputName(), report);
            RenderingContext renderingContext = new RenderingContext(this.siteDirectory, outputName);
            ReportDocumentRenderer renderer = new ReportDocumentRenderer(report, renderingContext, this.getLog());
            documents.put(outputName, renderer);
        }
        return reportsByOutputName;
    }

    protected Map categoriseReports(Collection reports) {
        HashMap<String, ArrayList<MavenReport>> categories = new HashMap<String, ArrayList<MavenReport>>();
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            ArrayList<MavenReport> categoryReports = (ArrayList<MavenReport>)categories.get(report.getCategoryName());
            if (categoryReports == null) {
                categoryReports = new ArrayList<MavenReport>();
                categories.put(report.getCategoryName(), categoryReports);
            }
            categoryReports.add(report);
        }
        return categories;
    }

    protected Map locateDocuments(SiteRenderingContext context, List reports, Locale locale) throws IOException, RendererException {
        CategorySummaryDocumentRenderer renderer;
        String desc2;
        String desc1;
        String title;
        RenderingContext renderingContext;
        List categoryReports;
        Map documents = this.siteRenderer.locateDocumentFiles(context);
        Map reportsByOutputName = this.locateReports(reports, documents, locale);
        Map categories = this.categoriseReports(reportsByOutputName.values());
        this.populateReportsMenu(context.getDecoration(), locale, categories);
        this.populateReportItems(context.getDecoration(), locale, reportsByOutputName);
        if (categories.containsKey("Project Info")) {
            categoryReports = (List)categories.get("Project Info");
            renderingContext = new RenderingContext(this.siteDirectory, "project-info.html");
            title = this.i18n.getString("site-plugin", locale, "report.information.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.information.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.information.description2"), this.i18n, categoryReports);
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        if (categories.containsKey("Project Reports")) {
            categoryReports = (List)categories.get("Project Reports");
            renderingContext = new RenderingContext(this.siteDirectory, "project-reports.html");
            title = this.i18n.getString("site-plugin", locale, "report.project.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.project.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.project.description2"), this.i18n, categoryReports);
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        return documents;
    }
}

