/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.AbstractSshWagon;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.StringUtils;

public class SftpWagon
extends AbstractSshWagon {
    private static final String SFTP_CHANNEL = "sftp";
    private static final int S_IFDIR = 16384;
    private static final char PATH_SEPARATOR = '/';
    private static final long MILLIS_PER_SEC = 1000L;

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        ChannelSftp channel;
        String basedir = this.getRepository().getBasedir();
        resourceName = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
        String dir = PathUtils.dirname((String)resourceName);
        dir = StringUtils.replace((String)dir, (String)"\\", (String)"/");
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        String filename = resourceName.lastIndexOf(47) > 0 ? resourceName.substring(resourceName.lastIndexOf(47) + 1) : resourceName;
        try {
            channel = (ChannelSftp)this.session.openChannel(SFTP_CHANNEL);
            channel.connect();
            channel.cd(basedir);
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            this.mkdirs(channel, resourceName, this.getDirectoryMode(permissions));
            this.firePutStarted(resource, source);
            channel.put(source.getAbsolutePath(), filename);
            this.postProcessListeners(resource, source, 6);
            if (permissions != null && permissions.getGroup() != null) {
                try {
                    int group = Integer.valueOf(permissions.getGroup());
                    channel.chgrp(group, filename);
                }
                catch (NumberFormatException e) {
                    this.fireTransferDebug("Not setting group: must be a numerical GID for SFTP");
                }
            }
            if (permissions != null && permissions.getFileMode() != null) {
                try {
                    int mode = Integer.valueOf(permissions.getFileMode());
                    channel.chmod(mode, filename);
                }
                catch (NumberFormatException e) {
                    this.fireTransferDebug("Not setting mode: must be a numerical mode for SFTP");
                }
            }
            this.firePutCompleted(resource, source);
            String[] dirs = PathUtils.dirnames((String)dir);
            for (int i = 0; i < dirs.length; ++i) {
                channel.cd("..");
            }
        }
        catch (SftpException e) {
            String msg = "Error occured while deploying '" + resourceName + "' " + "to remote repository: " + this.getRepository().getUrl();
            throw new TransferFailedException(msg, (Throwable)e);
        }
        catch (JSchException e) {
            String msg = "Error occured while deploying '" + resourceName + "' " + "to remote repository: " + this.getRepository().getUrl();
            throw new TransferFailedException(msg, (Throwable)e);
        }
        if (channel != null) {
            channel.disconnect();
        }
    }

    private int getDirectoryMode(RepositoryPermissions permissions) {
        int ret = -1;
        if (permissions != null) {
            try {
                ret = Integer.valueOf(permissions.getDirectoryMode(), 8);
            }
            catch (NumberFormatException e) {
                this.fireTransferDebug("the file mode must be a numerical mode for SFTP");
                ret = -1;
            }
        }
        return ret;
    }

    private void mkdirs(ChannelSftp channel, String resourceName, int mode) throws TransferFailedException, SftpException {
        String[] dirs = PathUtils.dirnames((String)resourceName);
        for (int i = 0; i < dirs.length; ++i) {
            block6: {
                try {
                    SftpATTRS attrs = channel.stat(dirs[i]);
                    if ((attrs.getPermissions() & 0x4000) == 0) {
                        throw new TransferFailedException("Remote path is not a directory:" + PathUtils.dirname((String)resourceName));
                    }
                }
                catch (SftpException e) {
                    channel.mkdir(dirs[i]);
                    if (mode == -1) break block6;
                    try {
                        channel.chmod(mode, dirs[i]);
                    }
                    catch (SftpException e1) {
                        // empty catch block
                    }
                }
            }
            channel.cd(dirs[i]);
        }
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        boolean bDownloaded = true;
        this.createParentDirectories(destination);
        resourceName = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
        String dir = PathUtils.dirname((String)resourceName);
        dir = StringUtils.replace((String)dir, (String)"\\", (String)"/");
        if (dir.length() > 0 && dir.charAt(0) == '/') {
            dir = dir.substring(1);
        }
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        String filename = resourceName.lastIndexOf(47) > 0 ? resourceName.substring(resourceName.lastIndexOf(47) + 1) : resourceName;
        try {
            ChannelSftp channel = (ChannelSftp)this.session.openChannel(SFTP_CHANNEL);
            channel.connect();
            channel.cd(this.repository.getBasedir());
            channel.cd(dir);
            if (timestamp <= 0L || (long)channel.stat(filename).getMTime() * 1000L > timestamp) {
                this.fireGetStarted(resource, destination);
                channel.get(filename, destination.getAbsolutePath());
                this.postProcessListeners(resource, destination, 5);
                this.fireGetCompleted(resource, destination);
                String[] dirs = PathUtils.dirnames((String)dir);
                for (int i = 0; i < dirs.length; ++i) {
                    channel.cd("..");
                }
                bDownloaded = true;
            } else {
                bDownloaded = false;
            }
        }
        catch (SftpException e) {
            this.handleGetException(resource, (Exception)((Object)e), destination);
        }
        catch (JSchException e) {
            this.handleGetException(resource, (Exception)((Object)e), destination);
        }
        return bDownloaded;
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getIfNewer(resourceName, destination, 0L);
    }
}

