/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.TempDirDeleter;

class TempDir {
    static Hashtable<File, Integer> _refCounts = new Hashtable();

    TempDir() {
    }

    static File createGeneratedName(String prefix, File directory) throws IOException {
        File tempFile = File.createTempFile(prefix, "", directory);
        if (!tempFile.delete()) {
            throw new IOException();
        }
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        TempDirDeleter.getInstance().add(tempFile);
        _refCounts.put(tempFile, new Integer(1));
        return tempFile;
    }

    static File createGeneratedName(String prefix) throws IOException {
        return TempDir.createGeneratedName(prefix, null);
    }

    static File createNamed(String name, File directory) throws IOException {
        File tempFile = new File(directory, name);
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        TempDirDeleter.getInstance().add(tempFile);
        _refCounts.put(tempFile, new Integer(1));
        return tempFile;
    }

    static int ref(File dir) {
        int refCount = _refCounts.get(dir);
        _refCounts.put(dir, new Integer(++refCount));
        return refCount;
    }

    static void release(File dir) {
        int refCount = _refCounts.get(dir);
        if (--refCount == 0) {
            TempDirDeleter.getInstance().deleteDirectory(dir);
            _refCounts.remove(dir);
        } else {
            _refCounts.put(dir, new Integer(refCount));
        }
    }

    static File saveStreamToTempDir(InputStream inStream, File tempDir) {
        try {
            FileOutputStream foutStream = null;
            File targetFile = new File(tempDir, "tempOdfFile");
            foutStream = new FileOutputStream(targetFile);
            byte[] buf = new byte[4096];
            int r = 0;
            while ((r = inStream.read(buf, 0, 4096)) > -1) {
                foutStream.write(buf, 0, r);
            }
            foutStream.close();
            return targetFile;
        }
        catch (Exception ex) {
            Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

