/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.type;

import org.odftoolkit.odfdom.dom.type.OdfMeasure;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import org.odftoolkit.odfdom.dom.util.OdfUnitConverter;

public class OdfLengthOrPercent {
    private Object Value = null;

    public void setLength(int length) {
        this.Value = new Integer(length);
    }

    public void setPercent(double percent) {
        this.Value = new Double(percent);
    }

    public boolean isPercent() {
        return this.Value != null && this.Value instanceof Double;
    }

    public int getLength() {
        if (this.isPercent()) {
            throw new IllegalArgumentException("I do not have a length value");
        }
        if (this.Value != null) {
            return (Integer)this.Value;
        }
        return 0;
    }

    public double getPercent() {
        if (this.isPercent()) {
            return (Double)this.Value;
        }
        throw new IllegalArgumentException("I do not have a percent value");
    }

    public static String toString(OdfLengthOrPercent val) {
        if (val == null) {
            throw new IllegalArgumentException("Illegal length or percent value");
        }
        if (val.isPercent()) {
            return String.valueOf(val.getPercent()) + "%";
        }
        return OdfUnitConverter.getMeasureString(val.getLength());
    }

    public static OdfLengthOrPercent valueOf(String value) {
        OdfLengthOrPercent ret = new OdfLengthOrPercent();
        int n = value.indexOf("%");
        if (n != -1) {
            ret.setPercent(OdfPercent.valueOf(value));
        } else {
            ret.setLength(OdfMeasure.valueOf(value));
        }
        return ret;
    }
}

