/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.office.OdfAutomaticStyles;
import org.odftoolkit.odfdom.doc.element.office.OdfStyles;
import org.odftoolkit.odfdom.doc.element.style.OdfStyle;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.style.OdfStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.OdfStylePropertySet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.w3c.dom.DOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OdfStylableElement
extends OdfElement
implements OdfStylePropertySet {
    private static final long serialVersionUID = 3212297545322486428L;
    private OdfStyle mAutomaticStyle;
    protected OdfStyleFamily mFamily;
    protected OdfName mStyleNameAttrib;

    public OdfStylableElement(OdfFileDom ownerDocument, OdfName name, OdfStyleFamily family, OdfName styleNameAttrib) throws DOMException {
        super(ownerDocument, name.getUri(), name.getQName());
        this.mFamily = family;
        this.mStyleNameAttrib = styleNameAttrib;
    }

    public OdfStyleElement getOrCreateUnqiueAutomaticStyle() {
        OdfAutomaticStyles automatic_styles;
        if ((this.mAutomaticStyle == null || this.mAutomaticStyle.getStyleUserCount() > 1) && (automatic_styles = this.getAutomaticStyles()) != null) {
            String sParentStyleName;
            if (this.mAutomaticStyle == null) {
                this.mAutomaticStyle = automatic_styles.createStyle(this.getStyleFamily());
                sParentStyleName = this.getStyleName();
            } else {
                sParentStyleName = this.mAutomaticStyle.getParentStyleName();
                this.mAutomaticStyle.removeStyleUser(this);
                this.mAutomaticStyle = automatic_styles.makeStyleUnique(this.mAutomaticStyle);
            }
            this.mAutomaticStyle.addStyleUser(this);
            if (sParentStyleName != null && sParentStyleName.length() != 0) {
                this.mAutomaticStyle.setParentStyleName(sParentStyleName);
            }
            this.setStyleName(this.mAutomaticStyle.getName());
        }
        return this.mAutomaticStyle;
    }

    public OdfAutomaticStyles getAutomaticStyles() {
        OdfFileDom fileDom = (OdfFileDom)this.ownerDocument;
        if (fileDom != null) {
            return fileDom.getAutomaticStyles();
        }
        return null;
    }

    public void setAttributeNS(String uri, String name, String value) {
        super.setAttributeNS(uri, name, value);
        if (this.mStyleNameAttrib.equals(uri, name)) {
            OdfStyle autoStyle = null;
            if (this.mAutomaticStyle == null || !this.mAutomaticStyle.getName().equals(value)) {
                OdfAutomaticStyles automatic_styles = this.getAutomaticStyles();
                if (automatic_styles != null) {
                    autoStyle = automatic_styles.getStyle(value, this.getStyleFamily());
                }
                if (this.mAutomaticStyle != null) {
                    this.mAutomaticStyle.removeStyleUser(this);
                }
                this.mAutomaticStyle = autoStyle;
                if (this.mAutomaticStyle != null) {
                    this.mAutomaticStyle.addStyleUser(this);
                }
            }
        }
    }

    public String getStyleName() {
        return this.getAttributeNS(this.mStyleNameAttrib.getUri(), this.mStyleNameAttrib.getLocalName());
    }

    public void setStyleName(String name) {
        this.setAttributeNS(this.mStyleNameAttrib.getUri(), this.mStyleNameAttrib.getLocalName(), name);
    }

    public OdfStyle getAutomaticStyle() {
        return this.mAutomaticStyle;
    }

    public boolean hasAutomaticStyle() {
        return this.mAutomaticStyle != null;
    }

    public OdfStyle reuseDocumentStyle(String styleName) {
        OdfStyle style = null;
        if (styleName != null && (style = this.mOdfDocument.getDocumentStyles().getStyle(styleName, this.getStyleFamily())) != null) {
            this.setDocumentStyle(style);
        }
        return style;
    }

    public void setDocumentStyle(OdfStyle style) {
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.setParentStyleName(style.getName());
        } else {
            this.setStyleName(style.getName());
        }
    }

    public OdfStyle getDocumentStyle() {
        String styleName = this.mAutomaticStyle != null ? this.mAutomaticStyle.getParentStyleName() : this.getStyleName();
        return this.mOdfDocument.getDocumentStyles().getStyle(styleName, this.getStyleFamily());
    }

    public boolean hasDocumentStyle() {
        return this.getDocumentStyle() != null;
    }

    public OdfStyleFamily getStyleFamily() {
        return this.mFamily;
    }

    @Override
    public String getProperty(OdfStyleProperty property) {
        OdfStyle style = this.mAutomaticStyle;
        if (style == null) {
            style = this.getOfficeStyle();
        }
        if (style != null) {
            return style.getProperty(property);
        }
        return null;
    }

    @Override
    public Map<OdfStyleProperty, String> getProperties(Set<OdfStyleProperty> properties) {
        HashMap<OdfStyleProperty, String> map = new HashMap<OdfStyleProperty, String>();
        for (OdfStyleProperty property : properties) {
            map.put(property, this.getProperty(property));
        }
        return map;
    }

    @Override
    public Set<OdfStyleProperty> getStrictProperties() {
        return this.getStyleFamily().getProperties();
    }

    @Override
    public boolean hasProperty(OdfStyleProperty property) {
        return this.mAutomaticStyle != null && this.mAutomaticStyle.hasProperty(property);
    }

    @Override
    public void removeProperty(OdfStyleProperty property) {
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.removeProperty(property);
        }
    }

    @Override
    public void setProperties(Map<OdfStyleProperty, String> properties) {
        for (Map.Entry<OdfStyleProperty, String> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(OdfStyleProperty property, String value) {
        this.getOrCreateUnqiueAutomaticStyle().setProperty(property, value);
    }

    @Override
    protected void onInsertNode() {
        super.onInsertNode();
        String stylename = this.getStyleName();
        if (stylename.length() != 0) {
            OdfAutomaticStyles automatic_styles;
            if (this.mAutomaticStyle != null) {
                if (this.mAutomaticStyle.getName().equals(stylename)) {
                    return;
                }
                this.mAutomaticStyle.removeStyleUser(this);
                this.mAutomaticStyle = null;
            }
            if ((automatic_styles = this.getAutomaticStyles()) != null) {
                this.mAutomaticStyle = automatic_styles.getStyle(stylename, this.getStyleFamily());
                if (this.mAutomaticStyle != null) {
                    this.mAutomaticStyle.addStyleUser(this);
                }
            }
        }
    }

    @Override
    protected void onRemoveNode() {
        super.onInsertNode();
        if (this.mAutomaticStyle != null) {
            this.mAutomaticStyle.removeStyleUser(this);
            this.mAutomaticStyle = null;
        }
    }

    private OdfStyle getOfficeStyle() {
        OdfStyles styles = this.mOdfDocument.getDocumentStyles();
        if (styles != null) {
            return styles.getStyle(this.getStyleName(), this.getStyleFamily());
        }
        return null;
    }
}

