/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import org.odftoolkit.odfdom.dom.OdfName;

public class OdfNamespace
implements Comparable,
NamespaceContext {
    private static Map<String, String> namesspacesByPrefix = new HashMap<String, String>();
    private static Map<String, String> namesspacesByUri = new HashMap<String, String>();
    private String m_uri;
    private String m_prefix;
    private static SortedSet m_namespaces;
    public static final OdfNamespace A;
    public static final OdfNamespace ANIM;
    public static final OdfNamespace DR3D;
    public static final OdfNamespace DB;
    public static final OdfNamespace DC;
    public static final OdfNamespace DRAW;
    public static final OdfNamespace CHART;
    public static final OdfNamespace CONFIG;
    public static final OdfNamespace FO;
    public static final OdfNamespace FORM;
    public static final OdfNamespace GRDDL;
    public static final OdfNamespace MATH;
    public static final OdfNamespace META;
    public static final OdfNamespace NUMBER;
    public static final OdfNamespace OFFICE;
    public static final OdfNamespace PRESENTATION;
    public static final OdfNamespace SCRIPT;
    public static final OdfNamespace STYLE;
    public static final OdfNamespace SMIL;
    public static final OdfNamespace SVG;
    public static final OdfNamespace TABLE;
    public static final OdfNamespace TEXT;
    public static final OdfNamespace XFORMS;
    public static final OdfNamespace XHTML;
    public static final OdfNamespace XLINK;
    public static final OdfNamespace XML;

    public OdfNamespace() {
    }

    private OdfNamespace(String uri) {
        this(null, uri);
    }

    private OdfNamespace(String prefix, String uri) {
        if (uri != null && uri.length() > 0) {
            this.m_uri = uri;
        }
        if (prefix != null && prefix.length() > 0) {
            this.m_prefix = prefix;
        }
    }

    public OdfName getOdfName(String name) {
        int i = name.indexOf(58);
        if (i >= 0) {
            return OdfName.get(this, name.substring(i + 1));
        }
        return OdfName.get(this, name);
    }

    public static OdfNamespace get(String uri) {
        OdfNamespace result;
        OdfNamespace newns = new OdfNamespace(uri);
        SortedSet<OdfNamespace> tail = m_namespaces.tailSet(newns);
        if (tail.size() > 0 && (result = tail.first()).equals(uri)) {
            return result;
        }
        m_namespaces.add(newns);
        return newns;
    }

    public static OdfNamespace get(String prefix, String uri) {
        OdfNamespace newns = new OdfNamespace(prefix, uri);
        SortedSet<OdfNamespace> tail = m_namespaces.tailSet(newns);
        for (Object e : tail) {
            OdfNamespace result = (OdfNamespace)e;
            if (!((Object)tail.first()).equals(uri)) break;
            if (!result.getPrefix().equals(prefix)) continue;
            return result;
        }
        m_namespaces.add(newns);
        return newns;
    }

    public boolean hasPrefix() {
        return this.m_prefix != null;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public String getUri() {
        return this.m_uri;
    }

    public boolean equals(Object obj) {
        if (this.m_uri != null) {
            return this.m_uri.equals(obj.toString());
        }
        return this.m_uri == obj;
    }

    public int hashCode() {
        if (this.m_uri != null) {
            return this.m_uri.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.m_uri;
    }

    public static String[] splitQName(String qname) {
        String localpart = qname;
        String prefix = null;
        int colon = qname.indexOf(58);
        if (colon > 0) {
            localpart = qname.substring(colon + 1);
            prefix = qname.substring(0, colon);
        }
        return new String[]{prefix, localpart};
    }

    public static String getPrefixPart(String qname) {
        return OdfNamespace.splitQName(qname)[0];
    }

    public static String getLocalPart(String qname) {
        return OdfNamespace.splitQName(qname)[1];
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public String getNamespaceURI(String prefix) {
        return namesspacesByPrefix.get(prefix);
    }

    public static String getNamespaceURIByPrefix(String prefix) {
        return namesspacesByPrefix.get(prefix);
    }

    public String getPrefix(String namespaceUri) {
        return namesspacesByUri.get(namespaceUri);
    }

    public Iterator getPrefixes(String namespaceuri) {
        return namesspacesByPrefix.keySet().iterator();
    }

    static {
        for (OOoNamespace ns : OOoNamespace.values()) {
            namesspacesByPrefix.put(ns.mPrefix, ns.mNamespaceUri);
            namesspacesByUri.put(ns.mNamespaceUri, ns.mPrefix);
        }
        m_namespaces = new TreeSet();
        A = OdfNamespace.get("a", "http://relaxng.org/ns/compatibility/annotations/1.0");
        ANIM = OdfNamespace.get("anim", "urn:oasis:names:tc:opendocument:xmlns:animation:1.0");
        DR3D = OdfNamespace.get("dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        DB = OdfNamespace.get("db", "urn:oasis:names:tc:opendocument:xmlns:database:1.0");
        DC = OdfNamespace.get("dc", "http://purl.org/dc/elements/1.1/");
        DRAW = OdfNamespace.get("draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        CHART = OdfNamespace.get("chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        CONFIG = OdfNamespace.get("config", "urn:oasis:names:tc:opendocument:xmlns:config:1.0");
        FO = OdfNamespace.get("fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        FORM = OdfNamespace.get("form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        GRDDL = OdfNamespace.get("grddl", "http://www.w3.org/2003/g/data-view#");
        MATH = OdfNamespace.get("math", "http://www.w3.org/1998/Math/MathML");
        META = OdfNamespace.get("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        NUMBER = OdfNamespace.get("number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        OFFICE = OdfNamespace.get("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        PRESENTATION = OdfNamespace.get("presentation", "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0");
        SCRIPT = OdfNamespace.get("script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        STYLE = OdfNamespace.get("style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        SMIL = OdfNamespace.get("smil", "urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0");
        SVG = OdfNamespace.get("svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        TABLE = OdfNamespace.get("table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        TEXT = OdfNamespace.get("text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        XFORMS = OdfNamespace.get("xforms", "http://www.w3.org/2002/xforms");
        XHTML = OdfNamespace.get("xhtml", "http://www.w3.org/1999/xhtml");
        XLINK = OdfNamespace.get("xlink", "http://www.w3.org/1999/xlink");
        XML = OdfNamespace.get("xml", "http://www.w3.org/XML/1998/namespace");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OOoNamespace {
        A("a", "http://relaxng.org/ns/compatibility/annotations/1.0"),
        ANIM("anim", "urn:oasis:names:tc:opendocument:xmlns:animation:1.0"),
        CHART("chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0"),
        CONFIG("config", "urn:oasis:names:tc:opendocument:xmlns:config:1.0"),
        DB("db", "urn:oasis:names:tc:opendocument:xmlns:database:1.0"),
        DC("dc", "http://purl.org/dc/elements/1.1/"),
        DR3D("dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0"),
        DRAW("draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0"),
        FO("fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0"),
        FORM("form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0"),
        GRDDL("grddl", "http://www.w3.org/2003/g/data-view#"),
        MATH("math", "http://www.w3.org/1998/Math/MathML"),
        META("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0"),
        NUMBER("number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0"),
        OFFICE("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0"),
        PRESENTATION("presentation", "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0"),
        SCRIPT("script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0"),
        SMIL("smil", "urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0"),
        STYLE("style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0"),
        SVG("svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0"),
        TABLE("table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0"),
        TEXT("text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0"),
        XFORMS("xforms", "http://www.w3.org/2002/xforms"),
        XHTML("xhtml", "http://www.w3.org/1999/xhtml"),
        XLINK("xlink", "http://www.w3.org/1999/xlink"),
        XML("xml", "http://www.w3.org/XML/1998/namespace");

        private String mPrefix;
        private String mNamespaceUri;

        private OOoNamespace(String prefix, String namespaceUri) {
            this.mPrefix = prefix;
            this.mNamespaceUri = namespaceUri;
        }
    }
}

