/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.util.HashMap;
import org.odftoolkit.odfdom.dom.OdfNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfName
implements Comparable<OdfName> {
    private OdfNamespace m_ns;
    private String m_localname;
    private String m_fullstring;
    private static HashMap<String, OdfName> m_names = new HashMap();

    private void init(OdfNamespace ns, String localname) {
        this.m_ns = ns;
        this.m_localname = localname;
        StringBuilder b = new StringBuilder();
        b.append('{');
        b.append(this.m_ns.toString());
        b.append('}');
        b.append(this.m_localname);
        this.m_fullstring = b.toString();
    }

    private OdfName(OdfNamespace ns, String localname) {
        int i = 0;
        i = localname.indexOf(58);
        if (i >= 0) {
            localname = localname.substring(i + 1);
        }
        this.init(ns, localname);
    }

    private OdfName(String uri, String qname) {
        String[] qnpair = OdfNamespace.splitQName(qname);
        OdfNamespace ns = OdfNamespace.get(qnpair[0], uri);
        this.init(ns, qnpair[1]);
    }

    public static OdfName get(OdfName name) {
        OdfName n = m_names.get(name.toString());
        if (n != null) {
            return n;
        }
        m_names.put(name.toString(), name);
        return name;
    }

    public static OdfName get(OdfNamespace ns, String localname) {
        return OdfName.get(new OdfName(ns, localname));
    }

    public static OdfName get(String uri, String localname) {
        return OdfName.get(new OdfName(uri, localname));
    }

    public String getUri() {
        return this.m_ns.getUri();
    }

    public String getLocalName() {
        return this.m_localname;
    }

    public String getQName() {
        if (this.m_ns.hasPrefix()) {
            return this.m_ns.getPrefix() + ":" + this.m_localname;
        }
        return this.m_localname;
    }

    public String toString() {
        return this.m_fullstring;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public boolean equals(String uri, String local_name) {
        if (!this.m_ns.getUri().equals(uri)) {
            return false;
        }
        int beginIndex = local_name.indexOf(58);
        if (beginIndex >= 0) {
            return this.m_localname.equals(local_name.substring(beginIndex + 1));
        }
        return this.m_localname.equals(local_name);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(OdfName o) {
        return this.toString().compareTo(o.toString());
    }
}

