/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.table;

import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.table.OdfCoveredTableCell;
import org.odftoolkit.odfdom.doc.element.table.OdfTable;
import org.odftoolkit.odfdom.doc.element.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.element.table.OdfTableCellBase;
import org.odftoolkit.odfdom.dom.element.table.OdfCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.OdfTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.OdfTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.OdfTableRowElement;
import org.odftoolkit.odfdom.dom.util.DomNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class OdfTableRow
extends OdfTableRowElement {
    private static final long serialVersionUID = -786721372779697783L;
    private int mCurrentNumberOfColumns = 0;

    public OdfTableRow(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfTable getTable() {
        return this.getAncestorAs(OdfTable.class);
    }

    public Node removeCell(Node remChild) throws DOMException {
        if (remChild instanceof OdfTableCell) {
            OdfTableCell td = (OdfTableCell)((Object)remChild);
            int nColSpan = td.getNumberColumnsSpanned();
            int nColRepeat = td.getNumberColumnsRepeated();
            int nColVanish = Math.max(nColSpan, nColRepeat);
            this.mCurrentNumberOfColumns -= nColVanish;
        }
        return super.removeChild(remChild);
    }

    public Node appendCell(Node newChild) throws DOMException {
        OdfCoveredTableCell aOldCoveredCell = null;
        if (newChild instanceof OdfCoveredTableCell && !((OdfCoveredTableCell)((Object)newChild)).isAutoGenerated()) {
            for (Node aTestNode = super.getLastChild(); aTestNode != null; aTestNode = aTestNode.getPreviousSibling()) {
                if (aTestNode instanceof OdfCoveredTableCell) {
                    if (!((OdfCoveredTableCell)((Object)aTestNode)).isAutoGenerated()) break;
                    aOldCoveredCell = (OdfCoveredTableCell)((Object)aTestNode);
                    continue;
                }
                if (aTestNode instanceof OdfTableCell) break;
            }
        }
        Node aNode = null;
        if (aOldCoveredCell != null) {
            ((OdfCoveredTableCell)((Object)newChild)).setNumberRowsSpanned(aOldCoveredCell.getNumberRowsSpanned());
            ((OdfCoveredTableCell)((Object)newChild)).setNumberColumnsSpanned(aOldCoveredCell.getNumberColumnsSpanned());
            aNode = newChild;
            Node nextCovered = aOldCoveredCell.getNextSibling();
            this.replaceChild(newChild, (Node)((Object)aOldCoveredCell));
            int repeated = ((OdfCoveredTableCell)((Object)newChild)).getNumberColumnsRepeated();
            while (repeated > 1 && nextCovered != null && nextCovered instanceof OdfCoveredTableCell && ((OdfCoveredTableCell)((Object)nextCovered)).isAutoGenerated()) {
                Node removeNode = nextCovered;
                nextCovered = nextCovered.getNextSibling();
                this.removeChild(removeNode);
                --repeated;
                --this.mCurrentNumberOfColumns;
            }
        } else {
            aNode = super.appendChild(newChild);
        }
        if (aNode instanceof OdfTableCell) {
            int count;
            OdfTableCell td = (OdfTableCell)((Object)aNode);
            int nColSpan = td.getNumberColumnsSpanned();
            int nColRepeat = td.getNumberColumnsRepeated();
            int nStartCol = this.mCurrentNumberOfColumns;
            int nColAdd = Math.max(nColSpan, nColRepeat);
            int nEndCol = nStartCol + nColAdd;
            OdfTable table = this.getTable();
            if (table != null && (count = table.getTableColumnCount()) < nEndCol) {
                if (nColRepeat > 1) {
                    table.addTableColumn(nEndCol - count);
                } else {
                    for (int i = 0; i < nEndCol - count; ++i) {
                        table.addTableColumn(1);
                    }
                }
            }
            this.mCurrentNumberOfColumns += nColAdd;
            if (nColSpan > 1) {
                this.appendCoveredCells(nColSpan - 1, td.getNumberRowsSpanned(), aNode);
            }
            this.inheritSpannedCells(nEndCol);
        }
        return aNode;
    }

    private void appendCoveredCells(int nColSpan, int nRowSpan, Node aNode) {
        while (nColSpan > 0) {
            OdfCoveredTableCell aCTC = (OdfCoveredTableCell)((Object)this.getOwnerDocument().createElementNS(OdfCoveredTableCellElement.ELEMENT_NAME.getUri(), OdfCoveredTableCellElement.ELEMENT_NAME.getQName()));
            aCTC.setNumberColumnsSpanned(nColSpan);
            aCTC.setNumberRowsSpanned(nRowSpan);
            aCTC.setAutoGenerated();
            this.appendChild((Node)((Object)aCTC));
            --nColSpan;
        }
    }

    public void inheritSpannedCells(int nCol) {
        OdfTableCellElementBase aUpperCell;
        OdfTableRow aPrevRow = this.getPreviousRow();
        if (aPrevRow == null) {
            return;
        }
        Node aUpperNode = aPrevRow.getCellAt(nCol);
        if (aUpperNode == null) {
            return;
        }
        int nCoveredCellsToAdd = 0;
        int nUpperRowSpan = 1;
        if (aUpperNode instanceof OdfTableCell && (nUpperRowSpan = ((OdfTableCellElement)(aUpperCell = (OdfTableCell)((Object)aUpperNode))).getNumberRowsSpanned().intValue()) > 1) {
            nCoveredCellsToAdd = ((OdfTableCellElement)aUpperCell).getNumberColumnsSpanned();
        }
        if (aUpperNode instanceof OdfCoveredTableCell && (nUpperRowSpan = ((OdfCoveredTableCell)(aUpperCell = (OdfCoveredTableCell)((Object)aUpperNode))).getNumberRowsSpanned().intValue()) > 1) {
            nCoveredCellsToAdd = ((OdfCoveredTableCell)aUpperCell).getNumberColumnsSpanned();
        }
        if (nCoveredCellsToAdd == 0) {
            return;
        }
        this.mCurrentNumberOfColumns += nCoveredCellsToAdd;
        this.appendCoveredCells(nCoveredCellsToAdd, nUpperRowSpan - 1, null);
    }

    public OdfTableRow getPreviousRow() {
        for (Node aPrevNode = this.getPreviousSibling(); aPrevNode != null; aPrevNode = aPrevNode.getPreviousSibling()) {
            if (!(aPrevNode instanceof OdfTableRow)) continue;
            return (OdfTableRow)((Object)aPrevNode);
        }
        return null;
    }

    public Node getCellAt(int nCol) {
        for (Node n : new DomNodeList(this.getChildNodes())) {
            if (!(n instanceof OdfTableCell) && !(n instanceof OdfCoveredTableCell)) continue;
            if (nCol == 0) {
                return n;
            }
            nCol -= ((OdfTableCellBase)((Object)n)).getNumberColumnsRepeated().intValue();
        }
        return null;
    }
}

