/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.table;

import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.table.OdfTableColumn;
import org.odftoolkit.odfdom.doc.element.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.element.table.OdfTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.OdfTableElement;
import org.odftoolkit.odfdom.dom.util.DomNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfTable
extends OdfTableElement {
    private static final long serialVersionUID = 5690924242559379435L;
    private int mCurrentNumberOfColumns = 0;

    public OdfTable(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfTableColumn getTableColumn(int c) {
        List<OdfTableColumn> list = this.getTableColumnList();
        if (list.size() > c) {
            return list.get(c);
        }
        return null;
    }

    public List<OdfTableColumn> getTableColumnList() {
        return this.makeTableColumnList();
    }

    public int getTableColumnCount() {
        return this.mCurrentNumberOfColumns;
    }

    public OdfTableColumn addTableColumn() {
        return this.addTableColumn(1);
    }

    public OdfTableColumn addTableColumn(int repeat) {
        Node ref = this.getFirstChild();
        for (Node n : new DomNodeList(this.getChildNodes())) {
            if (!(n instanceof OdfTableColumn)) continue;
            ref = n.getNextSibling();
        }
        OdfTableColumn tce = (OdfTableColumn)((Object)this.getOwnerDocument().createElementNS(OdfTableColumnElement.ELEMENT_NAME.getUri(), OdfTableColumnElement.ELEMENT_NAME.getQName()));
        tce = ref != null ? (OdfTableColumn)((Object)this.insertBefore((Node)((Object)tce), ref)) : (OdfTableColumn)((Object)this.appendChild((Node)((Object)tce)));
        if (repeat > 1) {
            tce.setNumberColumnsRepeated(repeat);
        }
        this.mCurrentNumberOfColumns += repeat;
        return tce;
    }

    private List<OdfTableColumn> makeTableColumnList() {
        ArrayList<OdfTableColumn> list = new ArrayList<OdfTableColumn>();
        for (Node n : new DomNodeList(this.getChildNodes())) {
            if (n instanceof OdfTableColumn) {
                OdfTableColumn col = (OdfTableColumn)((Object)n);
                for (int i = 0; i < col.getNumberColumnsRepeated(); ++i) {
                    list.add(col);
                }
                continue;
            }
            if (!(n instanceof OdfTableRow)) continue;
            break;
        }
        return list;
    }

    public void setColumnList(List<OdfTableColumn> cl) {
        ArrayList<Node> rmList = new ArrayList<Node>();
        for (Node n : new DomNodeList(this.getChildNodes())) {
            if (!(n instanceof OdfTableColumn)) continue;
            rmList.add(n);
        }
        for (Node n : rmList) {
            this.removeChild(n);
        }
        Node ref = this.getFirstChild();
        OdfTableColumn prev = null;
        for (OdfTableColumn tce : cl) {
            if (prev == null || prev != tce) {
                this.insertBefore((Node)((Object)tce), ref);
                prev = tce;
                continue;
            }
            if (tce == null) continue;
            tce.setNumberColumnsRepeated(tce.getNumberColumnsRepeated() + 1);
        }
    }

    public Node appendRow(Node aNewChild) throws DOMException {
        Node aNode = super.appendChild(aNewChild);
        if (aNode instanceof OdfTableRow) {
            OdfTableRow aRow = (OdfTableRow)((Object)aNode);
            aRow.inheritSpannedCells(0);
        } else if (aNode instanceof OdfTableColumn) {
            ++this.mCurrentNumberOfColumns;
        }
        return aNode;
    }
}

