/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.office;

import java.util.HashMap;
import java.util.Vector;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.draw.OdfFillImage;
import org.odftoolkit.odfdom.doc.element.draw.OdfGradient;
import org.odftoolkit.odfdom.doc.element.draw.OdfHatch;
import org.odftoolkit.odfdom.doc.element.draw.OdfMarker;
import org.odftoolkit.odfdom.doc.element.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.doc.element.style.OdfStyle;
import org.odftoolkit.odfdom.doc.element.text.OdfListStyle;
import org.odftoolkit.odfdom.doc.element.text.OdfOutlineStyle;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.office.OdfStylesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfStyles
extends OdfStylesElement {
    private static final long serialVersionUID = 700763983193326060L;
    HashMap<OdfStyleFamily, OdfDefaultStyle> mDefaultStyles;
    private HashMap<OdfStyleFamily, HashMap<String, OdfStyle>> mStyles;
    private HashMap<String, OdfListStyle> mListStyles;
    private HashMap<String, OdfMarker> mMarker;
    private HashMap<String, OdfGradient> mGradients;
    private HashMap<String, OdfHatch> mHatches;
    private HashMap<String, OdfFillImage> mFillImages;
    private OdfOutlineStyle mOutlineStyle;

    public OdfStyles(OdfFileDom _aOwnerDoc) {
        super(_aOwnerDoc);
    }

    public OdfStyle createStyle(String name, OdfStyleFamily family) {
        OdfStyle newStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStyle.class);
        newStyle.setName(name);
        newStyle.setFamily(family);
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfDefaultStyle getOrCreateDefaultStyle(OdfStyleFamily family) {
        OdfDefaultStyle style = this.getDefaultStyle(family);
        if (style == null) {
            style = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDefaultStyle.class);
            style.setFamily(family);
            this.appendChild((Node)((Object)style));
        }
        return style;
    }

    public OdfListStyle createListStyle(String name) {
        OdfListStyle newStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListStyle.class);
        newStyle.setName(name);
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfOutlineStyle getOrCreateOutlineStyle() {
        if (this.mOutlineStyle == null) {
            this.appendChild((Node)((Object)((OdfFileDom)this.ownerDocument).createOdfElement(OdfOutlineStyle.class)));
        }
        return this.mOutlineStyle;
    }

    public OdfOutlineStyle getOutlineStyle() {
        return this.mOutlineStyle;
    }

    public OdfDefaultStyle getDefaultStyle(OdfStyleFamily familyType) {
        if (this.mDefaultStyles != null) {
            return this.mDefaultStyles.get(familyType);
        }
        return null;
    }

    public Iterable<OdfDefaultStyle> getDefaultStyles() {
        if (this.mDefaultStyles != null) {
            return this.mDefaultStyles.values();
        }
        return new Vector<OdfDefaultStyle>();
    }

    public OdfStyle getStyle(String name, OdfStyleFamily familyType) {
        HashMap<String, OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            return familyMap.get(name);
        }
        return null;
    }

    public Iterable<OdfStyle> getStylesForFamily(OdfStyleFamily familyType) {
        HashMap<String, OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            return familyMap.values();
        }
        return new Vector<OdfStyle>();
    }

    public OdfListStyle getListStyle(String name) {
        if (this.mListStyles != null) {
            return this.mListStyles.get(name);
        }
        return null;
    }

    public Iterable<OdfListStyle> getListStyles() {
        if (this.mListStyles != null) {
            return this.mListStyles.values();
        }
        return new Vector<OdfListStyle>();
    }

    public OdfMarker getMarker(String name) {
        if (this.mMarker != null) {
            return this.mMarker.get(name);
        }
        return null;
    }

    public Iterable<OdfMarker> getMarker() {
        if (this.mMarker != null) {
            return this.mMarker.values();
        }
        return new Vector<OdfMarker>();
    }

    public OdfGradient getGradient(String name) {
        if (this.mGradients != null) {
            return this.mGradients.get(name);
        }
        return null;
    }

    public Iterable<OdfGradient> getGradients() {
        if (this.mGradients != null) {
            return this.mGradients.values();
        }
        return new Vector<OdfGradient>();
    }

    public OdfHatch getHatch(String name) {
        if (this.mHatches != null) {
            return this.mHatches.get(name);
        }
        return null;
    }

    public Iterable<OdfHatch> getHatches() {
        if (this.mHatches != null) {
            return this.mHatches.values();
        }
        return new Vector<OdfHatch>();
    }

    public OdfFillImage getFillImage(String name) {
        if (this.mFillImages != null) {
            return this.mFillImages.get(name);
        }
        return null;
    }

    public Iterable<OdfFillImage> getFillImages() {
        if (this.mFillImages != null) {
            return this.mFillImages.values();
        }
        return new Vector<OdfFillImage>();
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfDefaultStyle) {
            OdfDefaultStyle defaultStyle = (OdfDefaultStyle)node;
            if (this.mDefaultStyles == null) {
                this.mDefaultStyles = new HashMap();
            }
            this.mDefaultStyles.put(defaultStyle.getFamily(), defaultStyle);
        } else if (node instanceof OdfStyle) {
            HashMap<String, OdfStyle> familyMap;
            OdfStyle style = (OdfStyle)node;
            if (this.mStyles == null) {
                this.mStyles = new HashMap();
            }
            if ((familyMap = this.mStyles.get(style.getFamily())) == null) {
                familyMap = new HashMap();
                this.mStyles.put(style.getFamily(), familyMap);
            }
            familyMap.put(style.getName(), style);
        } else if (node instanceof OdfListStyle) {
            OdfListStyle listStyle = (OdfListStyle)node;
            if (this.mListStyles == null) {
                this.mListStyles = new HashMap();
            }
            this.mListStyles.put(listStyle.getName(), listStyle);
        } else if (node instanceof OdfMarker) {
            OdfMarker marker = (OdfMarker)node;
            if (this.mMarker == null) {
                this.mMarker = new HashMap();
            }
            this.mMarker.put(marker.getName(), marker);
        } else if (node instanceof OdfGradient) {
            OdfGradient gradient = (OdfGradient)node;
            if (this.mGradients == null) {
                this.mGradients = new HashMap();
            }
            this.mGradients.put(gradient.getName(), gradient);
        } else if (node instanceof OdfHatch) {
            OdfHatch hatch = (OdfHatch)node;
            if (this.mHatches == null) {
                this.mHatches = new HashMap();
            }
            this.mHatches.put(hatch.getName(), hatch);
        } else if (node instanceof OdfFillImage) {
            OdfFillImage fillImage = (OdfFillImage)node;
            if (this.mFillImages == null) {
                this.mFillImages = new HashMap();
            }
            this.mFillImages.put(fillImage.getName(), fillImage);
        } else if (node instanceof OdfOutlineStyle) {
            this.mOutlineStyle = (OdfOutlineStyle)node;
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfDefaultStyle) {
            if (this.mDefaultStyles != null) {
                OdfDefaultStyle defaultStyle = (OdfDefaultStyle)node;
                this.mDefaultStyles.remove(defaultStyle.getFamily());
            }
        } else if (node instanceof OdfStyle) {
            OdfStyle style;
            HashMap<String, OdfStyle> familyMap;
            if (this.mStyles != null && (familyMap = this.mStyles.get((style = (OdfStyle)node).getFamily())) != null) {
                familyMap.remove(style.getName());
                if (familyMap.isEmpty()) {
                    this.mStyles.remove(style.getFamily());
                }
            }
        } else if (node instanceof OdfListStyle) {
            if (this.mListStyles != null) {
                OdfListStyle listStyle = (OdfListStyle)node;
                this.mListStyles.remove(listStyle.getName());
            }
        } else if (node instanceof OdfMarker) {
            if (this.mMarker != null) {
                OdfMarker marker = (OdfMarker)node;
                this.mMarker.remove(marker.getName());
            }
        } else if (node instanceof OdfGradient) {
            if (this.mGradients != null) {
                OdfGradient gradient = (OdfGradient)node;
                this.mGradients.remove(gradient.getName());
            }
        } else if (node instanceof OdfHatch) {
            if (this.mHatches != null) {
                OdfHatch hatch = (OdfHatch)node;
                this.mHatches.remove(hatch.getName());
            }
        } else if (node instanceof OdfFillImage) {
            if (this.mFillImages != null) {
                OdfFillImage fillImage = (OdfFillImage)node;
                this.mFillImages.remove(fillImage.getName());
            }
        } else if (node instanceof OdfOutlineStyle && this.mOutlineStyle == (OdfOutlineStyle)node) {
            this.mOutlineStyle = null;
        }
    }
}

