/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.office;

import java.util.HashMap;
import java.util.Vector;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.style.OdfPageLayout;
import org.odftoolkit.odfdom.doc.element.style.OdfStyle;
import org.odftoolkit.odfdom.doc.element.text.OdfListStyle;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.office.OdfAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfAutomaticStyles
extends OdfAutomaticStylesElement {
    private static final long serialVersionUID = -2925910664631016175L;
    private HashMap<OdfStyleFamily, HashMap<String, OdfStyle>> mStyles;
    private HashMap<String, OdfPageLayout> mPageLayouts;
    private HashMap<String, OdfListStyle> mListStyles;

    public OdfAutomaticStyles(OdfFileDom _aOwnerDoc) {
        super(_aOwnerDoc);
    }

    public OdfStyle createStyle(OdfStyleFamily styleFamily) {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfStyle newStyle = dom.createOdfElement(OdfStyle.class);
        newStyle.setFamily(styleFamily);
        newStyle.setName(this.createUniqueStyleName(styleFamily));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfListStyle createListStyle() {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfListStyle newStyle = dom.createOdfElement(OdfListStyle.class);
        newStyle.setName(this.createUniqueStyleName(OdfStyleFamily.List));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfStyle getStyle(String name, OdfStyleFamily familyType) {
        HashMap<String, OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            return familyMap.get(name);
        }
        return null;
    }

    public Iterable<OdfStyle> getStylesForFamily(OdfStyleFamily familyType) {
        HashMap<String, OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            return familyMap.values();
        }
        return new Vector<OdfStyle>();
    }

    public OdfListStyle getListStyle(String name) {
        if (this.mListStyles != null) {
            return this.mListStyles.get(name);
        }
        return null;
    }

    public Iterable<OdfListStyle> getListStyles() {
        if (this.mListStyles != null) {
            return this.mListStyles.values();
        }
        return new Vector<OdfListStyle>();
    }

    public OdfPageLayout getPageLayout(String name) {
        if (this.mPageLayouts != null) {
            return this.mPageLayouts.get(name);
        }
        return null;
    }

    public OdfStyle makeStyleUnique(OdfStyle referenceStyle) {
        OdfStyle newStyle = null;
        newStyle = referenceStyle.getOwnerDocument() != this.getOwnerDocument() ? (OdfStyle)((Object)this.getOwnerDocument().importNode((Node)((Object)referenceStyle), true)) : (OdfStyle)((Object)referenceStyle.cloneNode(true));
        newStyle.setName(this.createUniqueStyleName(newStyle.getFamily()));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfStyle) {
            HashMap<String, OdfStyle> familyMap;
            OdfStyle style = (OdfStyle)node;
            if (this.mStyles == null) {
                this.mStyles = new HashMap();
            }
            if ((familyMap = this.mStyles.get(style.getFamily())) == null) {
                familyMap = new HashMap();
                this.mStyles.put(style.getFamily(), familyMap);
            }
            familyMap.put(style.getName(), style);
        } else if (node instanceof OdfListStyle) {
            OdfListStyle listStyle = (OdfListStyle)node;
            if (this.mListStyles == null) {
                this.mListStyles = new HashMap();
            }
            this.mListStyles.put(listStyle.getName(), listStyle);
        } else if (node instanceof OdfPageLayout) {
            OdfPageLayout pageLayout = (OdfPageLayout)node;
            if (this.mPageLayouts == null) {
                this.mPageLayouts = new HashMap();
            }
            this.mPageLayouts.put(pageLayout.getName(), pageLayout);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfStyle) {
            OdfStyle style;
            HashMap<String, OdfStyle> familyMap;
            if (this.mStyles != null && (familyMap = this.mStyles.get((style = (OdfStyle)node).getFamily())) != null) {
                familyMap.remove(style.getName());
                if (familyMap.isEmpty()) {
                    this.mStyles.remove(style.getFamily());
                }
            }
        } else if (node instanceof OdfListStyle) {
            if (this.mListStyles != null) {
                OdfListStyle listStyle = (OdfListStyle)node;
                this.mListStyles.remove(listStyle.getName());
            }
        } else if (node instanceof OdfPageLayout && this.mPageLayouts != null) {
            OdfPageLayout pageLayout = (OdfPageLayout)node;
            this.mPageLayouts.remove(pageLayout.getName());
        }
    }

    private String createUniqueStyleName(OdfStyleFamily styleFamily) {
        String unique_name;
        if (styleFamily.equals(OdfStyleFamily.List)) {
            while (this.getListStyle(unique_name = String.format("l%06x", (int)(Math.random() * 1.6777215E7))) != null) {
            }
        } else {
            while (this.getStyle(unique_name = String.format("a%06x", (int)(Math.random() * 1.6777215E7)), styleFamily) != null) {
            }
        }
        return unique_name;
    }

    public void optimize() {
        OdfStyle style = OdfElement.findFirstChildNode(OdfStyle.class, (Node)((Object)this));
        while (style != null) {
            OdfStyle nextStyle = OdfElement.findNextChildNode(OdfStyle.class, (Node)((Object)style));
            if (style.getStyleUserCount() < 1) {
                this.removeChild((Node)((Object)style));
            }
            style = nextStyle;
        }
    }
}

