/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.odftoolkit.odfdom.doc.OdfChartDocument;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.OdfGraphicsDocument;
import org.odftoolkit.odfdom.doc.OdfPresentationDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.doc.element.office.OdfAutomaticStyles;
import org.odftoolkit.odfdom.doc.element.office.OdfBody;
import org.odftoolkit.odfdom.doc.element.office.OdfMasterStyles;
import org.odftoolkit.odfdom.doc.element.office.OdfStyles;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OdfDocument {
    private static final String TWO_DOTS = "..";
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String EMPTY_STRING = "";
    private String mDocumentPathInPackage = "";
    private OdfMediaType mMediaType;
    private OdfPackage mPackage;
    private OdfStyles mDocumentStyles;
    private OdfFileDom mContentDom;
    private OdfFileDom mStylesDom;
    private StringBuilder mCharsForTextNode = new StringBuilder();
    private XPath mXPath;
    private Map<String, OdfDocument> mCachedDocuments = new HashMap<String, OdfDocument>();
    private OdfDocument mRootDocument;
    private Resolver mResolver;
    private static final String TO_STRING_METHOD_TOKEN = "\nID: ";

    private static OdfDocument createDocument(OdfMediaType odfMediaType, OdfPackage pkg) {
        OdfDocument newDoc = null;
        if (odfMediaType.equals((Object)OdfMediaType.TEXT)) {
            newDoc = new OdfTextDocument();
        } else if (odfMediaType.equals((Object)OdfMediaType.SPREADSHEET)) {
            newDoc = new OdfSpreadsheetDocument();
        } else if (odfMediaType.equals((Object)OdfMediaType.PRESENTATION)) {
            newDoc = new OdfPresentationDocument();
        } else if (odfMediaType.equals((Object)OdfMediaType.GRAPHICS)) {
            newDoc = new OdfGraphicsDocument();
        } else if (odfMediaType.equals((Object)OdfMediaType.CHART)) {
            newDoc = new OdfChartDocument();
        }
        newDoc.setMediaType(odfMediaType);
        newDoc.setPackage(pkg);
        return newDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OdfDocument loadTemplate(Resource res, boolean useTempFile) throws Exception {
        InputStream in = res.createInputStream();
        OdfPackage pkg = null;
        try {
            pkg = OdfPackage.loadPackage(in, useTempFile);
        }
        finally {
            in.close();
        }
        OdfMediaType odfMediaType = OdfMediaType.getOdfMediaType(pkg.getMediaType());
        if (odfMediaType == null) {
            throw new IllegalArgumentException("Document contains incorrect ODF Mediatype '" + pkg.getMediaType() + "'");
        }
        return OdfDocument.createDocument(odfMediaType, pkg);
    }

    public static OdfDocument loadDocument(String path) throws Exception {
        OdfPackage pkg = OdfPackage.loadPackage(path);
        OdfMediaType odfMediaType = OdfMediaType.getOdfMediaType(pkg.getMediaType());
        if (odfMediaType == null) {
            throw new IllegalArgumentException("Document contains incorrect ODF Mediatype '" + pkg.getMediaType() + "'");
        }
        return OdfDocument.createDocument(odfMediaType, pkg);
    }

    public static OdfDocument loadDocument(String path, boolean useTempFile) throws Exception {
        OdfPackage pkg = OdfPackage.loadPackage(path, useTempFile);
        OdfMediaType odfMediaType = OdfMediaType.getOdfMediaType(pkg.getMediaType());
        if (odfMediaType == null) {
            throw new IllegalArgumentException("Document contains incorrect ODF Mediatype '" + pkg.getMediaType() + "'");
        }
        return OdfDocument.createDocument(odfMediaType, pkg);
    }

    public static OdfDocument loadDocument(InputStream inStream) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(inStream));
    }

    public static OdfDocument loadDocument(InputStream inStream, boolean useTempFile) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(inStream, useTempFile));
    }

    public static OdfDocument loadDocument(File file) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(file));
    }

    public static OdfDocument loadDocument(File file, boolean useTempFile) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(file, useTempFile));
    }

    public static OdfDocument loadDocument(OdfPackage odfPackage) throws Exception {
        OdfMediaType odfMediaType = OdfMediaType.getOdfMediaType(odfPackage.getMediaType());
        if (odfMediaType == null) {
            throw new IllegalArgumentException("Document contains incorrect ODF Mediatype '" + odfPackage.getMediaType() + "'");
        }
        OdfDocument odfDocument = OdfDocument.createDocument(odfMediaType, odfPackage);
        odfDocument.setRootDocument(odfDocument);
        return odfDocument;
    }

    private static OdfDocument loadDocument(OdfDocument parentDocument, String pkgPathToChildDocument, String mediaType) throws Exception {
        OdfMediaType odfMediaType = OdfMediaType.getOdfMediaType(mediaType);
        OdfDocument newDoc = null;
        if (odfMediaType.equals((Object)OdfMediaType.TEXT)) {
            newDoc = OdfTextDocument.createTextDocument();
        } else if (odfMediaType.equals((Object)OdfMediaType.SPREADSHEET)) {
            newDoc = OdfSpreadsheetDocument.createSpreadsheetDocument();
        } else if (odfMediaType.equals((Object)OdfMediaType.PRESENTATION)) {
            newDoc = OdfPresentationDocument.createPresentationDocument();
        } else if (odfMediaType.equals((Object)OdfMediaType.GRAPHICS)) {
            newDoc = OdfGraphicsDocument.createGraphicsDocument();
        } else if (odfMediaType.equals((Object)OdfMediaType.CHART)) {
            newDoc = OdfChartDocument.createChartDocument();
        }
        super.setDocumentPathInPackage(pkgPathToChildDocument);
        if (super.isRootDocument()) {
            newDoc.setRootDocument(newDoc);
        } else {
            newDoc.setRootDocument(parentDocument);
        }
        newDoc.setPackage(parentDocument.getPackage());
        return newDoc;
    }

    protected void setRootDocument(OdfDocument root) {
        this.mRootDocument = root;
    }

    protected OdfDocument getRootDocument() {
        return this.mRootDocument;
    }

    protected void setPackage(OdfPackage pkg) {
        this.mPackage = pkg;
    }

    public OdfPackage getPackage() {
        return this.mPackage;
    }

    protected void setMediaType(OdfMediaType odfMediaType) {
        this.mMediaType = odfMediaType;
    }

    private void setDocumentPathInPackage(String path) {
        this.mDocumentPathInPackage = this.ensureValidPackagePath(path);
    }

    public String getDocumentPackagePath() {
        return this.mDocumentPathInPackage;
    }

    protected String getXMLFilePath(OdfXMLFile file) {
        return this.getDocumentPackagePath() + file.mFileName;
    }

    public void embedDocument(String pkgPathToChildDocument, OdfDocument newOdfDocument) {
        newOdfDocument.insertDOMsToPkg();
        pkgPathToChildDocument = this.ensureValidPackagePath(pkgPathToChildDocument);
        newOdfDocument.setDocumentPathInPackage(pkgPathToChildDocument);
        newOdfDocument.mRootDocument = this.isRootDocument() ? this : this.mRootDocument;
        for (OdfXMLFile odfFile : OdfXMLFile.values()) {
            try {
                if (newOdfDocument.mPackage.getInputStream(odfFile.mFileName) == null) continue;
                this.mPackage.insert(newOdfDocument.mPackage.getInputStream(odfFile.mFileName), newOdfDocument.getXMLFilePath(odfFile), newOdfDocument.mPackage.getMediaType());
            }
            catch (Exception ex) {
                Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public InputStream getContentStream() throws Exception {
        String path = this.getXMLFilePath(OdfXMLFile.CONTENT);
        return this.mPackage.getInputStream(path);
    }

    public InputStream getStylesStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.STYLES));
    }

    public InputStream getSettingsStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.SETTINGS));
    }

    public InputStream getMetaStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.META));
    }

    public String getBaseURI() {
        return this.mPackage.getBaseURI();
    }

    public OdfDocument getEmbeddedDocument(String pathToObject) {
        pathToObject = this.ensureValidPackagePath(pathToObject);
        try {
            String mediaTypeOfEmbeddedDoc = this.mPackage.getFileEntry(pathToObject).getMediaType();
            if (mediaTypeOfEmbeddedDoc != null) {
                OdfDocument cachedDocument = this.lookupDocumentCache(pathToObject);
                if (cachedDocument != null) {
                    return cachedDocument;
                }
                OdfDocument newDoc = OdfDocument.loadDocument(this, pathToObject, mediaTypeOfEmbeddedDoc);
                this.addToCache(newDoc.getDocumentPackagePath(), newDoc);
                return newDoc;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public List<OdfDocument> getEmbeddedDocuments(OdfMediaType mediaType) {
        Set<String> manifestEntries = this.getPackage().getFileEntries();
        ArrayList<OdfDocument> embeddedObjects = new ArrayList<OdfDocument>();
        for (String entry : manifestEntries) {
            String entryMediaType;
            if (entry.length() <= 1 || !entry.endsWith(SLASH) || !(entryMediaType = this.getPackage().getFileEntry(entry).getMediaType()).equals(mediaType.toString())) continue;
            embeddedObjects.add(this.getEmbeddedDocument(entry));
        }
        return embeddedObjects;
    }

    public List<OdfDocument> getEmbeddedDocuments() {
        ArrayList<OdfDocument> embeddedObjects = new ArrayList<OdfDocument>();
        for (OdfMediaType mediaType : OdfMediaType.values()) {
            embeddedObjects.addAll(this.getEmbeddedDocuments(mediaType));
        }
        return embeddedObjects;
    }

    private OdfDocument lookupDocumentCache(String pathToObject) {
        Map<String, OdfDocument> documentCache = this.isRootDocument() ? this.mCachedDocuments : this.mRootDocument.mCachedDocuments;
        if (documentCache != null && documentCache.containsKey(pathToObject)) {
            return documentCache.get(pathToObject);
        }
        return null;
    }

    private void addToCache(String pathToObject, OdfDocument document) {
        if (this.isRootDocument()) {
            this.mCachedDocuments.put(pathToObject, document);
        } else {
            this.mRootDocument.mCachedDocuments.put(pathToObject, document);
        }
    }

    private boolean isRootDocument() {
        return this.getDocumentPackagePath().equals(EMPTY_STRING);
    }

    public OdfStyles getDocumentStyles() {
        if (this.mDocumentStyles == null) {
            try {
                OdfFileDom stylesDom = this.getStylesDom();
                if (stylesDom == null) {
                    return null;
                }
                this.mDocumentStyles = OdfElement.findFirstChildNode(OdfStyles.class, stylesDom.getFirstChild());
            }
            catch (Exception ex) {
                Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.mDocumentStyles;
    }

    public OdfStyles getOrCreateDocumentStyles() {
        if (this.mDocumentStyles == null) {
            try {
                Node parent;
                OdfFileDom stylesDom = this.getStylesDom();
                Node node = parent = stylesDom != null ? stylesDom.getFirstChild() : null;
                if (parent != null) {
                    this.mDocumentStyles = OdfElement.findFirstChildNode(OdfStyles.class, parent);
                    if (this.mDocumentStyles == null) {
                        this.mDocumentStyles = stylesDom.createOdfElement(OdfStyles.class);
                        parent.insertBefore((Node)((Object)this.mDocumentStyles), parent.getFirstChild());
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.mDocumentStyles;
    }

    public XPath getXPath() {
        if (this.mXPath == null) {
            this.mXPath = XPathFactory.newInstance().newXPath();
            this.mXPath.setNamespaceContext(new OdfNamespace());
        }
        return this.mXPath;
    }

    public OdfFileDom getContentDom() throws Exception {
        if (this.mContentDom == null) {
            this.mContentDom = this.getFileDom(OdfXMLFile.CONTENT);
        }
        return this.mContentDom;
    }

    public OdfFileDom getStylesDom() throws Exception {
        if (this.mStylesDom == null) {
            this.mStylesDom = this.getFileDom(OdfXMLFile.STYLES);
        }
        return this.mStylesDom;
    }

    public String getMediaType() {
        return this.mMediaType.getName();
    }

    public void save(String path) throws Exception {
        this.optimize();
        if (!this.isRootDocument() && this.mRootDocument != null) {
            this.mRootDocument.save(path);
        } else {
            if (!this.mCachedDocuments.isEmpty()) {
                for (String odfDocPath : this.mCachedDocuments.keySet()) {
                    this.mCachedDocuments.get(odfDocPath).saveEmbeddedDoc();
                }
            }
            this.insertDOMsToPkg();
            this.mPackage.save(path);
        }
    }

    public void save(File file) throws Exception {
        this.optimize();
        if (!this.isRootDocument() && this.mRootDocument != null) {
            this.mRootDocument.save(file);
        } else {
            if (!this.mCachedDocuments.isEmpty()) {
                for (String odfDocPath : this.mCachedDocuments.keySet()) {
                    this.mCachedDocuments.get(odfDocPath).saveEmbeddedDoc();
                }
            }
            this.insertDOMsToPkg();
            this.mPackage.save(file);
        }
    }

    public void save(OutputStream out) throws Exception {
        this.optimize();
        if (!this.isRootDocument() && this.mRootDocument != null) {
            this.mRootDocument.save(out);
        } else {
            if (!this.mCachedDocuments.isEmpty()) {
                for (String odfDocPath : this.mCachedDocuments.keySet()) {
                    this.mCachedDocuments.get(odfDocPath).saveEmbeddedDoc();
                }
            }
            this.insertDOMsToPkg();
            this.mPackage.save(out, null);
        }
    }

    private void saveEmbeddedDoc() throws Exception {
        this.optimize();
        if (this.mContentDom == null) {
            this.mPackage.insert(this.getContentStream(), this.getXMLFilePath(OdfXMLFile.CONTENT), this.getMediaType());
        } else {
            this.mPackage.insert((Document)((Object)this.getContentDom()), this.getXMLFilePath(OdfXMLFile.CONTENT));
        }
        if (this.mStylesDom == null) {
            this.mPackage.insert(this.getStylesStream(), this.getXMLFilePath(OdfXMLFile.STYLES), this.getMediaType());
        } else {
            this.mPackage.insert((Document)((Object)this.getStylesDom()), this.getXMLFilePath(OdfXMLFile.STYLES));
        }
    }

    private void optimize() {
        try {
            OdfAutomaticStyles auto_styles;
            OdfFileDom dom = this.getStylesDom();
            if (dom != null && (auto_styles = dom.getAutomaticStyles()) != null) {
                auto_styles.optimize();
            }
            if ((dom = this.getContentDom()) != null && (auto_styles = dom.getAutomaticStyles()) != null) {
                auto_styles.optimize();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void insertDOMsToPkg() {
        try {
            if (this.getContentStream() != null) {
                this.mPackage.insert((Document)((Object)this.getContentDom()), this.getXMLFilePath(OdfXMLFile.CONTENT));
            }
            if (this.getStylesStream() != null) {
                this.mPackage.insert((Document)((Object)this.getStylesDom()), this.getXMLFilePath(OdfXMLFile.STYLES));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    EntityResolver getEntityResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver();
        }
        return this.mResolver;
    }

    URIResolver getURIResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver();
        }
        return this.mResolver;
    }

    public OdfBody getOfficeBody() {
        try {
            if (this.getContentDom() != null) {
                return OdfElement.findFirstChildNode(OdfBody.class, this.getContentDom().getFirstChild());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public OdfMasterStyles getOfficeMasterStyles() {
        try {
            OdfFileDom fileDom = this.getStylesDom();
            if (fileDom != null) {
                return OdfElement.findFirstChildNode(OdfMasterStyles.class, fileDom.getFirstChild());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private OdfFileDom getFileDom(OdfXMLFile file) throws Exception {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        SAXParser parser = saxFactory.newSAXParser();
        XMLReader xmlReader = parser.getXMLReader();
        if (xmlReader.getFeature("http://xml.org/sax/features/namespaces")) {
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        if (xmlReader.getFeature("http://xml.org/sax/features/namespace-prefixes")) {
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        if (xmlReader.getFeature("http://xml.org/sax/features/xmlns-uris")) {
            xmlReader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        OdfFileDom fileDom = new OdfFileDom(this, this.getXMLFilePath(file));
        String path = this.getXMLFilePath(file);
        InputStream fileStream = this.mPackage.getInputStream(path);
        if (fileStream != null) {
            Handler handler = new Handler((Node)((Object)fileDom));
            xmlReader.setContentHandler(handler);
            InputSource contentSource = new InputSource(fileStream);
            xmlReader.parse(contentSource);
        }
        return fileDom;
    }

    private String ensureValidPackagePath(String filePath) {
        if (filePath == null) {
            String errMsg = "The path given by parameter is NULL!";
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        if (filePath.equals(EMPTY_STRING)) {
            String errMsg = "The path given by parameter is an empty string!";
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        if (filePath.indexOf(92) != -1) {
            filePath = filePath.replace('\\', '/');
        }
        if (filePath.indexOf("//") != -1) {
            filePath = filePath.replace("//", SLASH);
        }
        if (!filePath.endsWith(SLASH)) {
            filePath = filePath + SLASH;
        }
        if (OdfDocument.isExternalReference(filePath)) {
            String errMsg = "The path given by parameter '" + filePath + "' is not an internal ODF package path!";
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        return filePath;
    }

    private static boolean isExternalReference(String ref) {
        boolean isExternalReference = false;
        if (ref.startsWith(TWO_DOTS) || ref.startsWith(SLASH) || ref.contains(COLON)) {
            isExternalReference = true;
        }
        return isExternalReference;
    }

    public String toString() {
        return TO_STRING_METHOD_TOKEN + this.hashCode() + " " + this.mPackage.getBaseURI();
    }

    private class Handler
    extends DefaultHandler {
        private OdfFileDom mDocument;
        private Node m_root;
        private Node mNode;
        private Stack<ContentHandler> mHandlerStack = new Stack();

        Handler(Node root) {
            this.m_root = root;
            this.mDocument = this.m_root instanceof OdfFileDom ? (OdfFileDom)((Object)this.m_root) : (OdfFileDom)((Object)this.m_root.getOwnerDocument());
            this.mNode = this.m_root;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.flushTextNode();
            this.mNode = this.mNode.getParentNode();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.flushTextNode();
            OdfElement element = this.mDocument.createElementNS(uri, qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                element.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
            }
            this.mNode.appendChild((Node)((Object)element));
            this.mNode = element;
        }

        private void flushTextNode() {
            if (OdfDocument.this.mCharsForTextNode.length() > 0) {
                Text text = this.mDocument.createTextNode(OdfDocument.this.mCharsForTextNode.toString());
                this.mNode.appendChild(text);
                OdfDocument.this.mCharsForTextNode.setLength(0);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.mHandlerStack.empty()) {
                this.mHandlerStack.peek().characters(ch, start, length);
            } else {
                OdfDocument.this.mCharsForTextNode.append(ch, start, length);
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return super.resolveEntity(publicId, systemId);
        }
    }

    private class Resolver
    implements EntityResolver,
    URIResolver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (publicId != null && publicId.startsWith("-//OpenOffice.org//DTD Modified W3C MathML")) {
                return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
            }
            if (systemId != null) {
                if (OdfDocument.this.mPackage.getBaseURI() != null && systemId.startsWith(OdfDocument.this.mPackage.getBaseURI())) {
                    if (systemId.equals(OdfDocument.this.mPackage.getBaseURI())) {
                        InputStream in = null;
                        try {
                            in = OdfDocument.this.mPackage.getInputStream();
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                        InputSource ins = new InputSource(in);
                        if (ins == null) {
                            return null;
                        }
                        ins.setSystemId(systemId);
                        return ins;
                    }
                    if (systemId.length() > OdfDocument.this.mPackage.getBaseURI().length() + 1) {
                        InputStream in = null;
                        try {
                            String path = systemId.substring(OdfDocument.this.mPackage.getBaseURI().length() + 1);
                            in = OdfDocument.this.mPackage.getInputStream(path);
                            InputSource ins = new InputSource(in);
                            ins.setSystemId(systemId);
                            InputSource inputSource = ins;
                            return inputSource;
                        }
                        catch (Exception ex) {
                            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    return null;
                }
                if (systemId.startsWith("resource:/")) {
                    int i = systemId.indexOf(47);
                    if (i > 0 && systemId.length() > i + 1) {
                        String res = systemId.substring(i + 1);
                        ClassLoader cl = OdfPackage.class.getClassLoader();
                        InputStream in = cl.getResourceAsStream(res);
                        if (in != null) {
                            InputSource ins = new InputSource(in);
                            ins.setSystemId(systemId);
                            return ins;
                        }
                    }
                    return null;
                }
                if (systemId.startsWith("jar:")) {
                    try {
                        URL url = new URL(systemId);
                        JarURLConnection jarConn = (JarURLConnection)url.openConnection();
                        InputSource ins = new InputSource(jarConn.getInputStream());
                        ins.setSystemId(systemId);
                        return ins;
                    }
                    catch (MalformedURLException me) {
                        throw new SAXException(me);
                    }
                }
            }
            return null;
        }

        public Source resolve(String href, String base) throws TransformerException {
            try {
                URI uri = null;
                if (base != null) {
                    URI baseuri = new URI(base);
                    uri = baseuri.resolve(href);
                } else {
                    uri = new URI(href);
                }
                InputSource ins = null;
                try {
                    ins = this.resolveEntity(null, uri.toString());
                }
                catch (Exception e) {
                    throw new TransformerException(e);
                }
                if (ins == null) {
                    return null;
                }
                InputStream in = ins.getByteStream();
                StreamSource src = new StreamSource(in);
                return src;
            }
            catch (URISyntaxException use) {
                return null;
            }
        }
    }

    protected static class Resource {
        private String name;

        public Resource(String name) {
            this.name = name;
        }

        public InputStream createInputStream() {
            InputStream in = OdfDocument.class.getResourceAsStream(this.name);
            if (in == null) {
                Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, "Could not find resource: " + this.name);
            }
            return in;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType {
        CHART("application/vnd.oasis.opendocument.chart", "odc"),
        GRAPHICS("application/vnd.oasis.opendocument.graphics", "odg"),
        PRESENTATION("application/vnd.oasis.opendocument.presentation", "odp"),
        SPREADSHEET("application/vnd.oasis.opendocument.spreadsheet", "ods"),
        TEXT("application/vnd.oasis.opendocument.text", "odt");

        private final String mMediaType;
        private final String mSuffix;

        private OdfMediaType(String mediaType, String suffix) {
            this.mMediaType = mediaType;
            this.mSuffix = suffix;
        }

        public String getName() {
            return this.mMediaType;
        }

        public String getSuffix() {
            return this.mSuffix;
        }

        public static OdfMediaType getOdfMediaType(String mediaType) {
            String mediaTypeShort = mediaType.substring(mediaType.lastIndexOf(".") + 1, mediaType.length());
            OdfMediaType odfMediaType = OdfMediaType.valueOf(mediaTypeShort = mediaTypeShort.replace('-', '_').toUpperCase());
            if (odfMediaType == null) {
                throw new IllegalArgumentException("Given mediaType '" + mediaType + "' is not an ODF mediatype!");
            }
            return odfMediaType;
        }

        public String toString() {
            return this.mMediaType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfXMLFile {
        CONTENT("content.xml"),
        META("meta.xml"),
        SETTINGS("settings.xml"),
        STYLES("styles.xml");

        private final String mFileName;

        public String getFileName() {
            return this.mFileName;
        }

        private OdfXMLFile(String fileName) {
            this.mFileName = fileName;
        }
    }
}

