/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.Resource;
import org.mortbay.util.URLResource;

public class JarResource
extends URLResource {
    protected transient JarURLConnection _jarConnection;

    JarResource(URL url) {
        super(url, null);
    }

    public synchronized void release() {
        this._jarConnection = null;
        super.release();
    }

    protected boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException e) {
            Code.ignore(e);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() throws IOException {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    public File getFile() throws IOException {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (!this._urlString.endsWith("!/")) {
            return super.getInputStream();
        }
        URL url = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        return url.openStream();
    }

    public static void extract(Resource resource, File directory, boolean deleteOnExit) throws IOException {
        Code.debug((Object)"Extract ", resource, (Object)" to ", directory);
        JarInputStream jin = new JarInputStream(resource.getInputStream());
        JarEntry entry = null;
        while ((entry = jin.getNextJarEntry()) != null) {
            File file = new File(directory, entry.getName());
            if (entry.isDirectory()) {
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                File dir = new File(file.getParent());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileOutputStream fout = new FileOutputStream(file);
                IO.copy(jin, fout);
                fout.close();
                if (entry.getTime() >= 0L) {
                    file.setLastModified(entry.getTime());
                }
            }
            if (!deleteOnExit) continue;
            file.deleteOnExit();
        }
    }

    public void extract(File directory, boolean deleteOnExit) throws IOException {
        JarResource.extract(this, directory, deleteOnExit);
    }
}

