/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

class TempDirDeleter
extends Thread {
    private static TempDirDeleter deleterThread = null;
    private ArrayList<File> dirList = new ArrayList();

    TempDirDeleter() {
    }

    static TempDirDeleter getInstance() {
        if (deleterThread == null) {
            deleterThread = new TempDirDeleter();
            Runtime.getRuntime().addShutdownHook(deleterThread);
        }
        return deleterThread;
    }

    synchronized void add(File dir) {
        this.dirList.add(dir);
    }

    synchronized void remove(File dir) {
        this.dirList.remove(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TempDirDeleter tempDirDeleter = this;
        synchronized (tempDirDeleter) {
            Iterator<File> iterator = this.dirList.iterator();
            while (iterator.hasNext()) {
                File dir = iterator.next();
                this.deleteDirectoryRecursive(dir);
                iterator.remove();
            }
            this.dirList.clear();
        }
    }

    private void deleteDirectoryRecursive(File dir) {
        if (dir == null) {
            return;
        }
        File[] fileArray = dir.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteDirectoryRecursive(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        dir.delete();
        TempDirDeleter.getInstance();
    }

    void deleteDirectory(File dir) {
        this.deleteDirectoryRecursive(dir);
        this.dirList.remove(dir);
    }
}

