/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.dom.DOMXSImplementationSourceImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.pkg.TempDir;
import org.odftoolkit.odfdom.pkg.manifest.Algorithm;
import org.odftoolkit.odfdom.pkg.manifest.EncryptionData;
import org.odftoolkit.odfdom.pkg.manifest.KeyDerivation;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfPackage {
    private Logger mLog = Logger.getLogger(OdfPackage.class.getName());
    private static final String TWO_DOTS = "..";
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String EMPTY_STRING = "";
    private static final String XML_MEDIA_TYPE = "text/xml";
    private static File mTempDirParent = null;
    private File mTempDir = null;
    private String mMediaType;
    private List<String> mPackageEntries;
    private ZipFile mZipFile;
    private HashMap<String, ZipEntry> mZipEntries;
    private HashMap<String, Document> mContentDoms;
    private HashMap<String, byte[]> mContentStreams;
    private HashMap<String, File> mTempFiles;
    private List<String> mManifestList;
    private HashMap<String, OdfFileEntry> mManifestEntries;
    private String mBaseURI;
    private Resolver mResolver;

    private OdfPackage(String odfPath) throws Exception {
        this.initialize(new File(odfPath), false);
    }

    private OdfPackage(File odfFile) throws Exception {
        this.initialize(odfFile, false);
    }

    private OdfPackage(InputStream odfStream) throws Exception {
        this.initialize();
        this.initialize(odfStream, true);
    }

    public static OdfPackage loadPackage(String odfPath) throws Exception {
        return new OdfPackage(odfPath);
    }

    public static OdfPackage loadPackage(File odfFile) throws Exception {
        return new OdfPackage(odfFile);
    }

    public static OdfPackage loadPackage(InputStream odfStream) throws Exception {
        return new OdfPackage(odfStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(File odfFile, boolean isInitialized) throws Exception {
        if (!isInitialized) {
            this.initialize();
        }
        this.mBaseURI = OdfPackage.getBaseURIFromFile(odfFile);
        this.mZipFile = new ZipFile(odfFile);
        Enumeration<? extends ZipEntry> zipEntries = this.mZipFile.entries();
        try {
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) {
                    this.insert(zipEntry, (byte[])null);
                    continue;
                }
                OutputStream os = null;
                os = zipEntry.getName().endsWith(".xml") || zipEntry.getName().equals(OdfFile.MEDIA_TYPE.getPath()) ? new StoreContentOutputStream(zipEntry) : new StoreTempOutputStream(zipEntry);
                if (os == null) continue;
                byte[] buf = new byte[4096];
                int r = 0;
                InputStream is = this.mZipFile.getInputStream(zipEntry);
                while ((r = is.read(buf, 0, 4096)) > -1) {
                    os.write(buf, 0, r);
                }
                os.close();
            }
            this.parseManifest();
        }
        finally {
            this.mZipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(InputStream odfStream, boolean isInitialized) throws Exception {
        if (!isInitialized) {
            this.initialize();
        }
        ZipInputStream zipStream = new ZipInputStream(odfStream);
        try {
            ZipEntry zipEntry = zipStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.isDirectory()) {
                    this.insert(zipEntry, (byte[])null);
                } else {
                    OutputStream os = null;
                    os = zipEntry.getName().endsWith(".xml") || zipEntry.getName().equals(OdfFile.MEDIA_TYPE.getPath()) ? new StoreContentOutputStream(zipEntry) : new StoreTempOutputStream(zipEntry);
                    if (os != null) {
                        byte[] buf = new byte[4096];
                        int r = 0;
                        while ((r = zipStream.read(buf, 0, 4096)) > -1) {
                            os.write(buf, 0, r);
                        }
                        os.close();
                    }
                }
                zipEntry = zipStream.getNextEntry();
            }
            this.parseManifest();
        }
        finally {
            zipStream.close();
        }
    }

    void setBaseURI(String baseURI) {
        this.mBaseURI = baseURI;
    }

    public String getBaseURI() {
        return this.mBaseURI;
    }

    void initialize() {
        this.mMediaType = null;
        this.mPackageEntries = new LinkedList<String>();
        this.mZipEntries = new HashMap();
        this.mContentDoms = new HashMap();
        this.mContentStreams = new HashMap();
        this.mTempFiles = new HashMap();
        this.mManifestList = new LinkedList<String>();
        this.mManifestEntries = null;
        if (this.mTempDir != null) {
            TempDir.release(this.mTempDir);
            this.mTempDir = null;
        }
    }

    public String getMediaType() {
        return this.mMediaType;
    }

    public void setMediaType(String mediaType) {
        this.mMediaType = mediaType;
        this.mPackageEntries.remove(OdfFile.MEDIA_TYPE.getPath());
        if (this.mMediaType != null) {
            this.mPackageEntries.add(0, OdfFile.MEDIA_TYPE.getPath());
        }
    }

    public OdfFileEntry getFileEntry(String packagePath) {
        packagePath = this.ensureValidPackagePath(packagePath);
        if (this.mManifestEntries == null) {
            try {
                this.parseManifest();
            }
            catch (Exception ex) {
                this.mLog.log(Level.SEVERE, null, ex);
            }
        }
        return this.mManifestEntries.get(packagePath);
    }

    public Set<String> getFileEntries() {
        if (this.mManifestEntries == null) {
            try {
                this.parseManifest();
            }
            catch (Exception ex) {
                this.mLog.log(Level.SEVERE, null, ex);
            }
        }
        return this.mManifestEntries.keySet();
    }

    public boolean contains(String packagePath) {
        return this.mPackageEntries.contains(packagePath = this.ensureValidPackagePath(packagePath)) && (this.mTempFiles.get(packagePath) != null || this.mContentStreams.get(packagePath) != null) && this.getFileEntry(packagePath) != null;
    }

    public void save(String odfPath) throws Exception {
        File f = new File(odfPath);
        this.save(f);
    }

    public void save(File odfFile) throws Exception {
        FileOutputStream fos = new FileOutputStream(odfFile);
        String baseURI = odfFile.getCanonicalFile().toURI().toString();
        if (File.separatorChar == '\\') {
            baseURI = baseURI.replaceAll("\\\\", SLASH);
        }
        this.save(fos, baseURI);
    }

    public void save(OutputStream odfStream, String baseURI) throws Exception {
        OdfFileEntry rootEntry;
        this.mBaseURI = baseURI;
        if (this.mManifestEntries == null) {
            try {
                this.parseManifest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((rootEntry = this.mManifestEntries.get(SLASH)) == null) {
            rootEntry = new OdfFileEntry(SLASH, this.mMediaType);
            this.mManifestList.add(0, rootEntry.getPath());
        } else {
            rootEntry.setMediaType(this.mMediaType);
        }
        ZipOutputStream zos = new ZipOutputStream(odfStream);
        long modTime = new Date().getTime();
        if (this.mPackageEntries.contains(OdfFile.MEDIA_TYPE.getPath())) {
            this.mPackageEntries.remove(OdfFile.MEDIA_TYPE.getPath());
            this.mPackageEntries.add(0, OdfFile.MEDIA_TYPE.getPath());
        }
        for (String key : this.mPackageEntries) {
            byte[] data = this.getBytes(key);
            ZipEntry ze = this.mZipEntries.get(key);
            if (ze == null) {
                ze = new ZipEntry(key);
            }
            ze.setTime(modTime);
            if (key.equals(OdfFile.MEDIA_TYPE.getPath()) || key.equals(OdfDocument.OdfXMLFile.META.getFileName())) {
                ze.setMethod(0);
            } else {
                ze.setMethod(8);
            }
            CRC32 crc = new CRC32();
            if (data != null) {
                crc.update(data);
                ze.setSize(data.length);
            } else {
                ze.setMethod(0);
                ze.setSize(0L);
            }
            ze.setCrc(crc.getValue());
            ze.setCompressedSize(-1L);
            zos.putNextEntry(ze);
            if (data != null) {
                zos.write(data, 0, data.length);
            }
            zos.closeEntry();
            this.mZipEntries.put(key, ze);
        }
        zos.close();
        odfStream.flush();
    }

    private void entryUpdate(String packagePath) throws Exception, SAXException, TransformerConfigurationException, TransformerException, ParserConfigurationException {
        byte[] data = this.getBytes(packagePath);
        int size = 0;
        size = data == null ? 0 : data.length;
        if (this.mManifestEntries == null) {
            this.parseManifest();
        }
        OdfFileEntry fileEntry = this.mManifestEntries.get(packagePath);
        ZipEntry zipEntry = this.mZipEntries.get(packagePath);
        if (zipEntry == null) {
            return;
        }
        if (fileEntry != null) {
            if (XML_MEDIA_TYPE.equals(fileEntry.getMediaType())) {
                fileEntry.setSize(-1);
            } else {
                fileEntry.setSize(size);
            }
        }
        zipEntry.setSize(size);
        CRC32 crc = new CRC32();
        if (data != null && size > 0) {
            crc.update(data);
        }
        zipEntry.setCrc(crc.getValue());
        zipEntry.setCompressedSize(-1L);
        long modTime = new Date().getTime();
        zipEntry.setTime(modTime);
    }

    void parseManifest() throws Exception {
        InputStream is = this.getInputStream(OdfFile.MANIFEST.packagePath);
        if (is == null) {
            this.mManifestList = null;
            this.mManifestEntries = null;
            return;
        }
        this.mManifestList = new LinkedList<String>();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception ex) {
            this.mLog.log(Level.SEVERE, null, ex);
        }
        SAXParser parser = factory.newSAXParser();
        XMLReader xmlReader = parser.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        String uri = this.mBaseURI + OdfFile.MANIFEST.packagePath;
        xmlReader.setEntityResolver(this.getEntityResolver());
        xmlReader.setContentHandler(new ManifestContentHandler());
        InputSource ins = new InputSource(is);
        ins.setSystemId(uri);
        xmlReader.parse(ins);
        this.mContentStreams.remove(OdfFile.MANIFEST.packagePath);
        this.entryUpdate(OdfFile.MANIFEST.packagePath);
    }

    private String ensureValidPackagePath(String packagePath) {
        if (packagePath == null) {
            String errMsg = "The packagePath given by parameter is NULL!";
            this.mLog.severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        if (packagePath.equals(EMPTY_STRING)) {
            String errMsg = "The packagePath given by parameter is an empty string!";
            this.mLog.severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        if (packagePath.indexOf(92) != -1) {
            packagePath = packagePath.replace('\\', '/');
        }
        if (OdfPackage.isExternalReference(packagePath)) {
            String errMsg = "The packagePath given by parameter '" + packagePath + "' is not an internal ODF package path!";
            this.mLog.severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        return packagePath;
    }

    private void addDirectory(String packagePath) throws Exception {
        if ((packagePath = this.ensureValidPackagePath(packagePath)).length() < 1 || packagePath.charAt(packagePath.length() - 1) != '/') {
            packagePath = packagePath + SLASH;
        }
        this.insert((byte[])null, packagePath, null);
    }

    public void insert(Document fileDOM, String packagePath) throws Exception {
        this.insert(fileDOM, packagePath, XML_MEDIA_TYPE);
    }

    public void insert(Document fileDOM, String packagePath, String mediaType) throws Exception {
        packagePath = this.ensureValidPackagePath(packagePath);
        if (this.mManifestEntries == null) {
            try {
                this.parseManifest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (mediaType == null) {
            mediaType = XML_MEDIA_TYPE;
        }
        String d = EMPTY_STRING;
        StringTokenizer tok = new StringTokenizer(packagePath, SLASH);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            d = EMPTY_STRING.equals(d) ? s + SLASH : d + s + SLASH;
            if (!tok.hasMoreTokens() || this.mPackageEntries.contains(d)) continue;
            this.addDirectory(d);
        }
        this.mContentStreams.remove(packagePath);
        if (fileDOM == null) {
            this.mContentDoms.remove(packagePath);
        } else {
            this.mContentDoms.put(packagePath, fileDOM);
        }
        if (!this.mPackageEntries.contains(packagePath)) {
            this.mPackageEntries.add(packagePath);
        }
        try {
            ZipEntry ze;
            if (!OdfFile.MANIFEST.packagePath.equals(packagePath)) {
                if (this.mManifestEntries.get(packagePath) == null) {
                    OdfFileEntry fileEntry = new OdfFileEntry(packagePath, mediaType);
                    this.mManifestEntries.put(packagePath, fileEntry);
                    this.mManifestList.add(packagePath);
                }
            } else {
                this.parseManifest();
            }
            if ((ze = this.mZipEntries.get(packagePath)) != null) {
                ze = new ZipEntry(packagePath);
                ze.setMethod(8);
                this.mZipEntries.put(packagePath, ze);
            }
            if (packagePath.equals(OdfFile.MEDIA_TYPE.getPath()) || packagePath.equals(OdfDocument.OdfXMLFile.META.getFileName())) {
                ze.setMethod(0);
            }
            this.entryUpdate(packagePath);
        }
        catch (SAXException se) {
            throw new Exception("SAXException:" + se.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("ParserConfigurationException:" + pce.getMessage());
        }
        catch (TransformerConfigurationException tce) {
            throw new Exception("TransformerConfigurationException:" + tce.getMessage());
        }
        catch (TransformerException te) {
            throw new Exception("TransformerException:" + te.getMessage());
        }
    }

    public boolean hasDom(String packagePath) {
        return this.mContentDoms.get(packagePath) != null;
    }

    public Document getDom(String packagePath) throws SAXException, ParserConfigurationException, Exception, IllegalArgumentException, TransformerConfigurationException, TransformerException {
        Document doc = this.mContentDoms.get(packagePath);
        if (doc != null) {
            return doc;
        }
        InputStream is = this.getInputStream(packagePath);
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(this.getEntityResolver());
        String uri = this.getBaseURI() + packagePath;
        InputSource ins = new InputSource(is);
        ins.setSystemId(uri);
        doc = builder.parse(ins);
        if (doc != null) {
            this.mContentDoms.put(packagePath, doc);
        }
        return doc;
    }

    public void insert(URI sourceURI, String packagePath) throws Exception {
        this.insert(sourceURI, packagePath, null);
    }

    public void insert(URI sourceURI, String packagePath, String mediaType) throws Exception {
        String sourceRef = sourceURI.toString();
        InputStream is = null;
        is = sourceURI.isAbsolute() ? sourceURI.toURL().openStream() : (sourceRef.contains(COLON) ? new URL(sourceURI.toString()).openStream() : new File(sourceRef).toURL().openStream());
        if (sourceRef.contains(SLASH)) {
            sourceRef = sourceRef.substring(sourceRef.lastIndexOf(SLASH) + 1, sourceRef.length());
        }
        this.insert(is, packagePath, mediaType);
    }

    public void insert(InputStream fileStream, String packagePath) throws Exception {
        this.insert(fileStream, packagePath, null);
    }

    public void insert(InputStream fileStream, String packagePath, String mediaType) throws Exception {
        packagePath = this.ensureValidPackagePath(packagePath);
        if (fileStream == null) {
            this.insert((byte[])null, packagePath, mediaType);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = new BufferedInputStream(fileStream);
            byte[] buf = new byte[4096];
            int r = 0;
            while ((r = bis.read(buf, 0, 4096)) > -1) {
                baos.write(buf, 0, r);
            }
            byte[] data = baos.toByteArray();
            this.insert(data, packagePath, mediaType);
            if (!packagePath.endsWith(".xml") && !packagePath.equals(OdfFile.MEDIA_TYPE.getPath())) {
                File tempFile = new File(this.getTempDir(), packagePath);
                File parent = tempFile.getParentFile();
                parent.mkdirs();
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(tempFile));
                ((OutputStream)fos).write(data);
                ((OutputStream)fos).close();
                this.mTempFiles.put(packagePath, tempFile);
                this.mContentStreams.remove(packagePath);
            }
        }
    }

    public void insert(byte[] fileBytes, String fileDestPath) throws Exception {
        this.insert(fileBytes, fileDestPath, null);
    }

    public void insert(byte[] fileBytes, String fileDestPath, String mediaType) throws Exception {
        fileDestPath = this.ensureValidPackagePath(fileDestPath);
        String d = EMPTY_STRING;
        StringTokenizer tok = new StringTokenizer(fileDestPath, SLASH);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            d = EMPTY_STRING.equals(d) ? s + SLASH : d + s + SLASH;
            if (!tok.hasMoreTokens() || this.mPackageEntries.contains(d)) continue;
            this.addDirectory(d);
            if (OdfFile.MANIFEST.packagePath.equals(d) || mediaType == null || this.mManifestEntries.get(d) != null) continue;
            OdfFileEntry fileEntry = new OdfFileEntry(d, mediaType);
            this.mManifestEntries.put(d, fileEntry);
            if (this.mManifestList.contains(d)) continue;
            this.mManifestList.add(d);
        }
        try {
            ZipEntry ze;
            if (OdfFile.MEDIA_TYPE.getPath().equals(fileDestPath)) {
                try {
                    this.setMediaType(new String(fileBytes, "UTF-8"));
                }
                catch (UnsupportedEncodingException useEx) {
                    this.mLog.log(Level.WARNING, "ODF file could not be created as string!", useEx);
                }
                return;
            }
            if (fileBytes == null) {
                this.mContentStreams.remove(fileDestPath);
            } else {
                this.mContentStreams.put(fileDestPath, fileBytes);
            }
            if (!this.mPackageEntries.contains(fileDestPath)) {
                this.mPackageEntries.add(fileDestPath);
            }
            if (!OdfFile.MANIFEST.packagePath.equals(fileDestPath)) {
                if (mediaType != null && this.mManifestEntries.get(fileDestPath) == null) {
                    OdfFileEntry fileEntry = new OdfFileEntry(fileDestPath, mediaType);
                    this.mManifestEntries.put(fileDestPath, fileEntry);
                    if (!this.mManifestList.contains(fileDestPath)) {
                        this.mManifestList.add(fileDestPath);
                    }
                }
            } else {
                this.parseManifest();
            }
            if ((ze = this.mZipEntries.get(fileDestPath)) != null) {
                ze = new ZipEntry(fileDestPath);
                ze.setMethod(8);
                this.mZipEntries.put(fileDestPath, ze);
            }
            if (fileDestPath.equals(OdfFile.MEDIA_TYPE.getPath()) || fileDestPath.equals(OdfDocument.OdfXMLFile.META.getFileName())) {
                ze.setMethod(0);
            }
            this.entryUpdate(fileDestPath);
        }
        catch (SAXException se) {
            throw new Exception("SAXException:" + se.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("ParserConfigurationException:" + pce.getMessage());
        }
        catch (TransformerConfigurationException tce) {
            throw new Exception("TransformerConfigurationException:" + tce.getMessage());
        }
        catch (TransformerException te) {
            throw new Exception("TransformerException:" + te.getMessage());
        }
    }

    private void insert(ZipEntry zipe, byte[] content) {
        if (content != null) {
            if (zipe.getName().equals(OdfFile.MEDIA_TYPE.getPath())) {
                try {
                    this.mMediaType = new String(content, 0, content.length, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    this.mLog.log(Level.SEVERE, null, ex);
                }
            } else {
                this.mContentStreams.put(zipe.getName(), content);
            }
        }
        if (!this.mPackageEntries.contains(zipe.getName())) {
            this.mPackageEntries.add(zipe.getName());
        }
        this.mZipEntries.put(zipe.getName(), zipe);
    }

    private void insert(ZipEntry zipe, File file) {
        if (file != null) {
            this.mTempFiles.put(zipe.getName(), file);
        }
        if (!this.mPackageEntries.contains(zipe.getName())) {
            this.mPackageEntries.add(zipe.getName());
        }
        this.mZipEntries.put(zipe.getName(), zipe);
    }

    String getManifestAsString() {
        if (this.mManifestEntries == null) {
            try {
                this.parseManifest();
                if (this.mManifestEntries == null) {
                    return null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\">\n");
        for (String key : this.mManifestList) {
            EncryptionData enc;
            String s = null;
            OdfFileEntry fileEntry = this.mManifestEntries.get(key);
            if (fileEntry == null) continue;
            buf.append(" <manifest:file-entry");
            s = fileEntry.getMediaType();
            if (s == null) {
                s = EMPTY_STRING;
            }
            buf.append(" manifest:media-type=\"");
            buf.append(this.encodeXMLAttributes(s));
            buf.append("\"");
            s = fileEntry.getPath();
            if (s == null) {
                s = EMPTY_STRING;
            }
            buf.append(" manifest:full-path=\"");
            buf.append(this.encodeXMLAttributes(s));
            buf.append("\"");
            int i = fileEntry.getSize();
            if (i > 0) {
                buf.append(" manifest:size=\"");
                buf.append(i);
                buf.append("\"");
            }
            if ((enc = fileEntry.getEncryptionData()) != null) {
                KeyDerivation keyDerivation;
                buf.append(">\n");
                buf.append("  <manifest:encryption-data>\n");
                Algorithm alg = enc.getAlgorithm();
                if (alg != null) {
                    buf.append("   <manifest:algorithm");
                    s = alg.getName();
                    if (s == null) {
                        s = EMPTY_STRING;
                    }
                    buf.append(" manifest:algorithm-name=\"");
                    buf.append(this.encodeXMLAttributes(s));
                    buf.append("\"");
                    s = alg.getInitializationVector();
                    if (s == null) {
                        s = EMPTY_STRING;
                    }
                    buf.append(" manifest:initialization-vector=\"");
                    buf.append(this.encodeXMLAttributes(s));
                    buf.append("\"/>\n");
                }
                if ((keyDerivation = enc.getKeyDerivation()) != null) {
                    buf.append("   <manifest:key-derivation");
                    s = keyDerivation.getName();
                    if (s == null) {
                        s = EMPTY_STRING;
                    }
                    buf.append(" manifest:key-derivation-name=\"");
                    buf.append(this.encodeXMLAttributes(s));
                    buf.append("\"");
                    s = keyDerivation.getSalt();
                    if (s == null) {
                        s = EMPTY_STRING;
                    }
                    buf.append(" manifest:salt=\"");
                    buf.append(this.encodeXMLAttributes(s));
                    buf.append("\"");
                    buf.append(" manifest:iteration-count=\"");
                    buf.append(keyDerivation.getIterationCount());
                    buf.append("\"/>\n");
                }
                buf.append("  </manifest:encryption-data>\n");
                buf.append(" </<manifest:file-entry>\n");
                continue;
            }
            buf.append("/>\n");
        }
        buf.append("</manifest:manifest>");
        return buf.toString();
    }

    public byte[] getBytes(String packagePath) throws Exception {
        packagePath = this.ensureValidPackagePath(packagePath);
        byte[] data = null;
        if (packagePath == null || packagePath.equals(EMPTY_STRING)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.save(baos, this.mBaseURI);
            return baos.toByteArray();
        }
        if (packagePath.equals(OdfFile.MEDIA_TYPE.getPath())) {
            if (this.mMediaType == null) {
                return null;
            }
            try {
                data = this.mMediaType.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException use) {
                this.mLog.log(Level.SEVERE, null, use);
                return null;
            }
        } else if (this.mPackageEntries.contains(packagePath) && this.mContentDoms.get(packagePath) != null) {
            Document doc = this.mContentDoms.get(packagePath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DOMXSImplementationSourceImpl dis = new DOMXSImplementationSourceImpl();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)dis.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(baos);
            writer.write(doc, output);
            data = baos.toByteArray();
        } else if (this.mPackageEntries.contains(packagePath) && this.mTempFiles.get(packagePath) != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.mTempFiles.get(packagePath)));
            byte[] buf = new byte[4096];
            int r = 0;
            while ((r = ((InputStream)is).read(buf, 0, 4096)) > 0) {
                os.write(buf, 0, r);
            }
            ((InputStream)is).close();
            os.close();
            data = os.toByteArray();
        } else if (this.mPackageEntries.contains(packagePath) && this.mContentStreams.get(packagePath) != null) {
            data = this.mContentStreams.get(packagePath);
        } else if (packagePath.equals(OdfFile.MANIFEST.packagePath)) {
            if (this.mManifestEntries == null) {
                return null;
            }
            String s = this.getManifestAsString();
            if (s == null) {
                return null;
            }
            data = s.getBytes("UTF-8");
        }
        return data;
    }

    public InputStream getInputStream(String packagePath) throws Exception {
        if (this.mPackageEntries.contains(packagePath = this.ensureValidPackagePath(packagePath)) && this.mTempFiles.get(packagePath) != null) {
            return new BufferedInputStream(new FileInputStream(this.mTempFiles.get(packagePath)));
        }
        byte[] data = this.getBytes(packagePath);
        if (data != null && data.length != 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return bais;
        }
        return null;
    }

    public InputStream getInputStream() throws Exception {
        final PipedOutputStream os = new PipedOutputStream();
        final PipedInputStream is = new PipedInputStream();
        is.connect(os);
        Thread thread1 = new Thread(){

            public void run() {
                try {
                    OdfPackage.this.save(os, OdfPackage.this.mBaseURI);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread thread2 = new Thread(){

            public void run() {
                try {
                    BufferedInputStream bis = new BufferedInputStream(is, 4096);
                    BufferedOutputStream bos = new BufferedOutputStream(os, 4096);
                    byte[] buf = new byte[4096];
                    int r = 0;
                    while ((r = bis.read(buf, 0, 4096)) > 0) {
                        bos.write(buf, 0, r);
                    }
                    is.close();
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread1.start();
        thread2.start();
        return is;
    }

    public OutputStream insertOutputStream(String packagePath) throws Exception {
        return this.insertOutputStream(packagePath, null);
    }

    public OutputStream insertOutputStream(String packagePath, String mediaType) throws Exception {
        final String fPath = packagePath = this.ensureValidPackagePath(packagePath);
        final OdfFileEntry fFileEntry = this.getFileEntry(packagePath);
        final String fMediaType = mediaType;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(){

            public void close() {
                try {
                    byte[] data = this.toByteArray();
                    if (fMediaType == null || fMediaType.length() == 0) {
                        OdfPackage.this.insert(data, fPath, fFileEntry == null ? null : fFileEntry.getMediaType());
                    } else {
                        OdfPackage.this.insert(data, fPath, fMediaType);
                    }
                    super.close();
                }
                catch (Exception ex) {
                    OdfPackage.this.mLog.log(Level.SEVERE, null, ex);
                }
            }
        };
        return baos;
    }

    public void remove(String packagePath) {
        if (this.mManifestList.contains(packagePath)) {
            this.mManifestList.remove(packagePath);
        }
        if (this.mManifestEntries.containsKey(packagePath)) {
            this.mManifestEntries.remove(packagePath);
        }
        if (this.mZipEntries.containsKey(packagePath)) {
            this.mZipEntries.remove(packagePath);
        }
        if (this.mTempFiles.containsKey(packagePath)) {
            File file = this.mTempFiles.remove(packagePath);
            file.delete();
        }
        if (this.mPackageEntries.contains(packagePath)) {
            this.mPackageEntries.remove(packagePath);
        }
    }

    public static boolean isExternalReference(String fileRef) {
        boolean isExternalReference = false;
        if (fileRef.startsWith(TWO_DOTS) || fileRef.startsWith(SLASH) || fileRef.contains(COLON)) {
            isExternalReference = true;
        }
        return isExternalReference;
    }

    private File getTempDir() throws Exception {
        if (this.mTempDir == null) {
            this.mTempDir = TempDir.createGeneratedName("ODF", mTempDirParent);
        }
        return this.mTempDir;
    }

    private String encodeXMLAttributes(String s) {
        String r = s.replaceAll("\"", "&quot;");
        r = r.replaceAll("'", "&apos;");
        return r;
    }

    public EntityResolver getEntityResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver();
        }
        return this.mResolver;
    }

    public URIResolver getURIResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver();
        }
        return this.mResolver;
    }

    private static String getBaseURIFromFile(File file) throws Exception {
        String baseURI = file.getCanonicalFile().toURI().toString();
        if (File.separatorChar == '\\') {
            baseURI = baseURI.replaceAll("\\\\", SLASH);
        }
        return baseURI;
    }

    private class Resolver
    implements EntityResolver,
    URIResolver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (publicId != null && publicId.startsWith("-//OpenOffice.org//DTD Modified W3C MathML")) {
                return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
            }
            if (systemId != null) {
                if (OdfPackage.this.mBaseURI != null && systemId.startsWith(OdfPackage.this.mBaseURI)) {
                    if (systemId.equals(OdfPackage.this.mBaseURI)) {
                        InputStream in = null;
                        try {
                            in = OdfPackage.this.getInputStream();
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                        InputSource ins = new InputSource(in);
                        if (ins == null) {
                            return null;
                        }
                        ins.setSystemId(systemId);
                        return ins;
                    }
                    if (systemId.length() > OdfPackage.this.mBaseURI.length() + 1) {
                        InputStream in = null;
                        try {
                            String path = systemId.substring(OdfPackage.this.mBaseURI.length() + 1);
                            in = OdfPackage.this.getInputStream(path);
                            InputSource ins = new InputSource(in);
                            ins.setSystemId(systemId);
                            InputSource inputSource = ins;
                            return inputSource;
                        }
                        catch (Exception ex) {
                            OdfPackage.this.mLog.log(Level.SEVERE, null, ex);
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException ex) {
                                OdfPackage.this.mLog.log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    return null;
                }
                if (systemId.startsWith("resource:/")) {
                    int i = systemId.indexOf(47);
                    if (i > 0 && systemId.length() > i + 1) {
                        String res = systemId.substring(i + 1);
                        ClassLoader cl = OdfPackage.class.getClassLoader();
                        InputStream in = cl.getResourceAsStream(res);
                        if (in != null) {
                            InputSource ins = new InputSource(in);
                            ins.setSystemId(systemId);
                            return ins;
                        }
                    }
                    return null;
                }
                if (systemId.startsWith("jar:")) {
                    try {
                        URL url = new URL(systemId);
                        JarURLConnection jarConn = (JarURLConnection)url.openConnection();
                        InputSource ins = new InputSource(jarConn.getInputStream());
                        ins.setSystemId(systemId);
                        return ins;
                    }
                    catch (IOException ex) {
                        OdfPackage.this.mLog.log(Level.SEVERE, null, ex);
                    }
                }
            }
            return null;
        }

        public Source resolve(String href, String base) throws TransformerException {
            try {
                URI uri = null;
                if (base != null) {
                    URI baseuri = new URI(base);
                    uri = baseuri.resolve(href);
                } else {
                    uri = new URI(href);
                }
                InputSource ins = null;
                try {
                    ins = this.resolveEntity(null, uri.toString());
                }
                catch (Exception e) {
                    throw new TransformerException(e);
                }
                if (ins == null) {
                    return null;
                }
                InputStream in = ins.getByteStream();
                StreamSource src = new StreamSource(in);
                src.setSystemId(uri.toString());
                return src;
            }
            catch (URISyntaxException use) {
                return null;
            }
        }
    }

    private class ManifestContentHandler
    implements ContentHandler {
        private OdfFileEntry _currentFileEntry;
        private EncryptionData _currentEncryptionData;

        private ManifestContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            OdfPackage.this.mManifestList = new LinkedList();
            OdfPackage.this.mManifestEntries = new HashMap();
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("file-entry")) {
                this._currentFileEntry = new OdfFileEntry();
                this._currentFileEntry.setPath(atts.getValue("manifest:full-path"));
                this._currentFileEntry.setMediaType(atts.getValue("manifest:media-type"));
                if (atts.getValue("manifest:size") != null) {
                    try {
                        this._currentFileEntry.setSize(Integer.parseInt(atts.getValue("manifest:size")));
                    }
                    catch (NumberFormatException nfe) {
                        throw new SAXException("not a number: " + atts.getValue("manifest:size"));
                    }
                }
            } else if (localName.equals("encryption-data")) {
                this._currentEncryptionData = new EncryptionData();
                if (this._currentFileEntry != null) {
                    this._currentEncryptionData.setChecksumType(atts.getValue("manifest:checksum-type"));
                    this._currentEncryptionData.setChecksum(atts.getValue("manifest:checksum"));
                    this._currentFileEntry.setEncryptionData(this._currentEncryptionData);
                }
            } else if (localName.equals("algorithm")) {
                Algorithm algorithm = new Algorithm();
                algorithm.setName(atts.getValue("manifest:algorithm-name"));
                algorithm.setInitializationVector(atts.getValue("manifest:initialization-vector"));
                if (this._currentEncryptionData != null) {
                    this._currentEncryptionData.setAlgorithm(algorithm);
                }
            } else if (localName.equals("key-derivation")) {
                KeyDerivation keyDerivation = new KeyDerivation();
                keyDerivation.setName(atts.getValue("manifest:key-derivation-name"));
                keyDerivation.setSalt(atts.getValue("manifest:salt"));
                if (atts.getValue("manifest:iteration-count") != null) {
                    try {
                        keyDerivation.setIterationCount(Integer.parseInt(atts.getValue("manifest:iteration-count")));
                    }
                    catch (NumberFormatException nfe) {
                        throw new SAXException("not a number: " + atts.getValue("manifest:iteration-count"));
                    }
                }
                if (this._currentEncryptionData != null) {
                    this._currentEncryptionData.setKeyDerivation(keyDerivation);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("file-entry")) {
                if (this._currentFileEntry.getPath() != null) {
                    OdfPackage.this.mManifestEntries.put(this._currentFileEntry.getPath(), this._currentFileEntry);
                }
                OdfPackage.this.mManifestList.add(this._currentFileEntry.getPath());
                this._currentFileEntry = null;
            } else if (localName.equals("encryption-data")) {
                this._currentEncryptionData = null;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }

    private class StoreTempOutputStream
    extends OutputStream {
        private ZipEntry mZipEntry2;
        private File mTempFile2;
        OutputStream mOs;

        public StoreTempOutputStream(ZipEntry zipEntry) throws Exception {
            this.mZipEntry2 = zipEntry;
            String fname = zipEntry.getName();
            if (File.separatorChar == '\\') {
                fname = fname.replaceAll("\\\\", OdfPackage.SLASH);
            }
            this.mTempFile2 = new File(OdfPackage.this.getTempDir(), fname);
            File parent = this.mTempFile2.getParentFile();
            parent.mkdirs();
            this.mOs = new BufferedOutputStream(new FileOutputStream(this.mTempFile2));
        }

        public void write(byte[] b) {
            try {
                this.mOs.write(b);
            }
            catch (IOException ex) {
                OdfPackage.this.mLog.log(Level.SEVERE, null, ex);
            }
        }

        public void write(byte[] b, int off, int len) {
            try {
                this.mOs.write(b, off, len);
            }
            catch (IOException ex) {
                OdfPackage.this.mLog.log(Level.SEVERE, null, ex);
            }
        }

        public void write(int b) {
            try {
                this.mOs.write(b);
            }
            catch (IOException ex) {
                OdfPackage.this.mLog.log(Level.SEVERE, null, ex);
            }
        }

        public void close() {
            try {
                this.mOs.close();
                if (this.mZipEntry2 != null) {
                    OdfPackage.this.insert(this.mZipEntry2, this.mTempFile2);
                }
            }
            catch (IOException ex) {
                OdfPackage.this.mLog.log(Level.SEVERE, null, ex);
            }
        }
    }

    private class StoreContentOutputStream
    extends ByteArrayOutputStream {
        private ZipEntry mZipEntry1;

        public StoreContentOutputStream(ZipEntry zipEntry) {
            this.mZipEntry1 = zipEntry;
        }

        public void close() {
            byte[] content = this.toByteArray();
            if (this.mZipEntry1 != null) {
                OdfPackage.this.insert(this.mZipEntry1, content);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfFile {
        IMAGE_DIRECTORY("Pictures"),
        MANIFEST("META-INF/manifest.xml"),
        MEDIA_TYPE("mimetype");

        private final String packagePath;

        private OdfFile(String packagePath) {
            this.packagePath = packagePath;
        }

        public String getPath() {
            return this.packagePath;
        }
    }
}

