/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.presentation;

import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.presentation.OdfSoundElement;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import org.odftoolkit.odfdom.dom.type.presentation.OdfActionType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfDirectionType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfEffectType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfSpeedType;
import org.w3c.dom.Node;

public abstract class OdfEventListenerElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.get(OdfNamespace.PRESENTATION, "event-listener");

    public OdfEventListenerElement(OdfFileDom aOwnerDoc) {
        super(aOwnerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public void init(String eventName, OdfActionType action) {
        this.setEventName(eventName);
        this.setAction(action);
    }

    public String getEventName() {
        return this.getOdfAttribute(OdfName.get(OdfNamespace.SCRIPT, "event-name"));
    }

    public void setEventName(String eventName) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.SCRIPT, "event-name"), eventName);
    }

    public OdfActionType getAction() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "action"));
        return OdfActionType.enumValueOf(stringVal);
    }

    public void setAction(OdfActionType action) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "action"), action.toString());
    }

    public OdfEffectType getEffect() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "effect"));
        if (stringVal.length() == 0) {
            stringVal = "none";
        }
        return OdfEffectType.enumValueOf(stringVal);
    }

    public void setEffect(OdfEffectType effect) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "effect"), effect.toString());
    }

    public OdfDirectionType getDirection() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "direction"));
        if (stringVal.length() == 0) {
            stringVal = "none";
        }
        return OdfDirectionType.enumValueOf(stringVal);
    }

    public void setDirection(OdfDirectionType direction) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "direction"), direction.toString());
    }

    public OdfSpeedType getSpeed() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "speed"));
        if (stringVal.length() == 0) {
            stringVal = "medium";
        }
        return OdfSpeedType.enumValueOf(stringVal);
    }

    public void setSpeed(OdfSpeedType speed) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "speed"), speed.toString());
    }

    public OdfPercent getStartScale() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "start-scale"));
        if (stringVal.length() == 0) {
            stringVal = "100%";
        }
        return OdfPercent.valueOf(stringVal);
    }

    public void setStartScale(OdfPercent startScale) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "start-scale"), startScale.toString());
    }

    public OdfAnyURI getHref() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.XLINK, "href"));
        return OdfAnyURI.valueOf(stringVal);
    }

    public void setHref(OdfAnyURI href) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.XLINK, "href"), href.toString());
        this.setOdfAttribute(OdfName.get(OdfNamespace.XLINK, "type"), "simple");
        this.setOdfAttribute(OdfName.get(OdfNamespace.XLINK, "show"), "embed");
        this.setOdfAttribute(OdfName.get(OdfNamespace.XLINK, "actuate"), "onRequest");
    }

    public OdfNonNegativeInteger getVerb() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "verb"));
        return OdfNonNegativeInteger.valueOf(stringVal);
    }

    public void setVerb(OdfNonNegativeInteger verb) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.PRESENTATION, "verb"), verb.toString());
    }

    public OdfSoundElement createSoundElement(OdfAnyURI href) {
        OdfSoundElement nSound = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoundElement.class);
        nSound.setHref(href);
        this.appendChild((Node)((Object)nSound));
        return nSound;
    }
}

