/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.office;

import java.util.HashMap;
import java.util.Vector;
import org.odftoolkit.odfdom.doc.element.number.OdfBooleanStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfCurrencyStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfDateStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfNumberStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfPercentageStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfTextStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfTimeStyle;
import org.odftoolkit.odfdom.doc.element.style.OdfStyle;
import org.odftoolkit.odfdom.doc.element.text.OdfListStyle;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OdfStylesBase {
    private HashMap<OdfStyleFamily, HashMap<String, OdfStyle>> mStyles;
    private HashMap<String, OdfListStyle> mListStyles;
    private HashMap<String, OdfNumberStyle> mNumberStyles;
    private HashMap<String, OdfDateStyle> mDateStyles;
    private HashMap<String, OdfPercentageStyle> mPercentageStyles;
    private HashMap<String, OdfCurrencyStyle> mCurrencyStyles;
    private HashMap<String, OdfTimeStyle> mTimeStyles;
    private HashMap<String, OdfBooleanStyle> mBooleanStyles;
    private HashMap<String, OdfTextStyle> mTextStyles;

    OdfStylesBase() {
    }

    OdfStyle getStyle(String name, OdfStyleFamily familyType) {
        HashMap<String, OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            return familyMap.get(name);
        }
        return null;
    }

    Iterable<OdfStyle> getStylesForFamily(OdfStyleFamily familyType) {
        HashMap<String, OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            return familyMap.values();
        }
        return new Vector<OdfStyle>();
    }

    OdfListStyle getListStyle(String name) {
        if (this.mListStyles != null) {
            return this.mListStyles.get(name);
        }
        return null;
    }

    Iterable<OdfListStyle> getListStyles() {
        if (this.mListStyles != null) {
            return this.mListStyles.values();
        }
        return new Vector<OdfListStyle>();
    }

    OdfNumberStyle getNumberStyle(String name) {
        if (this.mNumberStyles != null) {
            return this.mNumberStyles.get(name);
        }
        return null;
    }

    Iterable<OdfNumberStyle> getNumberStyles() {
        if (this.mNumberStyles != null) {
            return this.mNumberStyles.values();
        }
        return new Vector<OdfNumberStyle>();
    }

    OdfDateStyle getDateStyle(String name) {
        if (this.mDateStyles != null) {
            return this.mDateStyles.get(name);
        }
        return null;
    }

    Iterable<OdfDateStyle> getDateStyles() {
        if (this.mDateStyles != null) {
            return this.mDateStyles.values();
        }
        return new Vector<OdfDateStyle>();
    }

    OdfPercentageStyle getPercentageStyle(String name) {
        if (this.mPercentageStyles != null) {
            return this.mPercentageStyles.get(name);
        }
        return null;
    }

    Iterable<OdfPercentageStyle> getPercentageStyles() {
        if (this.mPercentageStyles != null) {
            return this.mPercentageStyles.values();
        }
        return new Vector<OdfPercentageStyle>();
    }

    OdfCurrencyStyle getCurrencyStyle(String name) {
        if (this.mCurrencyStyles != null) {
            return this.mCurrencyStyles.get(name);
        }
        return null;
    }

    Iterable<OdfCurrencyStyle> getCurrencyStyles() {
        if (this.mCurrencyStyles != null) {
            return this.mCurrencyStyles.values();
        }
        return new Vector<OdfCurrencyStyle>();
    }

    OdfTimeStyle getTimeStyle(String name) {
        if (this.mTimeStyles != null) {
            return this.mTimeStyles.get(name);
        }
        return null;
    }

    Iterable<OdfTimeStyle> getTimeStyles() {
        if (this.mTimeStyles != null) {
            return this.mTimeStyles.values();
        }
        return new Vector<OdfTimeStyle>();
    }

    OdfBooleanStyle getBooleanStyle(String name) {
        if (this.mBooleanStyles != null) {
            return this.mBooleanStyles.get(name);
        }
        return null;
    }

    Iterable<OdfBooleanStyle> getBooleanStyles() {
        if (this.mBooleanStyles != null) {
            return this.mBooleanStyles.values();
        }
        return new Vector<OdfBooleanStyle>();
    }

    OdfTextStyle getTextStyle(String name) {
        if (this.mTextStyles != null) {
            return this.mTextStyles.get(name);
        }
        return null;
    }

    Iterable<OdfTextStyle> getTextStyles() {
        if (this.mTextStyles != null) {
            return this.mTextStyles.values();
        }
        return new Vector<OdfTextStyle>();
    }

    void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfStyle) {
            HashMap<String, OdfStyle> familyMap;
            OdfStyle style = (OdfStyle)node;
            if (this.mStyles == null) {
                this.mStyles = new HashMap();
            }
            if ((familyMap = this.mStyles.get(style.getFamily())) == null) {
                familyMap = new HashMap();
                this.mStyles.put(style.getFamily(), familyMap);
            }
            familyMap.put(style.getName(), style);
        } else if (node instanceof OdfListStyle) {
            OdfListStyle listStyle = (OdfListStyle)node;
            if (this.mListStyles == null) {
                this.mListStyles = new HashMap();
            }
            this.mListStyles.put(listStyle.getName(), listStyle);
        } else if (node instanceof OdfNumberStyle) {
            OdfNumberStyle numberStyle = (OdfNumberStyle)node;
            if (this.mNumberStyles == null) {
                this.mNumberStyles = new HashMap();
            }
            this.mNumberStyles.put(numberStyle.getName(), numberStyle);
        } else if (node instanceof OdfDateStyle) {
            OdfDateStyle dateStyle = (OdfDateStyle)node;
            if (this.mDateStyles == null) {
                this.mDateStyles = new HashMap();
            }
            this.mDateStyles.put(dateStyle.getName(), dateStyle);
        } else if (node instanceof OdfPercentageStyle) {
            OdfPercentageStyle percentageStyle = (OdfPercentageStyle)node;
            if (this.mPercentageStyles == null) {
                this.mPercentageStyles = new HashMap();
            }
            this.mPercentageStyles.put(percentageStyle.getName(), percentageStyle);
        } else if (node instanceof OdfCurrencyStyle) {
            OdfCurrencyStyle currencyStyle = (OdfCurrencyStyle)node;
            if (this.mCurrencyStyles == null) {
                this.mCurrencyStyles = new HashMap();
            }
            this.mCurrencyStyles.put(currencyStyle.getName(), currencyStyle);
        } else if (node instanceof OdfTimeStyle) {
            OdfTimeStyle timeStyle = (OdfTimeStyle)node;
            if (this.mTimeStyles == null) {
                this.mTimeStyles = new HashMap();
            }
            this.mTimeStyles.put(timeStyle.getName(), timeStyle);
        } else if (node instanceof OdfBooleanStyle) {
            OdfBooleanStyle booleanStyle = (OdfBooleanStyle)node;
            if (this.mBooleanStyles == null) {
                this.mBooleanStyles = new HashMap();
            }
            this.mBooleanStyles.put(booleanStyle.getName(), booleanStyle);
        } else if (node instanceof OdfTextStyle) {
            OdfTextStyle textStyle = (OdfTextStyle)node;
            if (this.mTextStyles == null) {
                this.mTextStyles = new HashMap();
            }
            this.mTextStyles.put(textStyle.getName(), textStyle);
        }
    }

    void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfStyle) {
            OdfStyle style;
            HashMap<String, OdfStyle> familyMap;
            if (this.mStyles != null && (familyMap = this.mStyles.get((style = (OdfStyle)node).getFamily())) != null) {
                familyMap.remove(style.getName());
                if (familyMap.isEmpty()) {
                    this.mStyles.remove(style.getFamily());
                }
            }
        } else if (node instanceof OdfListStyle) {
            if (this.mListStyles != null) {
                OdfListStyle listStyle = (OdfListStyle)node;
                this.mListStyles.remove(listStyle.getName());
            }
        } else if (node instanceof OdfNumberStyle) {
            if (this.mNumberStyles != null) {
                OdfNumberStyle numberStyle = (OdfNumberStyle)node;
                this.mNumberStyles.remove(numberStyle.getName());
            }
        } else if (node instanceof OdfDateStyle) {
            if (this.mDateStyles != null) {
                OdfDateStyle dateStyle = (OdfDateStyle)node;
                this.mDateStyles.remove(dateStyle.getName());
            }
        } else if (node instanceof OdfPercentageStyle) {
            if (this.mPercentageStyles != null) {
                OdfPercentageStyle percentageStyle = (OdfPercentageStyle)node;
                this.mPercentageStyles.remove(percentageStyle.getName());
            }
        } else if (node instanceof OdfCurrencyStyle) {
            if (this.mCurrencyStyles != null) {
                OdfCurrencyStyle currencyStyle = (OdfCurrencyStyle)node;
                this.mCurrencyStyles.remove(currencyStyle.getName());
            }
        } else if (node instanceof OdfTimeStyle) {
            if (this.mTimeStyles != null) {
                OdfTimeStyle timeStyle = (OdfTimeStyle)node;
                this.mTimeStyles.remove(timeStyle.getName());
            }
        } else if (node instanceof OdfBooleanStyle) {
            if (this.mBooleanStyles != null) {
                OdfBooleanStyle booleanStyle = (OdfBooleanStyle)node;
                this.mBooleanStyles.remove(booleanStyle.getName());
            }
        } else if (node instanceof OdfTextStyle && this.mTextStyles != null) {
            OdfTextStyle textStyle = (OdfTextStyle)node;
            this.mTextStyles.remove(textStyle.getName());
        }
    }
}

