/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.office;

import java.util.HashMap;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.number.OdfBooleanStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfCurrencyStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfDateStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfNumberStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfPercentageStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfTextStyle;
import org.odftoolkit.odfdom.doc.element.number.OdfTimeStyle;
import org.odftoolkit.odfdom.doc.element.office.OdfStylesBase;
import org.odftoolkit.odfdom.doc.element.style.OdfPageLayout;
import org.odftoolkit.odfdom.doc.element.style.OdfStyle;
import org.odftoolkit.odfdom.doc.element.text.OdfListStyle;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.office.OdfAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfAutomaticStyles
extends OdfAutomaticStylesElement {
    private static final long serialVersionUID = -2925910664631016175L;
    private HashMap<String, OdfPageLayout> mPageLayouts;
    private OdfStylesBase mStylesBaseImpl = new OdfStylesBase();

    public OdfAutomaticStyles(OdfFileDom _aOwnerDoc) {
        super(_aOwnerDoc);
    }

    public OdfStyle createStyle(OdfStyleFamily styleFamily) {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfStyle newStyle = dom.createOdfElement(OdfStyle.class);
        newStyle.setFamily(styleFamily);
        newStyle.setName(new OdfStyleName(this.createUniqueStyleName(styleFamily)));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfListStyle createListStyle() {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfListStyle newStyle = dom.createOdfElement(OdfListStyle.class);
        newStyle.setName(new OdfStyleName(this.createUniqueStyleName(OdfStyleFamily.List)));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfPageLayout getPageLayout(String name) {
        if (this.mPageLayouts != null) {
            return this.mPageLayouts.get(name);
        }
        return null;
    }

    public OdfStyle getStyle(String name, OdfStyleFamily familyType) {
        return this.mStylesBaseImpl.getStyle(name, familyType);
    }

    public Iterable<OdfStyle> getStylesForFamily(OdfStyleFamily familyType) {
        return this.mStylesBaseImpl.getStylesForFamily(familyType);
    }

    public OdfListStyle getListStyle(String name) {
        return this.mStylesBaseImpl.getListStyle(name);
    }

    public Iterable<OdfListStyle> getListStyles() {
        return this.mStylesBaseImpl.getListStyles();
    }

    public OdfNumberStyle getNumberStyle(String name) {
        return this.mStylesBaseImpl.getNumberStyle(name);
    }

    public Iterable<OdfNumberStyle> getNumberStyles() {
        return this.mStylesBaseImpl.getNumberStyles();
    }

    public OdfDateStyle getDateStyle(String name) {
        return this.mStylesBaseImpl.getDateStyle(name);
    }

    public Iterable<OdfDateStyle> getDateStyles() {
        return this.mStylesBaseImpl.getDateStyles();
    }

    public OdfPercentageStyle getPercentageStyle(String name) {
        return this.mStylesBaseImpl.getPercentageStyle(name);
    }

    public Iterable<OdfPercentageStyle> getPercentageStyles() {
        return this.mStylesBaseImpl.getPercentageStyles();
    }

    public OdfCurrencyStyle getCurrencyStyle(String name) {
        return this.mStylesBaseImpl.getCurrencyStyle(name);
    }

    public Iterable<OdfCurrencyStyle> getCurrencyStyles() {
        return this.mStylesBaseImpl.getCurrencyStyles();
    }

    public OdfTimeStyle getTimeStyle(String name) {
        return this.mStylesBaseImpl.getTimeStyle(name);
    }

    public Iterable<OdfTimeStyle> getTimeStyles() {
        return this.mStylesBaseImpl.getTimeStyles();
    }

    public OdfBooleanStyle getBooleanStyle(String name) {
        return this.mStylesBaseImpl.getBooleanStyle(name);
    }

    public Iterable<OdfBooleanStyle> getBooleanStyles() {
        return this.mStylesBaseImpl.getBooleanStyles();
    }

    public OdfTextStyle getTextStyle(String name) {
        return this.mStylesBaseImpl.getTextStyle(name);
    }

    public Iterable<OdfTextStyle> getTextStyles() {
        return this.mStylesBaseImpl.getTextStyles();
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfPageLayout) {
            OdfPageLayout pageLayout = (OdfPageLayout)node;
            if (this.mPageLayouts == null) {
                this.mPageLayouts = new HashMap();
            }
            this.mPageLayouts.put(pageLayout.getName(), pageLayout);
        } else {
            this.mStylesBaseImpl.onOdfNodeInserted(node, refNode);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfPageLayout) {
            if (this.mPageLayouts != null) {
                OdfPageLayout pageLayout = (OdfPageLayout)node;
                this.mPageLayouts.remove(pageLayout.getName());
            }
        } else {
            this.mStylesBaseImpl.onOdfNodeRemoved(node);
        }
    }

    public void optimize() {
        OdfStyle style = OdfElement.findFirstChildNode(OdfStyle.class, (Node)((Object)this));
        while (style != null) {
            OdfStyle nextStyle = OdfElement.findNextChildNode(OdfStyle.class, (Node)((Object)style));
            if (style.getStyleUserCount() < 1) {
                this.removeChild((Node)((Object)style));
            }
            style = nextStyle;
        }
    }

    public OdfStyle makeStyleUnique(OdfStyle referenceStyle) {
        OdfStyle newStyle = null;
        newStyle = referenceStyle.getOwnerDocument() != this.getOwnerDocument() ? (OdfStyle)((Object)this.getOwnerDocument().importNode((Node)((Object)referenceStyle), true)) : (OdfStyle)((Object)referenceStyle.cloneNode(true));
        newStyle.setName(new OdfStyleName(this.createUniqueStyleName(newStyle.getFamily())));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    private String createUniqueStyleName(OdfStyleFamily styleFamily) {
        String unique_name;
        if (styleFamily.equals(OdfStyleFamily.List)) {
            while (this.getListStyle(unique_name = String.format("l%06x", (int)(Math.random() * 1.6777215E7))) != null) {
            }
        } else {
            while (this.getStyle(unique_name = String.format("a%06x", (int)(Math.random() * 1.6777215E7)), styleFamily) != null) {
            }
        }
        return unique_name;
    }
}

