/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.lang.reflect.Field;
import org.apache.xerces.dom.DocumentImpl;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.element.OdfElementFactory;
import org.odftoolkit.odfdom.doc.element.office.OdfAutomaticStyles;
import org.odftoolkit.odfdom.doc.element.office.OdfBody;
import org.odftoolkit.odfdom.doc.element.office.OdfMasterStyles;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfFileDom
extends DocumentImpl {
    private static final long serialVersionUID = 766167617530147000L;
    private String mPackagePath;
    private OdfDocument mOdfDocument;

    OdfFileDom(OdfDocument odfDocument, String packagePath) {
        this.mOdfDocument = odfDocument;
        this.mPackagePath = packagePath;
    }

    public OdfDocument getOdfDocument() {
        return this.mOdfDocument;
    }

    public String getPackagePath() {
        return this.mPackagePath;
    }

    public OdfElement createElementNS(String nsuri, String qname) throws DOMException {
        return this.createElementNS(OdfName.get(nsuri, qname));
    }

    public OdfElement createElementNS(OdfName name) throws DOMException {
        return OdfElementFactory.createOdfElement(this, name);
    }

    public <T extends OdfElement> T createOdfElement(Class<T> clazz) {
        try {
            Field fname = clazz.getField("ELEMENT_NAME");
            OdfName name = (OdfName)fname.get(null);
            return (T)((Object)this.createElementNS(name));
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            return null;
        }
    }

    public OdfAutomaticStyles getAutomaticStyles() {
        return OdfElement.findFirstChildNode(OdfAutomaticStyles.class, this.getFirstChild());
    }

    public OdfAutomaticStyles getOrCreateAutomaticStyles() {
        OdfAutomaticStyles automaticStyles = this.getAutomaticStyles();
        if (automaticStyles == null) {
            automaticStyles = this.createOdfElement(OdfAutomaticStyles.class);
            Node parent = this.getFirstChild();
            OdfElement sibling = OdfElement.findFirstChildNode(OdfBody.class, parent);
            if (sibling == null) {
                sibling = OdfElement.findFirstChildNode(OdfMasterStyles.class, parent);
            }
            if (sibling == null) {
                parent.appendChild((Node)((Object)automaticStyles));
            } else {
                parent.insertBefore((Node)((Object)automaticStyles), (Node)((Object)sibling));
            }
        }
        return automaticStyles;
    }

    public String toString() {
        return ((OdfElement)((Object)this.getDocumentElement())).toString();
    }
}

