/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen.rng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.odftoolkit.odfdom.codegen.Config;
import org.odftoolkit.odfdom.codegen.rng.RngAttribute;
import org.odftoolkit.odfdom.codegen.rng.RngCharacterNode;
import org.odftoolkit.odfdom.codegen.rng.RngData;
import org.odftoolkit.odfdom.codegen.rng.RngDefine;
import org.odftoolkit.odfdom.codegen.rng.RngElement;
import org.odftoolkit.odfdom.codegen.rng.RngName;
import org.odftoolkit.odfdom.codegen.rng.RngNode;
import org.odftoolkit.odfdom.codegen.rng.RngReference;
import org.odftoolkit.odfdom.codegen.rng.RngValue;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RngHandler
extends DefaultHandler {
    private HashMap<String, Vector<RngDefine>> Defines = new HashMap();
    private HashMap<String, String> Namespaces;
    private Stack<RngNode> ElementStack = new Stack();
    private List<RngElement> Elements = new Vector<RngElement>();
    private HashSet<String> DataTypes = new HashSet();
    private Config Config;
    private String URL;

    public RngHandler(Config config, String url) {
        this.Namespaces = new HashMap();
        this.Config = config;
        this.URL = url;
    }

    public static RngHandler parse(String url, Config config) throws IOException, SAXException {
        RngHandler xThis = new RngHandler(config, url);
        FileInputStream aContent = new FileInputStream(url);
        InputSource aSource = new InputSource(aContent);
        XMLReader xr = xThis.createReader();
        xr.setContentHandler(xThis);
        xr.setErrorHandler(xThis);
        xr.parse(aSource);
        return xThis;
    }

    private XMLReader createReader() throws SAXException {
        return new RngFilter(XMLReaderFactory.createXMLReader(), this.Namespaces);
    }

    public Config getConfiguration() {
        return this.Config;
    }

    public Iterator<String> getDataTypes() {
        return this.DataTypes.iterator();
    }

    public Iterator<RngDefine> getDefines(String name) {
        Vector<RngDefine> defines = this.Defines.get(name);
        if (defines == null) {
            defines = new Vector();
        }
        return defines.iterator();
    }

    public Iterator<RngElement> getElements() {
        return this.Elements.iterator();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        RngNode node;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String attQName = attributes.getQName(i);
            if (!attQName.startsWith("xmlns:")) continue;
            this.Namespaces.put(attQName.substring(6), attributes.getValue(i));
        }
        if (localName.equals(RngDefine.LOCAL_NAME)) {
            RngDefine define;
            node = define = new RngDefine(attributes);
            Vector<RngDefine> defines = this.Defines.get(define.getName());
            if (defines == null) {
                defines = new Vector();
                this.Defines.put(define.getName(), defines);
            }
            defines.add(define);
        } else if (localName.equals("attribute")) {
            node = new RngAttribute(this, attributes);
        } else if (localName.equals("element")) {
            RngElement element = new RngElement(this, attributes);
            node = element;
            this.Elements.add(element);
        } else if (localName.equals("ref")) {
            node = new RngReference(attributes);
        } else if (localName.equals(RngValue.LOCAL_NAME)) {
            node = new RngValue();
        } else if (localName.equals("name")) {
            node = new RngName();
        } else if (localName.equals(RngData.LOCAL_NAME)) {
            node = new RngData(attributes);
            this.DataTypes.add(((RngData)node).getType());
        } else {
            node = new RngNode(localName);
        }
        if (!this.ElementStack.isEmpty()) {
            ((RngNode)this.ElementStack.lastElement()).addChild(node);
        }
        this.ElementStack.push(node);
        if (localName.equals("include")) {
            try {
                String href = attributes.getValue("href");
                String path = new String();
                File parent = new File(this.URL).getParentFile();
                if (parent != null) {
                    path = parent.getAbsolutePath() + File.separator;
                }
                path = path + href;
                System.out.println("include path = " + path);
                FileInputStream aContent = new FileInputStream(path);
                InputSource aSource = new InputSource(aContent);
                XMLReader xr = this.createReader();
                aContent = new FileInputStream(path);
                xr.setContentHandler(this);
                xr.setErrorHandler(this);
                xr.parse(aSource);
            }
            catch (IOException ex) {
                throw new SAXException(ex.toString());
            }
            node = new RngNode(localName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        RngCharacterNode value;
        RngNode node;
        if (!this.ElementStack.isEmpty() && (node = (RngNode)this.ElementStack.lastElement()) instanceof RngCharacterNode && (value = (RngCharacterNode)node) != null) {
            value.Value = value.Value == null ? new String(ch, start, length) : value.Value + new String(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.ElementStack.isEmpty() || !((RngNode)this.ElementStack.lastElement()).getLocalName().equals(localName)) {
            throw new SAXException(new String("endElement() mismatches with startElement()!"));
        }
        this.ElementStack.pop();
    }

    public HashMap<String, String> getNamespaces() {
        return this.Namespaces;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RngFilter
    extends XMLFilterImpl {
        private HashMap<String, String> Namespaces;

        public RngFilter(XMLReader parent, HashMap<String, String> namespaces) {
            super(parent);
            this.Namespaces = namespaces;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (prefix.length() != 0) {
                this.Namespaces.put(prefix, uri);
            }
            super.startPrefixMapping(prefix, uri);
        }
    }
}

