/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen.rng;

import java.util.Iterator;
import java.util.Vector;
import org.odftoolkit.odfdom.codegen.rng.RngAttribute;
import org.odftoolkit.odfdom.codegen.rng.RngDefine;
import org.odftoolkit.odfdom.codegen.rng.RngHandler;
import org.odftoolkit.odfdom.codegen.rng.RngName;
import org.odftoolkit.odfdom.codegen.rng.RngNode;
import org.odftoolkit.odfdom.codegen.rng.RngReference;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RngElement
extends RngNode {
    public static final String LOCAL_NAME = "element";
    private String Name;
    private RngHandler Handler;
    private Vector<AttributeEntry> Attributes;
    private Vector<SubElementEntry> SubElements;
    private Vector<SubAttributeEntry> SubAttributes;
    public static int groupCount;

    RngElement(RngHandler handler, Attributes attributes) {
        super(LOCAL_NAME);
        this.Handler = handler;
        this.Name = attributes.getValue("name");
    }

    public Iterator<AttributeEntry> getAttributes() {
        if (this.Attributes == null) {
            this.Attributes = new Vector();
            this.getAttributes(this.Attributes, this, false);
        }
        return this.Attributes.iterator();
    }

    private void getAttributes(Vector<AttributeEntry> attributes, RngNode parent, boolean optional) {
        for (RngNode child : parent.getChildren()) {
            if (child.getLocalName().equals("attribute")) {
                attributes.add(new AttributeEntry((RngAttribute)child, optional));
                continue;
            }
            if (child.getLocalName().equals("ref")) {
                Iterator<RngDefine> defineIter = this.Handler.getDefines(((RngReference)child).getName());
                while (defineIter.hasNext()) {
                    this.getAttributes(attributes, defineIter.next(), optional);
                }
                continue;
            }
            if (child.getLocalName().equals("attribute") || child.getLocalName().equals(LOCAL_NAME)) continue;
            if (!optional) {
                optional = child.getLocalName().equals("optional");
            }
            this.getAttributes(attributes, child, optional);
        }
    }

    public Iterator<String> getNames() {
        Vector<String> names = new Vector<String>();
        if (this.Name != null && this.Name.length() != 0) {
            names.add(this.Name);
        } else {
            this.getNames(names, this);
        }
        return names.iterator();
    }

    private void getNames(Vector<String> names, RngNode parent) {
        for (RngNode child : parent.getChildren()) {
            if (child.getLocalName().equals("name")) {
                names.add(((RngName)child).Value);
                continue;
            }
            if (child.getLocalName().equals("ref")) {
                Iterator<RngDefine> defineIter = this.Handler.getDefines(((RngReference)child).getName());
                while (defineIter.hasNext()) {
                    this.getNames(names, defineIter.next());
                }
                continue;
            }
            if (child.getLocalName().equals("attribute") || child.getLocalName().equals(LOCAL_NAME)) continue;
            this.getNames(names, child);
        }
    }

    private void getSubElements(Vector<SubElementEntry> subelements, RngNode parent) {
        for (RngNode child : parent.getChildren()) {
            if (child.getLocalName().equals("ref")) {
                Iterator<RngDefine> defineIter = this.Handler.getDefines(((RngReference)child).getName());
                while (defineIter.hasNext()) {
                    this.getSubElements(subelements, defineIter.next());
                }
                continue;
            }
            if (child.getLocalName().equals("attribute")) continue;
            if (child.getLocalName().equals(LOCAL_NAME)) {
                if (((RngElement)child).getName() == null) continue;
                this.SubElements.add(new SubElementEntry((RngElement)child, false));
                continue;
            }
            if (child.getLocalName().equals("optional")) {
                Iterator<RngNode> optIter = child.getChildren().iterator();
                this.getChildReference(subelements, optIter);
                continue;
            }
            if (child.getLocalName().equals("choice")) {
                Iterator<RngNode> choIter = child.getChildren().iterator();
                this.getChildReference(subelements, choIter);
                continue;
            }
            if (child.getLocalName().equals("group")) {
                Iterator<RngNode> grpIter = child.getChildren().iterator();
                this.getChildReference(subelements, grpIter);
                continue;
            }
            if (child.getLocalName().equals("zeroOrMore")) {
                Iterator<RngNode> zomIter = child.getChildren().iterator();
                this.getChildReference(subelements, zomIter);
                continue;
            }
            if (child.getLocalName().equals("oneOrMore")) {
                Iterator<RngNode> oomIter = child.getChildren().iterator();
                this.getChildReference(subelements, oomIter);
                continue;
            }
            if (!child.getLocalName().equals("interleave")) continue;
            Iterator<RngNode> itlIter = child.getChildren().iterator();
            this.getChildReference(subelements, itlIter);
        }
    }

    private void getChildReference(Vector<SubElementEntry> subelements, Iterator<RngNode> optIter) {
        while (optIter.hasNext()) {
            RngNode temNode = optIter.next();
            if (temNode.getLocalName().equals("ref")) {
                Iterator<RngDefine> defineIter = this.Handler.getDefines(((RngReference)temNode).getName());
                while (defineIter.hasNext()) {
                    this.getSubElements(subelements, defineIter.next());
                }
                continue;
            }
            this.getSubElements(subelements, temNode);
        }
    }

    public Vector<SubElementEntry> getSubElements() {
        if (this.SubElements == null) {
            this.SubElements = new Vector();
            this.getSubElements(this.SubElements, this);
        }
        return this.SubElements;
    }

    public String getName() {
        return this.Name;
    }

    private void getSubAttributes(Vector<SubAttributeEntry> subattributes, RngNode parent) {
        for (RngNode child : parent.getChildren()) {
            if (child.getLocalName().equals("ref")) {
                Iterator<RngDefine> defineIter = this.Handler.getDefines(((RngReference)child).getName());
                while (defineIter.hasNext()) {
                    this.getSubAttributes(subattributes, defineIter.next());
                }
                continue;
            }
            if (child.getLocalName().equals("attribute")) {
                subattributes.add(new SubAttributeEntry((RngAttribute)child, false, 0));
                continue;
            }
            if (child.getLocalName().equals(LOCAL_NAME) || child.getLocalName().equals("optional")) continue;
            if (child.getLocalName().equals("choice")) {
                for (RngNode choNode : child.getChildren()) {
                    if (choNode.getLocalName().equals("attribute")) {
                        subattributes.add(new SubAttributeEntry((RngAttribute)choNode, true, 0));
                        continue;
                    }
                    if (!choNode.getLocalName().equals("group")) continue;
                    for (RngNode grpNode : choNode.getChildren()) {
                        if (grpNode.getLocalName().equals("attribute")) {
                            subattributes.add(new SubAttributeEntry((RngAttribute)grpNode, true, groupCount));
                            continue;
                        }
                        if (!grpNode.getLocalName().equals("ref")) continue;
                        Iterator<RngDefine> defineIter = this.Handler.getDefines(((RngReference)grpNode).getName());
                        while (defineIter.hasNext()) {
                            RngNode refNode = defineIter.next();
                            if (!refNode.getLocalName().equals("attribute")) continue;
                            subattributes.add(new SubAttributeEntry((RngAttribute)refNode, true, groupCount));
                        }
                    }
                    ++groupCount;
                }
                continue;
            }
            if (child.getLocalName().equals("group")) {
                Iterator<RngNode> grpIter = child.getChildren().iterator();
                this.getAttributeReference(subattributes, grpIter);
                continue;
            }
            if (child.getLocalName().equals("zeroOrMore")) {
                Iterator<RngNode> zomIter = child.getChildren().iterator();
                this.getAttributeReference(subattributes, zomIter);
                continue;
            }
            if (child.getLocalName().equals("oneOrMore")) {
                Iterator<RngNode> oomIter = child.getChildren().iterator();
                this.getAttributeReference(subattributes, oomIter);
                continue;
            }
            if (!child.getLocalName().equals("interleave")) continue;
            Iterator<RngNode> itlIter = child.getChildren().iterator();
            this.getAttributeReference(subattributes, itlIter);
        }
    }

    private void getAttributeReference(Vector<SubAttributeEntry> subattributes, Iterator<RngNode> optIter) {
        while (optIter.hasNext()) {
            RngNode temNode = optIter.next();
            if (temNode.getLocalName().equals("ref")) {
                Iterator<RngDefine> defineIter = this.Handler.getDefines(((RngReference)temNode).getName());
                while (defineIter.hasNext()) {
                    this.getSubAttributes(subattributes, defineIter.next());
                }
                continue;
            }
            if (temNode.getLocalName().equals(LOCAL_NAME) || temNode.getLocalName().equals("optional")) continue;
            this.getSubAttributes(subattributes, temNode);
        }
    }

    public Vector<SubAttributeEntry> getSubAttributes() {
        if (this.SubAttributes == null) {
            this.SubAttributes = new Vector();
            groupCount = 1;
            this.getSubAttributes(this.SubAttributes, this);
        }
        return this.SubAttributes;
    }

    public class SubAttributeEntry {
        public RngAttribute Attribute;
        public boolean IsChoice;
        public int GroupId;

        public SubAttributeEntry(RngAttribute attribute, boolean isChoice, int groupId) {
            this.Attribute = attribute;
            this.IsChoice = isChoice;
            this.GroupId = groupId;
        }
    }

    public class SubElementEntry {
        public RngElement Element;
        public boolean Optional;

        public SubElementEntry(RngElement element, boolean optional) {
            this.Element = element;
            this.Optional = optional;
        }
    }

    public class AttributeEntry {
        public RngAttribute Attribute;
        public boolean Optional;

        public AttributeEntry(RngAttribute attribute, boolean optional) {
            this.Attribute = attribute;
            this.Optional = optional;
        }
    }
}

