/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen.rng;

import java.util.Iterator;
import java.util.Vector;
import org.odftoolkit.odfdom.codegen.Config;
import org.odftoolkit.odfdom.codegen.rng.RngData;
import org.odftoolkit.odfdom.codegen.rng.RngDefine;
import org.odftoolkit.odfdom.codegen.rng.RngHandler;
import org.odftoolkit.odfdom.codegen.rng.RngName;
import org.odftoolkit.odfdom.codegen.rng.RngNode;
import org.odftoolkit.odfdom.codegen.rng.RngReference;
import org.odftoolkit.odfdom.codegen.rng.RngValue;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RngAttribute
extends RngNode {
    public static final String TYPE_ENUM = "enum";
    public static final String LOCAL_NAME = "attribute";
    private String Name;
    private String DefaultValue;
    private RngHandler Handler;
    private String Type;
    private Vector<String> Values;

    RngAttribute(RngHandler handler, Attributes attributes) {
        super(LOCAL_NAME);
        this.Name = RngAttribute.forceString(attributes.getValue("name"));
        this.DefaultValue = RngAttribute.forceString(attributes.getValue("http://relaxng.org/ns/compatibility/annotations/1.0", "defaultValue"));
        this.Handler = handler;
    }

    public String getDefaultValue() {
        return this.DefaultValue;
    }

    public String getType() {
        if (this.Type == null) {
            this.getType(this);
            if (this.Type == null) {
                this.Type = this.Values != null && !this.Values.isEmpty() ? TYPE_ENUM : new String();
            }
        }
        return this.Type;
    }

    public Iterator<String> getValues() {
        if (this.Values == null) {
            Vector temp = new Vector();
            return temp.iterator();
        }
        return this.Values.iterator();
    }

    private boolean getType(RngNode parent) {
        for (RngNode child : parent.getChildren()) {
            if (child.getLocalName().equals(RngValue.LOCAL_NAME)) {
                if (this.Values == null) {
                    this.Values = new Vector();
                }
                this.Values.add(((RngValue)child).Value);
                continue;
            }
            if (child.getLocalName().equals("ref")) {
                Config.DataTypeConfig config;
                String defName = ((RngReference)child).getName();
                if (this.Type == null && (config = this.Handler.getConfiguration().getDataTypeConfiguration(defName)) != null) {
                    this.Type = defName;
                }
                Iterator<RngDefine> defineIter = this.Handler.getDefines(defName);
                while (defineIter.hasNext()) {
                    if (!this.getType(defineIter.next())) continue;
                    return true;
                }
                continue;
            }
            if (child.getLocalName().equals(RngData.LOCAL_NAME)) {
                if (this.Type == null) {
                    this.Type = ((RngData)child).getType();
                }
                return true;
            }
            if (child.getLocalName().equals(LOCAL_NAME) || child.getLocalName().equals("element") || !this.getType(child)) continue;
            return true;
        }
        return false;
    }

    public Iterator<String> getNames() {
        Vector<String> names = new Vector<String>();
        if (this.Name != null && this.Name.length() != 0) {
            names.add(this.Name);
        } else {
            this.getNames(names, this);
        }
        return names.iterator();
    }

    private void getNames(Vector<String> names, RngNode parent) {
        for (RngNode child : parent.getChildren()) {
            if (child.getLocalName().equals("name")) {
                names.add(((RngName)child).Value);
                continue;
            }
            if (child.getLocalName().equals("ref")) {
                Iterator<RngDefine> defineIter = this.Handler.getDefines(((RngReference)child).getName());
                while (defineIter.hasNext()) {
                    this.getNames(names, defineIter.next());
                }
                continue;
            }
            if (child.getLocalName().equals(LOCAL_NAME) || child.getLocalName().equals("element")) continue;
            this.getNames(names, child);
        }
    }
}

