/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.odftoolkit.odfdom.codegen.Attribute;
import org.odftoolkit.odfdom.codegen.Config;
import org.odftoolkit.odfdom.codegen.Element;
import org.odftoolkit.odfdom.codegen.rng.RngAttribute;
import org.odftoolkit.odfdom.codegen.rng.RngElement;
import org.odftoolkit.odfdom.codegen.rng.RngHandler;
import org.odftoolkit.odfdom.codegen.rng.RngNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    private HashMap<String, Element> BaseElements = new HashMap();
    private HashMap<String, Element> Elements = new HashMap();
    private RngHandler Handler;
    private Config Config;

    public Schema(Config config) {
        this.Config = config;
    }

    public boolean parseSchema(String path) {
        try {
            this.Handler = RngHandler.parse(path, this.Config);
            if (this.populateElements() && this.renameAttributes() && this.populateBaseElements()) {
                return this.removeBaseAttributes();
            }
        }
        catch (Exception ex) {
            System.err.println("error: could not load " + path + ", " + ex.toString());
            ex.printStackTrace();
        }
        return false;
    }

    public Iterator<Element> getElements() {
        return this.Elements.values().iterator();
    }

    public Iterator<String> getDataTypes() {
        return this.Handler.getDataTypes();
    }

    public Element getBaseElement(String qName) {
        return this.BaseElements.get(qName);
    }

    Iterator<Element> getBaseElements() {
        return this.BaseElements.values().iterator();
    }

    Element getElement(String qName, boolean baseElement) {
        if (baseElement) {
            return this.BaseElements.get(qName);
        }
        return this.Elements.get(qName);
    }

    private boolean populateBaseElements() {
        Iterator<Config.ElementConfig> iter = this.Config.getElementConfigurations();
        while (iter.hasNext()) {
            Config.ElementConfig config = iter.next();
            if (config.Base == null || config.Base.length() == 0 || config.Base.indexOf(58) == -1) continue;
            Element compareElement = this.Elements.get(config.Name);
            if (compareElement == null) {
                System.err.println("error: Element <" + config.Name + "> from configuration not found in schema!");
                return false;
            }
            Element baseElement = this.BaseElements.get(config.Base);
            if (baseElement == null) {
                baseElement = new Element(RngAttribute.getLocalName(config.Base), config.Base, config.StyleFamily, compareElement);
                this.BaseElements.put(baseElement.getQName(), baseElement);
                continue;
            }
            Vector<String> remove_attrs = new Vector<String>();
            Iterator<Attribute> attrIter = baseElement.getAttributes();
            while (attrIter.hasNext()) {
                boolean remove;
                Attribute attr = attrIter.next();
                Attribute compareAttr = compareElement.getAttribute(attr.getQName());
                boolean bl = remove = compareAttr == null;
                if (!remove) {
                    if (!attr.getValueType().equals(compareAttr.getValueType())) {
                        remove = true;
                    } else if (attr.getValueType().equals("enum")) {
                        Iterator<String> i1 = attr.getValues();
                        Iterator<String> i2 = compareAttr.getValues();
                        while (i1.hasNext() && i2.hasNext()) {
                            if (i1.next().equals(i2.next())) continue;
                            remove = true;
                            break;
                        }
                        boolean bl2 = remove = remove || i1.hasNext() || i2.hasNext();
                    }
                }
                if (!remove) continue;
                remove_attrs.add(attr.getQName());
            }
            if (remove_attrs.isEmpty()) continue;
            Iterator removeIter = remove_attrs.iterator();
            while (removeIter.hasNext()) {
                baseElement.removeAttribute((String)removeIter.next());
            }
        }
        return true;
    }

    private boolean removeBaseAttributes() {
        Iterator<Config.ElementConfig> iter = this.Config.getElementConfigurations();
        while (iter.hasNext()) {
            Config.ElementConfig config = iter.next();
            if (config.Base == null || config.Base.length() == 0 || config.Base.indexOf(58) == -1) continue;
            Element baseElement = this.BaseElements.get(config.Base);
            Element thisElement = this.Elements.get(config.Name);
            if (baseElement == null || thisElement == null) continue;
            Iterator<Attribute> attrIter = baseElement.getAttributes();
            while (attrIter.hasNext()) {
                thisElement.removeAttribute(attrIter.next().getQName());
            }
        }
        return true;
    }

    private boolean populateElements() {
        Element element;
        Iterator<RngElement> iter = this.Handler.getElements();
        while (iter.hasNext()) {
            RngElement rngElement = iter.next();
            if (rngElement == null) continue;
            Element element2 = null;
            Iterator<String> nameIter = rngElement.getNames();
            while (nameIter.hasNext()) {
                String elementName = nameIter.next();
                Config.ElementConfig elementConfig = this.Config.getConfigForElement(elementName);
                String tmpName = elementConfig != null && elementConfig.ReName != null && elementConfig.ReName.length() != 0 ? elementConfig.ReName : elementName;
                String styleFamily = elementConfig != null ? elementConfig.StyleFamily : "";
                element2 = new Element(RngNode.getLocalName(tmpName), elementName, styleFamily, element2);
                this.Elements.put(elementName, element2);
                Iterator<RngElement.AttributeEntry> attributes = rngElement.getAttributes();
                while (attributes.hasNext()) {
                    RngElement.AttributeEntry entry = attributes.next();
                    Iterator<String> attributeNames = entry.Attribute.getNames();
                    while (attributeNames.hasNext()) {
                        String QName = attributeNames.next();
                        if (QName != null) {
                            Config.DataTypeConfig config;
                            String valueType = entry.Attribute.getType();
                            String conversionType = null;
                            if (valueType.length() == 0) {
                                valueType = "string";
                            }
                            if ((config = this.Config.getDataTypeConfiguration(valueType)) != null) {
                                valueType = config.ValueType;
                                conversionType = config.ConversionType;
                            }
                            if (valueType == null) {
                                valueType = entry.Attribute.getType();
                            }
                            if (conversionType == null) {
                                conversionType = valueType.equals("enum") ? QName : valueType;
                            }
                            Attribute attr = new Attribute(QName, valueType, conversionType, entry.Attribute.getValues(), entry.Optional, entry.Attribute.getDefaultValue());
                            element2.addAttribute(attr);
                            continue;
                        }
                        System.err.println("warning, element <" + elementName + "> has an attribute without a name!");
                    }
                }
                Iterator<Attribute> attrIter = element2.getAttributes();
                block12: while (attrIter.hasNext()) {
                    Attribute attr = attrIter.next();
                    String valueType = attr.getValueType();
                    if (!valueType.equals("enum")) continue;
                    switch (attr.getValueCount()) {
                        case 0: 
                        case 1: {
                            valueType = "string";
                            break;
                        }
                        case 2: {
                            if (!attr.hasValue("true") || !attr.hasValue("false")) break;
                            valueType = "boolean";
                            break;
                        }
                        default: {
                            continue block12;
                        }
                    }
                    Config.DataTypeConfig config = this.Config.getDataTypeConfiguration(valueType);
                    attr.setValueType(config != null && config.ValueType.length() != 0 ? config.ValueType : valueType);
                    if (config == null || config.ConversionType.length() == 0) continue;
                    attr.setConversionType(config.ConversionType);
                }
            }
        }
        Iterator<RngElement> parentIter = this.Handler.getElements();
        while (parentIter.hasNext()) {
            RngElement parent = parentIter.next();
            element = this.Elements.get(parent.getName());
            Iterator<RngElement.SubElementEntry> subIter = parent.getSubElements().iterator();
            String strSubelements = "";
            while (subIter.hasNext()) {
                boolean isHave = false;
                RngElement.SubElementEntry child = subIter.next();
                String strSubelement = child.Element.getName();
                if (element.getName() == null || child.Element.getName() == null) continue;
                StringTokenizer tokens = new StringTokenizer(strSubelements, ";");
                while (tokens.hasMoreTokens()) {
                    if (!tokens.nextToken().equals(strSubelement)) continue;
                    isHave = true;
                }
                if (isHave) continue;
                element.addSubElement(this.Elements.get(child.Element.getName()));
                strSubelements = strSubelements + ";" + strSubelement;
            }
        }
        parentIter = this.Handler.getElements();
        while (parentIter.hasNext()) {
            RngElement rngElement = parentIter.next();
            if (rngElement.getName() == null) continue;
            element = this.Elements.get(rngElement.getName());
            Iterator<RngElement.SubAttributeEntry> subattributes = rngElement.getSubAttributes().iterator();
            Vector tmpattributes = new Vector();
            Vector<RngAttribute> requiredAttribute = new Vector<RngAttribute>();
            while (subattributes.hasNext()) {
                RngElement.SubAttributeEntry entry = subattributes.next();
                if (entry.IsChoice) continue;
                requiredAttribute.add(entry.Attribute);
            }
            for (RngElement.SubAttributeEntry entry : rngElement.getSubAttributes()) {
                if (!entry.IsChoice || entry.GroupId != 0) continue;
                Vector<RngAttribute> choiceAttribute = new Vector<RngAttribute>();
                if (requiredAttribute.size() > 0) {
                    choiceAttribute.addAll(requiredAttribute);
                }
                choiceAttribute.add(entry.Attribute);
                tmpattributes.add(choiceAttribute);
            }
            int i = 0;
            for (RngElement.SubAttributeEntry entry : rngElement.getSubAttributes()) {
                if (entry.GroupId <= i) continue;
                i = entry.GroupId;
            }
            for (int j = 1; j <= i; ++j) {
                Vector<RngAttribute> groupAttribute = new Vector<RngAttribute>();
                for (RngElement.SubAttributeEntry entry : rngElement.getSubAttributes()) {
                    if (!entry.IsChoice || entry.GroupId != j) continue;
                    groupAttribute.add(entry.Attribute);
                }
                if (requiredAttribute.size() > 0) {
                    groupAttribute.addAll(requiredAttribute);
                }
                tmpattributes.add(groupAttribute);
            }
            if (tmpattributes.size() == 0 && requiredAttribute.size() > 0) {
                tmpattributes.add(requiredAttribute);
            }
            Iterator itOut = tmpattributes.iterator();
            String strTypes = "";
            while (itOut.hasNext()) {
                Vector<Attribute> combAttributes = new Vector<Attribute>();
                Vector outRngAttribute = (Vector)itOut.next();
                for (RngAttribute inAttribute : outRngAttribute) {
                    Iterator<String> attributeNames = inAttribute.getNames();
                    while (attributeNames.hasNext()) {
                        String QName = attributeNames.next();
                        if (QName != null) {
                            Config.DataTypeConfig config;
                            String valueType = inAttribute.getType();
                            String conversionType = null;
                            if (valueType.length() == 0) {
                                valueType = "string";
                            }
                            if ((config = this.Config.getDataTypeConfiguration(valueType)) != null) {
                                valueType = config.ValueType;
                                conversionType = config.ConversionType;
                            }
                            if (valueType == null) {
                                valueType = inAttribute.getType();
                            }
                            if (conversionType == null) {
                                conversionType = valueType.equals("enum") ? QName : valueType;
                            }
                            Attribute attr = new Attribute(QName, valueType, conversionType, inAttribute.getValues(), false, inAttribute.getDefaultValue());
                            combAttributes.add(attr);
                            continue;
                        }
                        System.err.println("warning, element <> has an attribute without a name!");
                    }
                }
                block25: for (Attribute attr : combAttributes) {
                    String valueType = attr.getValueType();
                    if (!valueType.equals("enum")) continue;
                    switch (attr.getValueCount()) {
                        case 0: 
                        case 1: {
                            valueType = "string";
                            break;
                        }
                        case 2: {
                            if (!attr.hasValue("true") || !attr.hasValue("false")) break;
                            valueType = "boolean";
                            break;
                        }
                        default: {
                            continue block25;
                        }
                    }
                    Config.DataTypeConfig config = this.Config.getDataTypeConfiguration(valueType);
                    attr.setValueType(config != null && config.ValueType.length() != 0 ? config.ValueType : valueType);
                    if (config == null || config.ConversionType.length() == 0) continue;
                    attr.setConversionType(config.ConversionType);
                }
                Iterator strIter = combAttributes.iterator();
                String strType = "";
                boolean isExist = false;
                while (strIter.hasNext()) {
                    Attribute strAttr = (Attribute)strIter.next();
                    if (strAttr.getValueType().equals("String") || strAttr.getValueType().equals("Double") || strAttr.getValueType().equals("javax.xml.datatype.XMLGregorianCalendar")) {
                        strType = strType + strAttr.getValueType();
                        continue;
                    }
                    strType = strType + strAttr.getQName();
                }
                StringTokenizer tokens = new StringTokenizer(strTypes, ";");
                while (tokens.hasMoreTokens()) {
                    if (!tokens.nextToken().equals(strType)) continue;
                    isExist = true;
                }
                if (isExist) continue;
                element.addSubAttribute(combAttributes);
                strTypes = strTypes + ";" + strType;
            }
        }
        return true;
    }

    private boolean renameAttributes() {
        for (Element element : this.Elements.values()) {
            HashMap<String, Config.AttributeConfig> confMap = new HashMap<String, Config.AttributeConfig>();
            Iterator<Config.AttributeConfig> configIter = this.Config.getAttributeConfigurations();
            while (configIter.hasNext()) {
                Config.AttributeConfig config = configIter.next();
                if (config.Element.equals(element.getQName()) && element.getAttribute(config.Name) != null) {
                    confMap.put(config.Name, config);
                }
                if (config.Element.length() != 0 || element.getAttribute(config.Name) == null || confMap.containsKey(config.Name)) continue;
                confMap.put(config.Name, config);
            }
            if (confMap.isEmpty()) continue;
            for (Config.AttributeConfig config : confMap.values()) {
                Attribute attr = element.getAttribute(config.Name);
                if (config.TypeName.length() != 0) {
                    Config.DataTypeConfig type_config = this.Config.getDataTypeConfiguration(config.TypeName);
                    if (type_config != null) {
                        attr.setValueType(type_config.ValueType);
                        if (type_config.ConversionType.length() == 0) {
                            attr.setConversionType(type_config.ValueType);
                        } else {
                            attr.setConversionType(type_config.ConversionType);
                        }
                    } else {
                        attr.setConversionType(config.TypeName);
                    }
                }
                if (config.Rename.length() != 0) {
                    attr.setName(config.Rename);
                }
                Iterator<Vector<Attribute>> subAttrs = element.getSubAttributes().iterator();
                while (subAttrs.hasNext()) {
                    for (Attribute aAttr : subAttrs.next()) {
                        if (!aAttr.getQName().equals(config.Name)) continue;
                        if (config.TypeName.length() != 0) {
                            Config.DataTypeConfig type_config = this.Config.getDataTypeConfiguration(config.TypeName);
                            if (type_config != null) {
                                aAttr.setValueType(type_config.ValueType);
                                if (type_config.ConversionType.length() == 0) {
                                    aAttr.setConversionType(type_config.ValueType);
                                } else {
                                    aAttr.setConversionType(type_config.ConversionType);
                                }
                            } else {
                                aAttr.setConversionType(config.TypeName);
                            }
                        }
                        if (config.Rename.length() == 0) continue;
                        aAttr.setName(config.Rename);
                    }
                }
            }
        }
        return true;
    }

    public HashMap<String, String> getNamespaces() {
        return this.Handler.getNamespaces();
    }
}

