/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import org.odftoolkit.odfdom.codegen.Context;

public class ExpressionParser {
    public static final String TOKEN_TRUE = "true";
    public static final String TOKEN_FALSE = "false";
    private StreamTokenizer Tokens;
    private Context Context;
    private static final String TOKEN_OR = "or";
    private static final String TOKEN_AND = "and";
    private static final String TOKEN_NOT = "not";

    private ExpressionParser(String expression, Context context) {
        this.Tokens = new StreamTokenizer(new StringReader(expression));
        this.Tokens.resetSyntax();
        this.Tokens.wordChars(97, 122);
        this.Tokens.wordChars(65, 90);
        this.Tokens.wordChars(48, 57);
        this.Tokens.wordChars(45, 45);
        this.Tokens.wordChars(46, 46);
        this.Tokens.wordChars(95, 95);
        this.Tokens.quoteChar(39);
        this.Tokens.quoteChar(34);
        this.Tokens.whitespaceChars(0, 32);
        this.Tokens.eolIsSignificant(false);
        this.Tokens.slashStarComments(false);
        this.Tokens.slashSlashComments(false);
        this.Context = context;
    }

    private String evaluateValueExpression(boolean skip) throws IOException {
        String value = null;
        if (this.Tokens.ttype == 40) {
            if (this.Tokens.nextToken() == 41) {
                throw new IOException("found empty ()");
            }
            value = this.evaluateExpression(skip);
            if (this.Tokens.ttype != 41) {
                throw new IOException("missing closing ')' for opening '('");
            }
            this.Tokens.nextToken();
        } else if (this.Tokens.ttype == 34 || this.Tokens.ttype == 39) {
            value = this.Tokens.sval;
            this.Tokens.nextToken();
        } else if (this.Tokens.ttype == -3) {
            if (this.Tokens.sval.equals(TOKEN_OR) || this.Tokens.sval.equals(TOKEN_AND)) {
                throw new IOException(new String("keyword '" + this.Tokens.sval + "' must follow a string expression"));
            }
            if (this.Tokens.sval.equals(TOKEN_TRUE) || this.Tokens.sval.equals(TOKEN_FALSE)) {
                value = this.Tokens.sval;
                this.Tokens.nextToken();
            } else {
                if (this.Tokens.sval.equals(TOKEN_NOT)) {
                    this.Tokens.nextToken();
                    return ExpressionParser.valueToBoolean(this.evaluateValueExpression(skip)) ? TOKEN_FALSE : TOKEN_TRUE;
                }
                String sval = this.Tokens.sval;
                if (this.Tokens.nextToken() == 40) {
                    value = this.evaluateFunction(sval, skip);
                } else if (!skip) {
                    value = this.Context.getVariable(sval);
                    if (value == null) {
                        throw new IOException(new String("unknwon identifier " + sval));
                    }
                } else {
                    value = "";
                }
            }
        }
        if (this.Tokens.ttype == 43) {
            if (this.Tokens.nextToken() == -1) {
                throw new IOException(new String("no expression following '+'"));
            }
            return value + this.evaluateValueExpression(skip);
        }
        return value;
    }

    private String evaluateSecondaryExpression(boolean skip) throws IOException {
        String value = this.evaluateValueExpression(skip);
        if (this.Tokens.ttype == 61) {
            this.Tokens.nextToken();
            String value2 = this.evaluateValueExpression(skip);
            return value.equals(value2) ? TOKEN_TRUE : TOKEN_FALSE;
        }
        if (this.Tokens.ttype == 33 && this.Tokens.nextToken() == 61) {
            this.Tokens.nextToken();
            String value2 = this.evaluateValueExpression(skip);
            return value.equals(value2) ? TOKEN_FALSE : TOKEN_TRUE;
        }
        return value;
    }

    private String evaluatePrimaryExpression(boolean skip) throws IOException {
        String value = this.evaluateSecondaryExpression(skip);
        while (this.Tokens.ttype == -3 && this.Tokens.sval.equals(TOKEN_OR)) {
            this.Tokens.nextToken();
            boolean op1 = ExpressionParser.valueToBoolean(value);
            String value2 = this.evaluatePrimaryExpression(skip || op1);
            value = op1 || ExpressionParser.valueToBoolean(value2) ? TOKEN_TRUE : TOKEN_FALSE;
        }
        return value;
    }

    private String evaluateExpression(boolean skip) throws IOException {
        String value = this.evaluatePrimaryExpression(skip);
        while (this.Tokens.ttype == -3 && this.Tokens.sval.equals(TOKEN_AND)) {
            this.Tokens.nextToken();
            boolean op1 = ExpressionParser.valueToBoolean(value);
            String value2 = this.evaluatePrimaryExpression(skip || !op1);
            value = op1 && ExpressionParser.valueToBoolean(value2) ? TOKEN_TRUE : TOKEN_FALSE;
        }
        return value;
    }

    private static boolean valueToBoolean(String value) {
        return value != null && value.length() != 0 && !value.equals(TOKEN_FALSE);
    }

    private String evaluate() throws IOException {
        String value;
        if (this.Tokens.nextToken() != -1) {
            value = this.evaluateExpression(false);
            if (this.Tokens.ttype != -1) {
                if (this.Tokens.ttype == -3) {
                    throw new IOException(new String("syntax error at word '" + this.Tokens.sval + "'"));
                }
                throw new IOException(new String("syntax error at token '" + (char)this.Tokens.ttype + "'"));
            }
        } else {
            value = "";
        }
        return value;
    }

    public static String evaluate(String expression, Context context) throws IOException {
        return new ExpressionParser(expression, context).evaluate();
    }

    public static boolean evaluateBoolean(String expression, Context context) throws IOException {
        return ExpressionParser.valueToBoolean(new ExpressionParser(expression, context).evaluate());
    }

    private String evaluateFunction(String func, boolean skip) throws IOException {
        Vector<String> params = new Vector<String>();
        while (this.Tokens.nextToken() != 41) {
            String p = this.evaluateExpression(skip);
            params.add(p);
            if (this.Tokens.ttype == 44) continue;
            break;
        }
        if (this.Tokens.ttype != 41) {
            throw new IOException(new String("missformed parameter sequence for function '" + func + "'"));
        }
        this.Tokens.nextToken();
        return this.Context.function(func, params);
    }
}

