/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen;

import java.util.Iterator;
import java.util.Vector;
import org.odftoolkit.odfdom.codegen.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element {
    private String Name;
    private String QName;
    private String StyleFamily;
    private Vector<Attribute> Attributes;
    private Vector<Element> SubElements;
    private Vector<Vector<Attribute>> SubAttributes;

    public Element(String name, String qName, String styleElement, Element refElement) {
        this.Name = name;
        this.QName = qName;
        this.StyleFamily = styleElement;
        this.Attributes = new Vector();
        this.SubElements = new Vector();
        this.SubAttributes = new Vector();
        if (refElement != null) {
            Iterator<Attribute> iter = refElement.Attributes.iterator();
            while (iter.hasNext()) {
                this.Attributes.add(iter.next());
            }
        }
    }

    public String getStyleFamily() {
        return this.StyleFamily;
    }

    public String getQName() {
        return this.QName;
    }

    public String getName() {
        return this.Name;
    }

    public void addAttribute(Attribute newAttr) {
        Attribute mergeAttr = this.getAttribute(newAttr.getQName());
        if (mergeAttr == null) {
            this.Attributes.add(newAttr);
        } else if (mergeAttr.getValueType().equals("enum") && newAttr.getValueType().equals("enum")) {
            Iterator<String> iter = newAttr.getValues();
            while (iter.hasNext()) {
                mergeAttr.addValue(iter.next());
            }
        } else if (!mergeAttr.getValueType().equals(newAttr.getValueType()) || !mergeAttr.getConversionType().equals(newAttr.getConversionType())) {
            mergeAttr.setValueType("String");
            mergeAttr.setConversionType("String");
            System.err.println("warning: merging attribute " + newAttr.getName() + ", reverting to type string");
        }
    }

    public Attribute getAttribute(String name) {
        for (int i = 0; i < this.Attributes.size(); ++i) {
            if (!this.Attributes.get(i).getQName().equals(name)) continue;
            return this.Attributes.get(i);
        }
        return null;
    }

    public void removeAttribute(String name) {
        for (int i = 0; i < this.Attributes.size(); ++i) {
            if (!this.Attributes.get(i).getQName().equals(name)) continue;
            this.Attributes.remove(i);
            break;
        }
    }

    public Iterator<Attribute> getAttributes() {
        return this.Attributes.iterator();
    }

    public void addSubElement(Element newSub) {
        this.SubElements.add(newSub);
    }

    public Element getSubElement(String name) {
        for (int i = 0; i < this.SubElements.size(); ++i) {
            if (!this.SubElements.get(i).getQName().equals(name)) continue;
            return this.SubElements.get(i);
        }
        return null;
    }

    public void removeSubElement(String name) {
        for (int i = 0; i < this.SubElements.size(); ++i) {
            if (!this.SubElements.get(i).getQName().equals(name)) continue;
            this.SubElements.remove(i);
            break;
        }
    }

    public Vector<Element> getSubElements() {
        return this.SubElements;
    }

    public Vector<Vector<Attribute>> getSubAttributes() {
        return this.SubAttributes;
    }

    public void addSubAttribute(Vector<Attribute> newAttrs) {
        this.SubAttributes.add(newAttrs);
    }
}

