/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.odftoolkit.odfdom.codegen.Attribute;
import org.odftoolkit.odfdom.codegen.Element;
import org.odftoolkit.odfdom.codegen.IFunctionSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private HashMap<String, Stack<String>> Environment = new HashMap();
    private Stack<Attribute> CurrentAttribute = new Stack();
    private Stack<Element> CurrentElement = new Stack();
    private Stack<PrintWriter> CurrentFile = new Stack();
    private IFunctionSupplier FunctionSupplier;
    private Vector<Attribute> CurrentAttributeGroup;

    public Context(IFunctionSupplier functionSupplier) {
        this.FunctionSupplier = functionSupplier;
        this.CurrentAttributeGroup = new Vector();
    }

    public String getVariable(String name) {
        Stack<String> stack = this.Environment.get(name);
        if (stack != null && !stack.isEmpty()) {
            return (String)stack.lastElement();
        }
        return null;
    }

    public Attribute getCurrentAttribute() {
        if (!this.CurrentAttribute.isEmpty()) {
            return (Attribute)this.CurrentAttribute.lastElement();
        }
        return null;
    }

    public Element getCurrentElement() {
        if (!this.CurrentElement.isEmpty()) {
            return (Element)this.CurrentElement.lastElement();
        }
        return null;
    }

    public PrintWriter getCurrentFile() {
        if (!this.CurrentFile.isEmpty()) {
            return (PrintWriter)this.CurrentFile.lastElement();
        }
        return null;
    }

    public Vector<Attribute> getCurrentAttributeGroup() {
        return this.CurrentAttributeGroup;
    }

    public void setCurrentAttributeGroup(Vector<Attribute> groupAttr) {
        this.CurrentAttributeGroup = groupAttr;
    }

    public void setVariable(String name, String value) {
        Stack<String> stack = this.Environment.get(name);
        if (stack == null) {
            stack = new Stack();
            this.Environment.put(name, stack);
        }
        if (!stack.isEmpty()) {
            stack.pop();
        }
        stack.push(value);
    }

    public void pushVariable(String name, String value) {
        Stack<String> stack = this.Environment.get(name);
        if (stack == null) {
            stack = new Stack();
            this.Environment.put(name, stack);
        }
        stack.push(value);
    }

    public void popVariable(String name) {
        Stack<String> stack = this.Environment.get(name);
        if (stack != null) {
            stack.pop();
        }
    }

    public void pushAttribute(Attribute attr) {
        this.CurrentAttribute.push(attr);
        this.pushVariable("attributename", attr.getName());
        this.pushVariable("attributeqname", attr.getQName());
        this.pushVariable("valuetype", attr.getValueType());
        this.pushVariable("conversiontype", attr.getConversionType());
        this.pushVariable("defaultvalue", attr.getDefaultValue());
        this.pushVariable("optionalattribute", attr.isOptional() ? "true" : "false");
    }

    public void popAttribute() {
        this.CurrentAttribute.pop();
        this.popVariable("attributename");
        this.popVariable("attributeqname");
        this.popVariable("valuetype");
        this.popVariable("conversiontype");
        this.popVariable("defaultvalue");
    }

    public void pushElement(Element element) {
        this.CurrentElement.push(element);
        this.pushVariable("elementname", element.getName());
        this.pushVariable("elementqname", element.getQName());
        this.pushVariable("elementstylefamily", element.getStyleFamily());
    }

    public void popElement() {
        this.popVariable("elementname");
        this.popVariable("elementqname");
        this.popVariable("elementstylefamily");
        this.CurrentElement.pop();
    }

    public void pushFile(PrintWriter file) {
        this.CurrentFile.push(file);
    }

    public void popFile() {
        this.CurrentFile.pop();
    }

    String function(String func, Vector<String> params) throws IOException {
        return this.FunctionSupplier.function(func, params);
    }
}

