/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config
extends DefaultHandler {
    private HashMap<String, ElementConfig> ElementConfigs = new HashMap();
    private HashMap<String, DataTypeConfig> DataTypes = new HashMap();
    private Vector<AttributeConfig> AttributeConfigs = new Vector();

    private Config() {
    }

    public static Config parse(String url) throws IOException, SAXException {
        Config xThis = new Config();
        FileInputStream aContent = new FileInputStream(url);
        InputSource aSource = new InputSource(aContent);
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setContentHandler(xThis);
        xr.setErrorHandler(xThis);
        xr.parse(aSource);
        return xThis;
    }

    Iterator<ElementConfig> getElementConfigurations() {
        return this.ElementConfigs.values().iterator();
    }

    public ElementConfig getConfigForElement(String qName) {
        return this.ElementConfigs.get(qName);
    }

    Iterator<AttributeConfig> getAttributeConfigurations() {
        return this.AttributeConfigs.iterator();
    }

    public DataTypeConfig getDataTypeConfiguration(String name) {
        return this.DataTypes.get(name);
    }

    private static String forceString(String str) {
        if (str != null) {
            return str;
        }
        return new String();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("element")) {
            ElementConfig config = new ElementConfig();
            config.Name = Config.forceString(attributes.getValue("name"));
            config.ReName = Config.forceString(attributes.getValue("rename"));
            config.Base = Config.forceString(attributes.getValue("base"));
            config.StyleFamily = Config.forceString(attributes.getValue("family"));
            this.ElementConfigs.put(config.Name, config);
        } else if (localName.equals("data") || localName.equals("data-type")) {
            DataTypeConfig config = new DataTypeConfig();
            config.Name = Config.forceString(attributes.getValue("name"));
            config.ValueType = Config.forceString(attributes.getValue("value-type"));
            config.ConversionType = Config.forceString(attributes.getValue("conversion-type"));
            this.DataTypes.put(config.Name, config);
        } else if (localName.equals("attribute")) {
            AttributeConfig config = new AttributeConfig();
            config.Name = Config.forceString(attributes.getValue("name"));
            config.TypeName = Config.forceString(attributes.getValue("type-name"));
            config.Element = Config.forceString(attributes.getValue("element"));
            config.Rename = Config.forceString(attributes.getValue("rename"));
            this.AttributeConfigs.add(config);
        }
    }

    public class DataTypeConfig {
        public String Name;
        public String ValueType;
        public String ConversionType;
    }

    public class AttributeConfig {
        public String Name;
        public String Element;
        public String TypeName;
        public String Rename;
    }

    public class ElementConfig {
        public String Name;
        public String ReName;
        public String Base;
        public String StyleFamily;
    }
}

