/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class CodeTemplate
extends DefaultHandler {
    private TemplateNode rootNode;
    private Stack<TemplateNode> ElementStack = new Stack();
    private HashMap<String, TemplateNode> Defines = new HashMap();
    private Locator Locator;

    public void setDocumentLocator(Locator locator) {
        this.Locator = locator;
    }

    public TemplateNode getRootNode() {
        return this.rootNode;
    }

    public TemplateNode getDefine(String name) {
        return this.Defines.get(name);
    }

    public static CodeTemplate parse(String path) throws IOException, SAXException {
        CodeTemplate xThis = new CodeTemplate();
        try {
            FileInputStream aContent = new FileInputStream(path);
            InputSource aSource = new InputSource(aContent);
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(xThis);
            xr.setErrorHandler(xThis);
            xr.parse(aSource);
            return xThis;
        }
        catch (SAXException ex) {
            if (xThis.Locator == null) {
                throw ex;
            }
            throw new SAXException(new String(ex.getMessage() + " at [" + xThis.Locator.getLineNumber() + ":" + xThis.Locator.getColumnNumber() + "]"));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.ElementStack.isEmpty()) {
            TemplateNode node = (TemplateNode)this.ElementStack.lastElement();
            node.Characters = node.Characters + new String(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.ElementStack.empty()) {
            this.ElementStack.pop();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        TemplateNode node = new TemplateNode(localName, attributes);
        TemplateNode parent = null;
        if (!this.ElementStack.empty()) {
            parent = (TemplateNode)this.ElementStack.lastElement();
        }
        if (node.getLocalName().equals("define")) {
            String name = node.getAttribute("name");
            if (name.length() == 0) {
                System.err.println("warning: <define> without attribute 'name'!");
            }
            this.Defines.put(name, node);
        } else {
            if (parent != null) {
                parent.addChild(node);
            }
            if (this.rootNode == null) {
                this.rootNode = node;
            }
        }
        this.ElementStack.push(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TemplateNode {
        public static final String TEMPLATE_ELEMENT = "template";
        public static final String FOREACH_ELEMENT = "foreach";
        public static final String FILE_ELEMENT = "file";
        public static final String CODE_ELEMENT = "code";
        public static final String IF_ELEMENT = "if";
        public static final String ELSE_ELEMENT = "else";
        public static final String SET_ELEMENT = "set";
        public static final String DEFINE_ELEMENT = "define";
        public static final String REF_ELEMENT = "ref";
        public static final String SELECT_ELEMENT = "select";
        public static final String TYPE_ATTRIBUTE = "type";
        public static final String PATH_ATTRIBUTE = "path";
        public static final String NAME_ATTRIBUTE = "name";
        public static final String VALUE_ATTRIBUTE = "value";
        public static final String TEST_ATTRIBUTE = "test";
        public static final String EXTENSION_ATTRIBUTE = "extensions";
        public static final String CHILDREN_ELEMENT = "children";
        public static final String SUBATTRIBUTE_ELEMENT = "subattribute";
        public static final String GROUP_ELEMENT = "group";
        public HashMap<String, String> Attributes;
        public String LocalName;
        public String Characters;
        public Vector<TemplateNode> Children;

        public TemplateNode(String localName, Attributes attr) {
            this.LocalName = localName;
            this.Characters = new String();
            this.Children = new Vector();
            this.Attributes = new HashMap();
            for (int i = 0; i < attr.getLength(); ++i) {
                this.Attributes.put(attr.getLocalName(i), attr.getValue(i));
            }
        }

        public String getLocalName() {
            return this.LocalName;
        }

        public String getAttribute(String name) {
            String ret = this.Attributes.get(name);
            if (ret == null) {
                ret = new String();
            }
            return ret;
        }

        public void addChild(TemplateNode node) {
            this.Children.add(node);
        }

        public Iterator<TemplateNode> getChildren() {
            return this.Children.iterator();
        }

        Iterator<Map.Entry<String, String>> getAttributes() {
            return this.Attributes.entrySet().iterator();
        }
    }
}

