/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.odftoolkit.odfdom.codegen.Attribute;
import org.odftoolkit.odfdom.codegen.CodeTemplate;
import org.odftoolkit.odfdom.codegen.Config;
import org.odftoolkit.odfdom.codegen.Context;
import org.odftoolkit.odfdom.codegen.Element;
import org.odftoolkit.odfdom.codegen.ExpressionParser;
import org.odftoolkit.odfdom.codegen.IFunctionSupplier;
import org.odftoolkit.odfdom.codegen.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGen
implements IFunctionSupplier {
    private Context context;
    private Config config;
    private CodeTemplate template;
    private String targetPath;
    private Schema schema;

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("usage: <schema.rng> <config.xml> <template.xml> <destination folder>");
        } else {
            String schemaPath = args[0];
            String configPath = args[1];
            String templatePath = args[2];
            String destPath = args[3];
            CodeGen xThis = new CodeGen(destPath);
            if (xThis.parseConfig(configPath) && xThis.parseSchema(schemaPath) && xThis.parseTemplate(templatePath) && xThis.executeTemplate(xThis.template)) {
                System.exit(0);
            }
        }
        System.exit(1);
    }

    public CodeGen(String targetPath) {
        this.targetPath = targetPath;
        this.context = new Context(this);
    }

    public boolean parseConfig(String path) {
        try {
            this.config = Config.parse(path);
            return true;
        }
        catch (Exception ex) {
            System.err.println("error: could not load " + path + ", " + ex.toString());
            return false;
        }
    }

    public boolean parseSchema(String path) {
        this.schema = new Schema(this.config);
        return this.schema.parseSchema(path);
    }

    public boolean parseTemplate(String path) {
        try {
            this.template = CodeTemplate.parse(path);
            return true;
        }
        catch (Exception ex) {
            System.err.println("error: could not load configuration, " + ex.toString());
            return false;
        }
    }

    public boolean executeTemplate(CodeTemplate template) {
        try {
            return this.executeTemplateNode(template.getRootNode());
        }
        catch (IOException ex) {
            System.err.println("error: " + ex.getMessage());
            return false;
        }
    }

    private boolean executeTemplateNode(CodeTemplate.TemplateNode node) throws IOException {
        if (node.getLocalName().equals("template")) {
            return this.executeTemplateChildNodes(node);
        }
        if (node.getLocalName().equals("file")) {
            if (!this.executeFileNode(node)) {
                return false;
            }
        } else if (node.getLocalName().equals("code")) {
            if (!this.executeCodeNode(node)) {
                return false;
            }
        } else if (node.getLocalName().equals("foreach")) {
            if (!this.executeForeachNode(node)) {
                return false;
            }
        } else if (node.getLocalName().equals("select")) {
            if (!this.executeSelectNode(node)) {
                return false;
            }
        } else if (node.getLocalName().equals("if")) {
            String test = node.getAttribute("test");
            if (test == null) {
                throw new IOException(new String("if element needs an attribute 'test'"));
            }
            if (ExpressionParser.evaluateBoolean(test, this.context) ? !this.executeTemplateChildNodes(node) : !this.executeTemplateElseNode(node)) {
                return false;
            }
        } else if (!node.getLocalName().equals("else")) {
            if (node.getLocalName().equals("set")) {
                Iterator<Map.Entry<String, String>> iter = node.getAttributes();
                while (iter.hasNext()) {
                    Map.Entry<String, String> attr = iter.next();
                    this.context.setVariable(attr.getKey(), this.decodeTemplateString(attr.getValue()));
                }
            } else {
                if (node.getLocalName().equals("ref")) {
                    String name = node.getAttribute("name");
                    if (name == null || name.length() == 0) {
                        System.err.println("error: <ref> must have attribute 'name'!");
                        return false;
                    }
                    CodeTemplate.TemplateNode define = this.template.getDefine(name);
                    if (define == null) {
                        System.err.println("error: <ref> uses unknown define '" + name + "'!");
                        return false;
                    }
                    return this.executeTemplateChildNodes(define);
                }
                if (node.getLocalName().equals("children")) {
                    if (!this.executeChildrenNode(node)) {
                        return false;
                    }
                } else if (node.getLocalName().equals("subattribute")) {
                    if (!this.executeSubAttributeNode(node)) {
                        return false;
                    }
                } else if (node.getLocalName().equals("group")) {
                    if (!this.executeAttributeGroupNode(node)) {
                        return false;
                    }
                } else {
                    System.err.println("error: template uses unknown element <" + node.getLocalName() + ">!");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean executeTemplateElseNode(CodeTemplate.TemplateNode parent) throws IOException {
        Iterator<CodeTemplate.TemplateNode> iter = parent.getChildren();
        while (iter.hasNext()) {
            CodeTemplate.TemplateNode node = iter.next();
            if (!node.getLocalName().equals("else")) continue;
            return this.executeTemplateChildNodes(node);
        }
        return true;
    }

    private boolean executeTemplateChildNodes(CodeTemplate.TemplateNode parent) throws IOException {
        Iterator<CodeTemplate.TemplateNode> iter = parent.getChildren();
        while (iter.hasNext()) {
            if (this.executeTemplateNode(iter.next())) continue;
            return false;
        }
        return true;
    }

    private boolean executeChildrenNode(CodeTemplate.TemplateNode node) throws IOException {
        String type = node.getAttribute("type");
        String sep = node.getAttribute("seperator");
        if (sep != null && sep.length() == 0 || this.context.getCurrentFile() == null) {
            sep = null;
        }
        boolean first = true;
        if (type.equals("element")) {
            Element element = this.context.getCurrentElement();
            if (element == null) {
                System.err.println("error: foreach attribute needs a current element!");
                return false;
            }
            if (element.getSubElements().size() > 0) {
                Iterator<Element> iter = element.getSubElements().iterator();
                while (iter.hasNext()) {
                    first = this.printSeperator(sep, first);
                    if (this.selectElement(node, iter.next(), false)) continue;
                    return false;
                }
            }
        } else {
            System.err.println("error: unknown foreach type " + type);
            return false;
        }
        return true;
    }

    private boolean executeSubAttributeNode(CodeTemplate.TemplateNode node) throws IOException {
        Element element = this.context.getCurrentElement();
        if (element == null) {
            System.err.println("error: foreach attribute needs a current element!");
            return false;
        }
        if (element.getSubAttributes().size() > 0) {
            for (Vector<Attribute> subAtt : element.getSubAttributes()) {
                if (this.selectSubAttribute(node, element, subAtt)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean executeAttributeGroupNode(CodeTemplate.TemplateNode node) throws IOException {
        Element element = this.context.getCurrentElement();
        Vector<Attribute> group = this.context.getCurrentAttributeGroup();
        if (element == null) {
            System.err.println("error: foreach attribute needs a current element!");
            return false;
        }
        if (group.size() > 0) {
            Iterator<Attribute> iter = group.iterator();
            while (iter.hasNext()) {
                if (this.selectAttribute(node, iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean selectSubAttribute(CodeTemplate.TemplateNode node, Element element, Vector<Attribute> attributeGroup) throws IOException {
        this.context.pushElement(element);
        this.context.setCurrentAttributeGroup(attributeGroup);
        boolean ret = this.executeTemplateChildNodes(node);
        this.context.popElement();
        return ret;
    }

    private boolean printSeperator(String sep, boolean first) {
        PrintWriter file;
        if (sep != null && !first && (file = this.context.getCurrentFile()) != null) {
            file.print(sep);
        }
        return false;
    }

    private boolean executeForeachNode(CodeTemplate.TemplateNode node) throws IOException {
        String type = node.getAttribute("type");
        String sep = node.getAttribute("seperator");
        if (sep != null && sep.length() == 0 || this.context.getCurrentFile() == null) {
            sep = null;
        }
        boolean first = true;
        if (type.equals("element") || type.equals("baseelement")) {
            Iterator<Element> iter;
            boolean baseElements = type.equals("baseelement");
            Iterator<Element> iterator = iter = baseElements ? this.schema.getBaseElements() : this.schema.getElements();
            while (iter.hasNext()) {
                first = this.printSeperator(sep, first);
                if (this.selectElement(node, iter.next(), baseElements)) continue;
                return false;
            }
        } else if (type.equals("attribute")) {
            Element element = this.context.getCurrentElement();
            if (element == null) {
                System.err.println("error: foreach attribute needs a current element!");
                return false;
            }
            Iterator<Attribute> iter = element.getAttributes();
            while (iter.hasNext()) {
                first = this.printSeperator(sep, first);
                if (this.selectAttribute(node, iter.next())) continue;
                return false;
            }
        } else if (type.equals("value")) {
            Attribute attr = this.context.getCurrentAttribute();
            if (attr == null) {
                System.err.println("error: foreach values needs a current attribute!");
                return false;
            }
            Iterator<String> iter = attr.getValues();
            while (iter.hasNext()) {
                first = this.printSeperator(sep, first);
                this.context.pushVariable("value", iter.next());
                boolean ret = this.executeTemplateChildNodes(node);
                this.context.popVariable("value");
                if (ret) continue;
                return false;
            }
        } else if (type.equals("namespace")) {
            HashMap<String, String> namespaces = this.schema.getNamespaces();
            Iterator<Map.Entry<String, String>> iter = namespaces.entrySet().iterator();
            while (iter.hasNext()) {
                first = this.printSeperator(sep, first);
                Map.Entry<String, String> entry = iter.next();
                this.context.pushVariable("namespaceprefix", entry.getKey());
                this.context.pushVariable("namespaceuri", entry.getValue());
                boolean ret = this.executeTemplateChildNodes(node);
                this.context.popVariable("namespaceprefix");
                this.context.popVariable("namespaceuri");
                if (ret) continue;
                return false;
            }
        } else {
            System.err.println("error: unknown foreach type " + type);
            return false;
        }
        return true;
    }

    private boolean executeSelectNode(CodeTemplate.TemplateNode node) throws IOException {
        String type = node.getAttribute("type");
        String name = this.decodeTemplateString(node.getAttribute("name"));
        if (type.equals("attribute")) {
            Element element = this.context.getCurrentElement();
            if (element == null) {
                System.err.println("error: select attribute needs a current element!");
                return false;
            }
            Attribute attr = element.getAttribute(name);
            if (attr == null) {
                System.err.println("error: selected attribute \"" + name + "\" not found inside current element!");
                return false;
            }
            return this.selectAttribute(node, attr);
        }
        if (type.equals("element") || type.equals("baseelement")) {
            boolean baseElement = type.equals("baseelement");
            Element element = this.schema.getElement(name, baseElement);
            if (element == null) {
                System.err.println("error: selected element \"" + name + "\" not found in schema!");
                return false;
            }
            return this.selectElement(node, element, baseElement);
        }
        System.err.println("error: unknwon type \"" + type + "\" for select!");
        return false;
    }

    public boolean selectElement(CodeTemplate.TemplateNode node, Element element, boolean baseElement) throws IOException {
        this.context.pushElement(element);
        String baseName = new String();
        Config.ElementConfig ec = this.config.getConfigForElement(element.getQName());
        if (ec != null && ec.Base != null && ec.Base.length() != 0) {
            baseName = ec.Base.indexOf(58) == -1 ? ec.Base : this.schema.getBaseElement(ec.Base).getQName();
        }
        this.context.pushVariable("elementbasename", baseName);
        boolean ret = this.executeTemplateChildNodes(node);
        this.context.popVariable("elementbasename");
        this.context.popElement();
        return ret;
    }

    public boolean selectAttribute(CodeTemplate.TemplateNode node, Attribute attr) throws IOException {
        this.context.pushAttribute(attr);
        boolean ret = this.executeTemplateChildNodes(node);
        this.context.popAttribute();
        return ret;
    }

    private boolean executeCodeNode(CodeTemplate.TemplateNode node) throws IOException {
        PrintWriter file = this.context.getCurrentFile();
        if (file != null) {
            file.print(this.decodeTemplateString(node.Characters));
            return true;
        }
        System.out.println("error: a <code> element can only work inside a <file> element!");
        return false;
    }

    private boolean executeFileNode(CodeTemplate.TemplateNode fileNode) throws IOException {
        String path = this.getPath(this.decodeTemplateString(fileNode.getAttribute("path")));
        String name = this.decodeTemplateString(fileNode.getAttribute("name"));
        String ext = this.decodeTemplateString(fileNode.getAttribute("extensions"));
        PrintWriter file = this.createFileWriter(path + name + "." + ext);
        if (file == null) {
            return false;
        }
        this.context.pushFile(file);
        this.executeTemplateChildNodes(fileNode);
        this.context.popFile();
        file.close();
        return true;
    }

    private String getPath(String subpath) {
        StringBuffer out = new StringBuffer(this.targetPath);
        if (out.charAt(out.length() - 1) != File.separatorChar) {
            out.append(File.separatorChar);
        }
        out.append(subpath.replace('.', File.separatorChar));
        if (out.charAt(out.length() - 1) != File.separatorChar) {
            out.append(File.separatorChar);
        }
        if (File.separatorChar != '/') {
            return out.toString().replace('/', File.separatorChar);
        }
        return out.toString();
    }

    private String evaluateExpression(String var) throws IOException {
        return ExpressionParser.evaluate(var, this.context);
    }

    @Override
    public String function(String func, Vector<String> params) throws IOException {
        int i = -1;
        if (func.equals("toupper")) {
            i = 1;
            if (params.size() == i) {
                return params.get(0).toUpperCase();
            }
        } else if (func.equals("tolower")) {
            i = 1;
            if (params.size() == i) {
                return params.get(0).toLowerCase();
            }
        } else if (func.equals("prefix")) {
            i = 1;
            if (params.size() == i) {
                String p = params.get(0);
                int pos = p.lastIndexOf(58);
                if (pos == -1) {
                    pos = p.lastIndexOf(46);
                }
                if (pos != -1) {
                    return p.substring(0, pos);
                }
                return new String();
            }
        } else if (func.equals("local_name")) {
            i = 1;
            if (params.size() == i) {
                String p = params.get(0);
                int pos = p.lastIndexOf(58);
                if (pos == -1) {
                    pos = p.lastIndexOf(46);
                }
                if (pos != -1) {
                    return p.substring(pos + 1);
                }
                return p;
            }
        } else if (func.equals("substring-before")) {
            i = 2;
            if (params.size() == i) {
                int pos = params.get(0).indexOf(params.get(1));
                if (pos == -1) {
                    return params.get(0);
                }
                if (pos > 0) {
                    return params.get(0).substring(0, pos);
                }
                return new String();
            }
        } else if (func.equals("substring-after")) {
            i = 2;
            if (params.size() == i) {
                int pos = params.get(0).indexOf(params.get(1));
                if (pos == -1) {
                    return params.get(0);
                }
                return params.get(0).substring(pos + 1);
            }
        } else if (func.equals("identifier")) {
            i = 1;
            if (params.size() == i) {
                return this.decodeIdentifier(params.get(0));
            }
        } else if (func.equals("endswith")) {
            i = 2;
            if (params.size() == i) {
                if (params.get(0).endsWith(params.get(1))) {
                    return "true";
                }
                return "false";
            }
        } else if (func.equals("startswith")) {
            i = 2;
            if (params.size() == i) {
                if (params.get(0).startsWith(params.get(1))) {
                    return "true";
                }
                return "false";
            }
        } else if (func.equals("replace")) {
            i = 3;
            if (params.size() == i) {
                return params.get(2).replaceAll(params.get(0), params.get(1));
            }
        } else if (func.equals("contains")) {
            i = 3;
            if (params.size() == i) {
                StringTokenizer tokens = new StringTokenizer(params.get(0), params.get(2));
                while (tokens.hasMoreTokens()) {
                    if (!tokens.nextToken().equals(params.get(1))) continue;
                    return "true";
                }
                return "false";
            }
        }
        if (i == -1) {
            throw new IOException(new String("unknown function '" + func + "'!"));
        }
        throw new IOException(new String("function '" + func + "' expects " + i + "arguments"));
    }

    private String decodeTemplateString(String in) throws IOException {
        StringBuffer out = new StringBuffer();
        int left = in.length();
        int last = 0;
        int skip = 0;
        String replace = null;
        int i = 0;
        while (left > 0) {
            block17: {
                block0 : switch (in.charAt(i)) {
                    case '%': {
                        if (left <= 1) break;
                        switch (in.charAt(i + 1)) {
                            case '{': {
                                int open = 1;
                                for (skip = i + 2; skip < in.length() && open > 0; ++skip) {
                                    if (in.charAt(skip) == '{') {
                                        ++open;
                                        continue;
                                    }
                                    if (in.charAt(skip) == '}') {
                                        --open;
                                        continue;
                                    }
                                    if (in.charAt(skip) != '\"') continue;
                                    ++skip;
                                    while (skip < in.length() && in.charAt(skip) != '\"') {
                                        if (in.charAt(skip) == '\\' && skip + 1 < in.length() && in.charAt(skip + 1) == '\"') {
                                            ++skip;
                                        }
                                        ++skip;
                                    }
                                }
                                if (open == 0) {
                                    String tmp = in.substring(i + 2, skip - 1);
                                    replace = this.evaluateExpression(tmp);
                                    break block0;
                                }
                                break block17;
                            }
                            case '%': {
                                replace = "%";
                                skip = i + 1;
                            }
                        }
                    }
                }
            }
            if (replace != null) {
                if (i > last) {
                    out.append(in.substring(last, i));
                }
                out.append(replace);
                left -= skip - i;
                last = i = skip;
                replace = null;
                continue;
            }
            ++i;
            --left;
        }
        if (i > last) {
            out.append(in.substring(last, i));
        }
        return out.toString();
    }

    private PrintWriter createFileWriter(String path) {
        System.out.println("generating " + path);
        try {
            File file = new File(path);
            if (this.createRecursiveDir(file.getParentFile())) {
                if (file.isDirectory()) {
                    return null;
                }
                if (file.isFile()) {
                    file.delete();
                }
                return new PrintWriter(file);
            }
        }
        catch (FileNotFoundException ex) {
            System.err.println("error: could not create file " + path + ", " + ex.toString());
        }
        return null;
    }

    private boolean createRecursiveDir(File file) {
        if (file == null || file.isFile()) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        File parent = file.getParentFile();
        if (parent != null && !this.createRecursiveDir(parent)) {
            return false;
        }
        return file.mkdir();
    }

    private String decodeIdentifier(String odfname) {
        StringBuffer name = new StringBuffer();
        boolean bFirst = true;
        for (int i = odfname.indexOf(58) + 1; i < odfname.length(); ++i) {
            if (odfname.charAt(i) == '-') {
                bFirst = true;
                continue;
            }
            Character c = Character.valueOf(odfname.charAt(i));
            switch (c.charValue()) {
                case '.': {
                    c = Character.valueOf('_');
                }
            }
            if (bFirst) {
                name.append(Character.toUpperCase(c.charValue()));
                bFirst = false;
                continue;
            }
            name.append(c);
        }
        if (name.length() > 0 && Character.isDigit(name.charAt(0))) {
            name.insert(0, "_");
        }
        return name.toString();
    }

    public void setTemplate(CodeTemplate template) {
        this.template = template;
    }

    public CodeTemplate getTemplate() {
        return this.template;
    }
}

