/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.codegen;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute {
    private String Name;
    private String QName;
    private String ValueType;
    private String ConversionType;
    private String DefaultValue;
    private HashSet<String> Values;
    private boolean Optional;

    Attribute(String qName, String valueType, String conversionType, Iterator<String> values, boolean optional, String defaultValue) {
        this.Name = qName;
        this.ValueType = valueType;
        this.ConversionType = conversionType;
        this.QName = qName;
        this.DefaultValue = defaultValue;
        if (values != null) {
            while (values.hasNext()) {
                this.addValue(values.next());
            }
        }
        this.Optional = optional;
    }

    public String getDefaultValue() {
        return this.DefaultValue;
    }

    public boolean isOptional() {
        return this.Optional;
    }

    public String getName() {
        return this.Name;
    }

    public void addValue(String value) {
        if (this.Values == null) {
            this.Values = new HashSet();
        }
        if (!this.Values.contains(value)) {
            this.Values.add(value);
        }
    }

    public String getValueType() {
        return this.ValueType;
    }

    public void setValueType(String type) {
        if (this.ValueType.equals(this.ConversionType)) {
            this.ConversionType = type;
        }
        this.ValueType = type;
    }

    public String getConversionType() {
        return this.ConversionType;
    }

    public void setConversionType(String type) {
        this.ConversionType = type;
    }

    public Iterator<String> getValues() {
        if (this.Values != null) {
            return this.Values.iterator();
        }
        Vector temp = new Vector();
        return temp.iterator();
    }

    public String getQName() {
        return this.QName;
    }

    public int getValueCount() {
        return this.Values == null ? 0 : this.Values.size();
    }

    public boolean hasValue(String value) {
        return this.Values != null && this.Values.contains(value);
    }

    void setName(String name) {
        this.Name = name;
    }
}

