/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.util;

import java.util.Locale;

public class OdfUnitConverter {
    public static final double DPI = 127.0;
    public static final double CENTIMETER_IN_MM = 10.0;
    public static final double INCH_IN_MM = 25.4;
    public static final double DIDOT_POINT_IN_MM = 0.376065;
    public static final double PICA_IN_MM = 4.2333333;
    public static final double POINT_IN_MM = 0.3527778;
    public static final double TWIP_IN_MM = 0.017636684;
    public static final double PIXEL_IN_MM = 0.19999999999999998;

    public static String mapUnitToCm(String length) {
        double roundingFactor = 10000.0;
        double unit = 0.0;
        String cmValue = null;
        try {
            if (length.contains("mm")) {
                Double mm = Double.valueOf(length.substring(0, length.indexOf("mm")));
                unit = (double)Math.round(roundingFactor * mm / 10.0) / roundingFactor;
            } else if (length.contains("cm")) {
                unit = Double.valueOf(length.substring(0, length.indexOf("cm")));
            } else if (length.contains("inch")) {
                Double inch = Double.valueOf(length.substring(0, length.indexOf("inch")));
                unit = (double)Math.round(roundingFactor * inch / 10.0 * 25.4) / roundingFactor;
            } else if (length.contains("in")) {
                Double in = Double.valueOf(length.substring(0, length.indexOf("in")));
                unit = (double)Math.round(roundingFactor * in / 10.0 * 25.4) / roundingFactor;
            } else if (length.contains("pt")) {
                Double pt = Double.valueOf(length.substring(0, length.indexOf("pt")));
                unit = (double)Math.round(roundingFactor * pt / 10.0 * 0.3527778) / roundingFactor;
            } else if (length.contains("dpt")) {
                Double dpt = Double.valueOf(length.substring(0, length.indexOf("dpt")));
                unit = (double)Math.round(roundingFactor * dpt / 10.0 * 0.376065) / roundingFactor;
            } else if (length.contains("pica")) {
                Double pica = Double.valueOf(length.substring(0, length.indexOf("pica")));
                unit = (double)Math.round(roundingFactor * pica / 10.0 * 4.2333333) / roundingFactor;
            } else if (length.contains("twip")) {
                Double twip = Double.valueOf(length.substring(0, length.indexOf("twip")));
                unit = (double)Math.round(roundingFactor * twip / 10.0 * 0.017636684) / roundingFactor;
            } else if (length.contains("px")) {
                Double pixel = Double.valueOf(length.substring(0, length.indexOf("px")));
                unit = (double)Math.round(roundingFactor * pixel / 10.0 * 0.19999999999999998) / roundingFactor;
            } else {
                unit = (double)Math.round(roundingFactor * (Double.valueOf(length) / 10.0 * 0.19999999999999998)) / roundingFactor;
            }
            cmValue = String.valueOf(unit) + "cm";
        }
        catch (NumberFormatException e) {
            System.err.println("Exception" + e);
            cmValue = length;
        }
        return cmValue;
    }

    public static String mapColorFromRgbToHex(String colorValue) {
        if (colorValue.startsWith("rgb")) {
            colorValue = colorValue.replace("rgb", "");
            colorValue = colorValue.replace("(", "");
            String[] rgbValues = (colorValue = colorValue.replace(")", "")).split(",");
            if (rgbValues.length == 3) {
                int r = Integer.parseInt(rgbValues[0].trim());
                int g = Integer.parseInt(rgbValues[1].trim());
                int b = Integer.parseInt(rgbValues[2].trim());
                String rs = Integer.toHexString(r);
                String gs = Integer.toHexString(g);
                String bs = Integer.toHexString(b);
                String hexColor = "#";
                if (r < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + rs;
                if (g < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + gs;
                if (b < 16) {
                    hexColor = hexColor + "0";
                }
                hexColor = hexColor + bs;
                return hexColor;
            }
        }
        return colorValue;
    }

    private static boolean isMeasureNumChar(char c) {
        return c >= '0' && c <= '9' || c == '-' || c == '.';
    }

    public static final int getMeasureValue(String measure) {
        int spaceEnd;
        int valEnd;
        if (measure == null) {
            return 0;
        }
        for (valEnd = 0; valEnd < measure.length() && OdfUnitConverter.isMeasureNumChar(measure.charAt(valEnd)); ++valEnd) {
        }
        String valStr = measure.substring(0, valEnd);
        double value = Double.parseDouble(valStr);
        for (spaceEnd = valEnd; spaceEnd < measure.length() && measure.charAt(spaceEnd) == ' '; ++spaceEnd) {
        }
        String unitStr = measure.substring(spaceEnd).toLowerCase(Locale.ENGLISH);
        double factor = 0.0;
        if (unitStr.equals("cm")) {
            factor = 1000.0;
        } else if (unitStr.equals("mm")) {
            factor = 100.0;
        } else if (unitStr.equals("in")) {
            factor = 2540.0;
        } else if (unitStr.equals("pt")) {
            factor = 35.27777777777778;
        }
        return (int)(value * factor + 0.5);
    }

    public static final String getMeasureString(int measure) {
        return new Double((double)measure / 1000.0).toString() + "cm";
    }
}

