/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.type;

import org.odftoolkit.odfdom.dom.type.OdfMeasure;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import org.odftoolkit.odfdom.dom.util.OdfUnitConverter;

public class OdfLengthOrPercent {
    private Object mValue;
    private String lengtheOrPercent;

    public OdfLengthOrPercent() {
        this.mValue = null;
    }

    public OdfLengthOrPercent(OdfLengthOrPercent val) {
        if (val == null) {
            throw new IllegalArgumentException("Illegal length or percent value");
        }
        this.lengtheOrPercent = val.isPercent() ? String.valueOf(val.getPercent()) + "%" : OdfUnitConverter.getMeasureString(val.getLength());
    }

    public void setLength(int length) {
        this.mValue = new Integer(length);
    }

    public void setPercent(double percent) {
        this.mValue = new Double(percent);
    }

    public boolean isPercent() {
        return this.mValue != null && this.mValue instanceof Double;
    }

    public int getLength() {
        if (this.isPercent()) {
            throw new IllegalArgumentException("I do not have a length value");
        }
        if (this.mValue != null) {
            return (Integer)this.mValue;
        }
        return 0;
    }

    public double getPercent() {
        if (this.isPercent()) {
            return (Double)this.mValue;
        }
        throw new IllegalArgumentException("I do not have a percent value");
    }

    public String toString() {
        return this.lengtheOrPercent;
    }

    public static OdfLengthOrPercent valueOf(String stringValue) {
        OdfLengthOrPercent ret = new OdfLengthOrPercent();
        int n = stringValue.indexOf("%");
        if (n != -1) {
            ret.setPercent(OdfPercent.valueOf(stringValue).doubleValue());
        } else {
            ret.setLength(OdfMeasure.valueOf(stringValue).intValue());
        }
        return ret;
    }
}

