/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.form.OdfConnectionResourceElement;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.text.OdfTableType;
import org.w3c.dom.Node;

public abstract class OdfDatabaseDisplayElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.get(OdfNamespace.TEXT, "database-display");

    public OdfDatabaseDisplayElement(OdfFileDom aOwnerDoc) {
        super(aOwnerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public void init(String tableName, String columnName) {
        this.setTableName(tableName);
        this.setColumnName(columnName);
    }

    public String getTableName() {
        return this.getOdfAttribute(OdfName.get(OdfNamespace.TEXT, "table-name"));
    }

    public void setTableName(String tableName) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TEXT, "table-name"), tableName);
    }

    public OdfTableType getTableType() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.TEXT, "table-type"));
        return OdfTableType.enumValueOf(stringVal);
    }

    public void setTableType(OdfTableType tableType) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TEXT, "table-type"), tableType.toString());
    }

    public String getDatabaseName() {
        return this.getOdfAttribute(OdfName.get(OdfNamespace.TEXT, "database-name"));
    }

    public void setDatabaseName(String databaseName) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TEXT, "database-name"), databaseName);
    }

    public String getDataStyleName() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.STYLE, "data-style-name"));
        return OdfStyleNameRef.valueOf(stringVal);
    }

    public void setDataStyleName(OdfStyleNameRef dataStyleName) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.STYLE, "data-style-name"), dataStyleName.toString());
    }

    public String getColumnName() {
        return this.getOdfAttribute(OdfName.get(OdfNamespace.TEXT, "column-name"));
    }

    public void setColumnName(String columnName) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TEXT, "column-name"), columnName);
    }

    public OdfConnectionResourceElement createConnectionResourceElement(OdfAnyURI href) {
        OdfConnectionResourceElement nConnectionResource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectionResourceElement.class);
        nConnectionResource.setHref(href);
        this.appendChild((Node)((Object)nConnectionResource));
        return nConnectionResource;
    }
}

