/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDataPilotFieldElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDatabaseSourceQueryElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDatabaseSourceSqlElement;
import org.odftoolkit.odfdom.dom.element.table.OdfDatabaseSourceTableElement;
import org.odftoolkit.odfdom.dom.element.table.OdfSourceCellRangeElement;
import org.odftoolkit.odfdom.dom.element.table.OdfSourceServiceElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList;
import org.odftoolkit.odfdom.dom.type.table.OdfGrandTotalType;
import org.odftoolkit.odfdom.dom.type.table.OdfOrientationType;
import org.w3c.dom.Node;

public abstract class OdfDataPilotTableElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.get(OdfNamespace.TABLE, "data-pilot-table");

    public OdfDataPilotTableElement(OdfFileDom aOwnerDoc) {
        super(aOwnerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public void init(String name, OdfCellRangeAddress targetRangeAddress) {
        this.setName(name);
        this.setTargetRangeAddress(targetRangeAddress);
    }

    public String getName() {
        return this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "name"));
    }

    public void setName(String name) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "name"), name);
    }

    public String getApplicationData() {
        return this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "application-data"));
    }

    public void setApplicationData(String applicationData) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "application-data"), applicationData);
    }

    public OdfGrandTotalType getGrandTotal() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "grand-total"));
        if (stringVal.length() == 0) {
            stringVal = "both";
        }
        return OdfGrandTotalType.enumValueOf(stringVal);
    }

    public void setGrandTotal(OdfGrandTotalType grandTotal) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "grand-total"), grandTotal.toString());
    }

    public OdfBoolean getIgnoreEmptyRows() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "ignore-empty-rows"));
        return OdfBoolean.valueOf(stringVal);
    }

    public void setIgnoreEmptyRows(OdfBoolean isIgnoreEmptyRows) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "ignore-empty-rows"), isIgnoreEmptyRows.toString());
    }

    public OdfBoolean getIdentifyCategories() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "identify-categories"));
        return OdfBoolean.valueOf(stringVal);
    }

    public void setIdentifyCategories(OdfBoolean isIdentifyCategories) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "identify-categories"), isIdentifyCategories.toString());
    }

    public OdfCellRangeAddress getTargetRangeAddress() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "target-range-address"));
        return OdfCellRangeAddress.valueOf(stringVal);
    }

    public void setTargetRangeAddress(OdfCellRangeAddress targetRangeAddress) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "target-range-address"), targetRangeAddress.toString());
    }

    public OdfCellRangeAddressList getButtons() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "buttons"));
        return OdfCellRangeAddressList.valueOf(stringVal);
    }

    public void setButtons(OdfCellRangeAddressList buttons) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "buttons"), buttons.toString());
    }

    public OdfBoolean getShowFilterButton() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "show-filter-button"));
        if (stringVal.length() == 0) {
            stringVal = "true";
        }
        return OdfBoolean.valueOf(stringVal);
    }

    public void setShowFilterButton(OdfBoolean isShowFilterButton) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "show-filter-button"), isShowFilterButton.toString());
    }

    public OdfBoolean getDrillDownOnDoubleClick() {
        String stringVal = this.getOdfAttribute(OdfName.get(OdfNamespace.TABLE, "drill-down-on-double-click"));
        if (stringVal.length() == 0) {
            stringVal = "true";
        }
        return OdfBoolean.valueOf(stringVal);
    }

    public void setDrillDownOnDoubleClick(OdfBoolean isDrillDownOnDoubleClick) {
        this.setOdfAttribute(OdfName.get(OdfNamespace.TABLE, "drill-down-on-double-click"), isDrillDownOnDoubleClick.toString());
    }

    public OdfDatabaseSourceSqlElement createDatabaseSourceSqlElement(String databaseName, String sqlStatement) {
        OdfDatabaseSourceSqlElement nDatabaseSourceSql = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceSqlElement.class);
        nDatabaseSourceSql.setDatabaseName(databaseName);
        nDatabaseSourceSql.setSqlStatement(sqlStatement);
        this.appendChild((Node)((Object)nDatabaseSourceSql));
        return nDatabaseSourceSql;
    }

    public OdfDatabaseSourceQueryElement createDatabaseSourceQueryElement(String databaseName, String queryName) {
        OdfDatabaseSourceQueryElement nDatabaseSourceQuery = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceQueryElement.class);
        nDatabaseSourceQuery.setDatabaseName(databaseName);
        nDatabaseSourceQuery.setQueryName(queryName);
        this.appendChild((Node)((Object)nDatabaseSourceQuery));
        return nDatabaseSourceQuery;
    }

    public OdfDatabaseSourceTableElement createDatabaseSourceTableElement(String databaseName, String databaseTableName) {
        OdfDatabaseSourceTableElement nDatabaseSourceTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceTableElement.class);
        nDatabaseSourceTable.setDatabaseName(databaseName);
        nDatabaseSourceTable.setDatabaseTableName(databaseTableName);
        this.appendChild((Node)((Object)nDatabaseSourceTable));
        return nDatabaseSourceTable;
    }

    public OdfSourceServiceElement createSourceServiceElement(String name, String sourceName, String objectName) {
        OdfSourceServiceElement nSourceService = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSourceServiceElement.class);
        nSourceService.setName(name);
        nSourceService.setSourceName(sourceName);
        nSourceService.setObjectName(objectName);
        this.appendChild((Node)((Object)nSourceService));
        return nSourceService;
    }

    public OdfSourceCellRangeElement createSourceCellRangeElement(OdfCellRangeAddress cellRangeAddress) {
        OdfSourceCellRangeElement nSourceCellRange = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSourceCellRangeElement.class);
        nSourceCellRange.setCellRangeAddress(cellRangeAddress);
        this.appendChild((Node)((Object)nSourceCellRange));
        return nSourceCellRange;
    }

    public OdfDataPilotFieldElement createDataPilotFieldElement(String sourceFieldName, OdfOrientationType orientation) {
        OdfDataPilotFieldElement nDataPilotField = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotFieldElement.class);
        nDataPilotField.setSourceFieldName(sourceFieldName);
        nDataPilotField.setOrientation(orientation);
        this.appendChild((Node)((Object)nDataPilotField));
        return nDataPilotField;
    }

    public OdfDataPilotFieldElement createDataPilotFieldElement(OdfOrientationType orientation, String selectedPage, String sourceFieldName) {
        OdfDataPilotFieldElement nDataPilotField = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotFieldElement.class);
        nDataPilotField.setOrientation(orientation);
        nDataPilotField.setSelectedPage(selectedPage);
        nDataPilotField.setSourceFieldName(sourceFieldName);
        this.appendChild((Node)((Object)nDataPilotField));
        return nDataPilotField;
    }
}

