/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.style.OdfParagraphProperties;
import org.odftoolkit.odfdom.doc.element.style.OdfTextProperties;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.dom.element.OdfContainerElementBase;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.OdfChartPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfDrawingPagePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfHeaderFooterPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfPageLayoutPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfRubyPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfSectionPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.OdfTextPropertiesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.OdfStylePropertySet;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OdfStyleBase
extends OdfContainerElementBase
implements OdfStylePropertySet {
    private static final long serialVersionUID = 8271282184913774000L;
    private HashMap<OdfStylePropertiesSet, OdfStylePropertiesBase> mPropertySetElementMap;
    private Vector<OdfStylableElement> mStyleUser;
    static HashMap<OdfName, OdfStylePropertiesSet> mStylePropertiesElementToSetMap = new HashMap();

    public OdfStyleBase(OdfFileDom ownerDocument, String namespaceURI, String qualifiedName) throws DOMException {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    public OdfStyleBase(OdfFileDom ownerDocument, OdfName aName) throws DOMException {
        super(ownerDocument, aName.getUri(), aName.getQName());
    }

    public void addStyleUser(OdfStylableElement user) {
        if (this.mStyleUser == null) {
            this.mStyleUser = new Vector();
        }
        this.mStyleUser.add(user);
    }

    public Map<OdfStyleProperty, String> getStyleProperties() {
        TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
        OdfStyleFamily family = this.getFamily();
        if (family != null) {
            for (OdfStyleProperty property : family.getProperties()) {
                if (!this.hasProperty(property)) continue;
                result.put(property, this.getProperty(property));
            }
        }
        return result;
    }

    public Map<OdfStyleProperty, String> getStylePropertiesDeep() {
        TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
        for (OdfStyleBase style = this; style != null; style = style.getParentStyle()) {
            OdfStyleFamily family = style.getFamily();
            if (family == null) continue;
            for (OdfStyleProperty property : family.getProperties()) {
                if (result.containsKey(property) || !style.hasProperty(property)) continue;
                result.put(property, style.getProperty(property));
            }
        }
        return result;
    }

    public void removeStyleUser(OdfStylableElement user) {
        if (this.mStyleUser != null) {
            this.mStyleUser.remove(user);
        }
    }

    public int getStyleUserCount() {
        return this.mStyleUser == null ? 0 : this.mStyleUser.size();
    }

    public String getFamilyName() {
        return this.getFamily().getName();
    }

    public abstract OdfStyleFamily getFamily();

    public OdfStylePropertiesBase getPropertiesElement(OdfStylePropertiesSet set) {
        if (this.mPropertySetElementMap != null) {
            return this.mPropertySetElementMap.get((Object)set);
        }
        return null;
    }

    public OdfStylePropertiesBase getOrCreatePropertiesElement(OdfStylePropertiesSet set) {
        OdfStylePropertiesBase properties = null;
        if (this.mPropertySetElementMap != null) {
            properties = this.mPropertySetElementMap.get((Object)set);
        }
        if (properties == null) {
            for (Map.Entry<OdfName, OdfStylePropertiesSet> entry : mStylePropertiesElementToSetMap.entrySet()) {
                if (!entry.getValue().equals((Object)set)) continue;
                properties = (OdfStylePropertiesBase)((OdfFileDom)this.ownerDocument).createElementNS(entry.getKey());
                if (this.getFirstChild() == null) {
                    this.appendChild((Node)((Object)properties));
                    break;
                }
                Object beforeNode = null;
                if (set.equals((Object)OdfStylePropertiesSet.GraphicProperties)) {
                    beforeNode = OdfElement.findFirstChildNode(OdfParagraphProperties.class, (Node)((Object)this));
                    if (beforeNode == null) {
                        beforeNode = OdfElement.findFirstChildNode(OdfTextProperties.class, (Node)((Object)this));
                    }
                } else if (set.equals((Object)OdfStylePropertiesSet.ParagraphProperties)) {
                    beforeNode = OdfElement.findFirstChildNode(OdfTextProperties.class, (Node)((Object)this));
                } else if (!set.equals((Object)OdfStylePropertiesSet.TextProperties)) {
                    beforeNode = this.getFirstChild();
                }
                if (beforeNode == null) {
                    for (beforeNode = this.getFirstChild(); beforeNode != null && (beforeNode.getNodeType() != 1 || beforeNode instanceof OdfStylePropertiesBase); beforeNode = beforeNode.getNextSibling()) {
                    }
                }
                this.insertBefore((Node)((Object)properties), (Node)beforeNode);
                break;
            }
        }
        return properties;
    }

    @Override
    public String getProperty(OdfStyleProperty prop) {
        String value = null;
        OdfStylePropertiesBase properties = this.getPropertiesElement(prop.getPropertySet());
        if (properties != null && properties.hasAttributeNS(prop.getName().getUri(), prop.getName().getLocalName())) {
            return properties.getOdfAttribute(prop.getName());
        }
        OdfStyleBase parent = this.getParentStyle();
        if (parent != null) {
            return parent.getProperty(prop);
        }
        return value;
    }

    @Override
    public boolean hasProperty(OdfStyleProperty prop) {
        OdfStylePropertiesBase properties;
        if (this.mPropertySetElementMap != null && (properties = this.mPropertySetElementMap.get((Object)prop.getPropertySet())) != null) {
            return properties.hasAttributeNS(prop.getName().getUri(), prop.getName().getLocalName());
        }
        return false;
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refChild) {
        OdfStylePropertiesSet set;
        if (node instanceof OdfStylePropertiesBase && (set = mStylePropertiesElementToSetMap.get(node.getOdfName())) != null) {
            if (this.mPropertySetElementMap == null) {
                this.mPropertySetElementMap = new HashMap();
            }
            this.mPropertySetElementMap.put(set, (OdfStylePropertiesBase)node);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        OdfStylePropertiesSet set;
        if (this.mPropertySetElementMap != null && node instanceof OdfStylePropertiesBase && (set = mStylePropertiesElementToSetMap.get(node.getOdfName())) != null) {
            this.mPropertySetElementMap.remove((Object)set);
        }
    }

    @Override
    public Map<OdfStyleProperty, String> getProperties(Set<OdfStyleProperty> properties) {
        HashMap<OdfStyleProperty, String> map = new HashMap<OdfStyleProperty, String>();
        for (OdfStyleProperty property : properties) {
            map.put(property, this.getProperty(property));
        }
        return map;
    }

    @Override
    public Set<OdfStyleProperty> getStrictProperties() {
        return this.getFamily().getProperties();
    }

    @Override
    public void removeProperty(OdfStyleProperty property) {
        OdfStylePropertiesBase properties;
        if (this.mPropertySetElementMap != null && (properties = this.mPropertySetElementMap.get((Object)property.getPropertySet())) != null) {
            properties.removeAttributeNS(property.getName().getUri(), property.getName().getLocalName());
        }
    }

    @Override
    public void setProperties(Map<OdfStyleProperty, String> properties) {
        for (Map.Entry<OdfStyleProperty, String> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(OdfStyleProperty property, String value) {
        OdfStylePropertiesBase properties = this.getOrCreatePropertiesElement(property.getPropertySet());
        if (properties != null) {
            properties.setOdfAttribute(property.getName(), value);
        }
    }

    @Override
    public boolean equals(Object obj) {
        int i;
        int i2;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OdfStyleBase)) {
            return false;
        }
        OdfStyleBase compare = (OdfStyleBase)obj;
        if (!this.localName.equals(compare.localName)) {
            return false;
        }
        if (!this.namespaceURI.equals(compare.namespaceURI)) {
            return false;
        }
        if (this.attributes == compare.attributes) {
            return true;
        }
        if (this.attributes == null || compare.attributes == null) {
            return false;
        }
        int attr_count1 = this.attributes.getLength();
        int attr_count2 = compare.attributes.getLength();
        Vector<Node> attr1 = new Vector<Node>();
        for (int i3 = 0; i3 < attr_count1; ++i3) {
            Node node = this.attributes.item(i3);
            if (node.getNodeValue().length() == 0) continue;
            attr1.add(node);
        }
        Vector<Node> attr2 = new Vector<Node>();
        for (i2 = 0; i2 < attr_count2; ++i2) {
            Node node = compare.attributes.item(i2);
            if (node.getNodeValue().length() == 0) continue;
            attr2.add(node);
        }
        if (attr1.size() != attr2.size()) {
            return false;
        }
        for (i2 = 0; i2 < attr1.size(); ++i2) {
            Node n1 = (Node)attr1.get(i2);
            if (n1.getLocalName().equals("name") && n1.getNamespaceURI().equals(OdfNamespace.STYLE.getUri())) continue;
            Node n2 = null;
            int j = 0;
            for (j = 0; j < attr2.size(); ++j) {
                n2 = (Node)attr2.get(j);
                if (n1.getLocalName().equals(n2.getLocalName()) && n1.getNamespaceURI().equals(n2.getNamespaceURI())) break;
            }
            if (j == attr2.size()) {
                return false;
            }
            if (n1.getTextContent().equals(n2.getTextContent())) continue;
            return false;
        }
        NodeList childs1 = this.getChildNodes();
        NodeList childs2 = compare.getChildNodes();
        int child_count1 = childs1.getLength();
        int child_count2 = childs2.getLength();
        if (child_count1 == 0 && child_count2 == 0) {
            return true;
        }
        Vector<Node> nodes1 = new Vector<Node>();
        for (int i4 = 0; i4 < child_count1; ++i4) {
            Node node = childs1.item(i4);
            if (node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0) continue;
            nodes1.add(node);
        }
        Vector<Node> nodes2 = new Vector<Node>();
        for (i = 0; i < child_count2; ++i) {
            Node node = childs2.item(i);
            if (node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0) continue;
            nodes2.add(node);
        }
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (i = 0; i < nodes1.size(); ++i) {
            Node n1 = (Node)nodes1.get(i);
            Node n2 = (Node)nodes2.get(i);
            n1.toString();
            n2.toString();
            if (n1.equals(n2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 413 + (this.mPropertySetElementMap != null ? this.mPropertySetElementMap.hashCode() : 0);
    }

    public abstract OdfStyleBase getParentStyle();

    static {
        mStylePropertiesElementToSetMap.put(OdfChartPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.ChartProperties);
        mStylePropertiesElementToSetMap.put(OdfDrawingPagePropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.DrawingPageProperties);
        mStylePropertiesElementToSetMap.put(OdfGraphicPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.GraphicProperties);
        mStylePropertiesElementToSetMap.put(OdfHeaderFooterPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.HeaderFooterProperties);
        mStylePropertiesElementToSetMap.put(OdfListLevelPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.ListLevelProperties);
        mStylePropertiesElementToSetMap.put(OdfPageLayoutPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.PageLayoutProperties);
        mStylePropertiesElementToSetMap.put(OdfParagraphPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.ParagraphProperties);
        mStylePropertiesElementToSetMap.put(OdfRubyPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.RubyProperties);
        mStylePropertiesElementToSetMap.put(OdfSectionPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.SectionProperties);
        mStylePropertiesElementToSetMap.put(OdfTableCellPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TableCellProperties);
        mStylePropertiesElementToSetMap.put(OdfTableColumnPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TableColumnProperties);
        mStylePropertiesElementToSetMap.put(OdfTablePropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TableProperties);
        mStylePropertiesElementToSetMap.put(OdfTableRowPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TableRowProperties);
        mStylePropertiesElementToSetMap.put(OdfTextPropertiesElement.ELEMENT_NAME, OdfStylePropertiesSet.TextProperties);
    }
}

