/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Version {
    private static final String CURRENT_CLASS_RESOURCE_PATH = "org/odftoolkit/odfdom/dom/Version.class";
    private static final String MANIFEST_JAR_PATH = "META-INF/MANIFEST.MF";
    private static String APPLICATION_NAME;
    private static String APPLICATION_VERSION;
    private static String APPLICATION_WEBSITE;
    private static String BUILD_BY;
    private static String BUILD_DATE;
    private static String SUPPORTED_ODF_VERSION;

    private static InputStream getManifestAsStream() {
        String versionRef = Version.class.getClassLoader().getResource(CURRENT_CLASS_RESOURCE_PATH).toString();
        String manifestRef = versionRef.substring(0, versionRef.lastIndexOf(CURRENT_CLASS_RESOURCE_PATH)) + MANIFEST_JAR_PATH;
        URL manifestURL = null;
        InputStream in = null;
        try {
            manifestURL = new URL(manifestRef);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(Version.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            in = manifestURL.openStream();
        }
        catch (IOException ex) {
            Logger.getLogger(Version.class.getName()).log(Level.SEVERE, null, ex);
        }
        return in;
    }

    private Version() {
    }

    public static void main(String[] args) throws IOException {
        System.out.println(Version.getApplicationTitle() + " (build " + Version.getBuildDate() + ')' + "\nfrom " + Version.getApplicationWebsite() + " supporting ODF " + Version.getSupportedOdfVersion());
    }

    public static String getApplicationName() {
        return APPLICATION_NAME;
    }

    public static String getApplicationTitle() {
        return Version.getApplicationName() + ' ' + Version.getApplicationVersion();
    }

    public static String getApplicationVersion() {
        return APPLICATION_VERSION;
    }

    public static String getApplicationWebsite() {
        return APPLICATION_WEBSITE;
    }

    public static String getBuildResponsible() {
        return BUILD_BY;
    }

    public static String getBuildDate() {
        return BUILD_DATE;
    }

    public static String getSupportedOdfVersion() {
        return SUPPORTED_ODF_VERSION;
    }

    static {
        try {
            Manifest manifest = new Manifest(Version.getManifestAsStream());
            Attributes attr = manifest.getEntries().get("ODFDOM");
            APPLICATION_NAME = attr.getValue("Application-Name");
            APPLICATION_VERSION = attr.getValue("Application-Version");
            APPLICATION_WEBSITE = attr.getValue("Application-Website");
            BUILD_BY = attr.getValue("Built-By");
            BUILD_DATE = attr.getValue("Built-Date");
            SUPPORTED_ODF_VERSION = attr.getValue("Supported-Odf-Version");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

