/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.text;

import java.util.logging.Logger;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.office.OdfAutomaticStyles;
import org.odftoolkit.odfdom.doc.element.office.OdfStyles;
import org.odftoolkit.odfdom.doc.element.text.OdfListStyle;
import org.odftoolkit.odfdom.dom.element.text.OdfListElement;
import org.odftoolkit.odfdom.dom.element.text.OdfListLevelStyleElementBase;
import org.w3c.dom.Node;

public class OdfList
extends OdfListElement {
    private static final long serialVersionUID = -3490592040586665276L;

    public OdfList(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfListStyle getListStyle() {
        OdfListStyle style = null;
        String listName = this.getStyleName();
        if (listName != null && listName.length() > 0) {
            OdfStyles styles;
            OdfAutomaticStyles autoStyles = ((OdfFileDom)this.ownerDocument).getAutomaticStyles();
            if (autoStyles != null) {
                style = autoStyles.getListStyle(listName);
            }
            if (style == null && (styles = this.mOdfDocument.getDocumentStyles()) != null) {
                style = styles.getListStyle(listName);
            }
        } else {
            OdfList parentList = this.getParentList();
            if (parentList != null) {
                style = parentList.getListStyle();
            }
        }
        return style;
    }

    public int getListLevel() {
        int level = 1;
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof OdfListElement)) continue;
            ++level;
        }
        return level;
    }

    public OdfListLevelStyleElementBase getListLevelStyle() {
        OdfListLevelStyleElementBase odfListLevelStyle = null;
        OdfListStyle style = this.getListStyle();
        int level = this.getListLevel();
        if (style != null) {
            odfListLevelStyle = style.getLevel(level);
        } else {
            Logger.getLogger(OdfList.class.getName()).warning("No ListLevelStyle found!");
        }
        return odfListLevelStyle;
    }

    public OdfListStyle getOrCreateLocalListStyle() {
        OdfAutomaticStyles autoStyles;
        OdfListStyle listStyle = this.getListStyle();
        if (listStyle == null && (autoStyles = ((OdfFileDom)this.ownerDocument).getOrCreateAutomaticStyles()) != null) {
            listStyle = autoStyles.createListStyle();
        }
        return listStyle;
    }

    public OdfList getParentList() {
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof OdfList)) continue;
            return (OdfList)((Object)parent);
        }
        return null;
    }
}

