/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.office;

import java.util.Iterator;
import java.util.Vector;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.draw.OdfPage;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.office.OdfPresentationElement;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfPresentation
extends OdfPresentationElement {
    private static final long serialVersionUID = 4270501450912600653L;
    private Vector<OdfPage> mPages;

    public OdfPresentation(OdfFileDom _aOwnerDoc) {
        super(_aOwnerDoc);
    }

    public OdfPage getPageAt(int index) {
        if (this.mPages != null || this.mPages.size() <= index) {
            return this.mPages.get(index);
        }
        return null;
    }

    public int getPageCount() {
        if (this.mPages != null) {
            return this.mPages.size();
        }
        return 0;
    }

    public OdfPage getPage(String name) {
        if (this.mPages != null) {
            for (OdfPage page : this.mPages) {
                if (!page.getName().equals(name)) continue;
                return page;
            }
        }
        return null;
    }

    public Iterator<OdfPage> getPages() {
        if (this.mPages != null) {
            return this.mPages.iterator();
        }
        return new Vector().iterator();
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfPage) {
            OdfPage page = (OdfPage)node;
            if (this.mPages == null) {
                this.mPages = new Vector();
            } else if (refNode != null) {
                int index = -1;
                OdfPage refPage = OdfPresentation.findPreviousChildNode(OdfPage.class, (Node)((Object)node));
                if (refPage != null) {
                    index = this.mPages.indexOf(refPage);
                }
                this.mPages.insertElementAt(page, index + 1);
                return;
            }
            this.mPages.add(page);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfPage && this.mPages != null) {
            OdfPage page = (OdfPage)node;
            this.mPages.remove(page);
        }
    }
}

