/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.element.draw;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.draw.OdfImageElement;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.util.URITransformer;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;

public class OdfImage
extends OdfImageElement {
    private static final long serialVersionUID = -6157458382218705296L;
    private URI mImageURI;
    private OdfPackage mOdfPackage;
    private static final String SLASH = "/";

    public OdfImage(OdfFileDom ownerDoc) {
        super(ownerDoc);
        this.mOdfPackage = ownerDoc.getOdfDocument().getPackage();
    }

    public URI getImageUri() {
        try {
            if (this.mImageURI == null) {
                this.mImageURI = new URI(URITransformer.encodePath(this.getHref().toString()));
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(OdfImage.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.mImageURI;
    }

    public void setImagePath(String packagePath) {
        try {
            packagePath = packagePath.replaceFirst(this.mOdfDocument.getDocumentPackagePath(), "");
            URI uri = new URI(URITransformer.encodePath(packagePath).toString());
            this.setHref(new OdfAnyURI(URITransformer.decodePath(uri.toString())));
            this.mImageURI = uri;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(OdfImage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String insertImage(URI imageUri) throws Exception {
        String imageRef = imageUri.toString();
        if (imageRef.contains(SLASH)) {
            imageRef = imageRef.substring(imageRef.lastIndexOf(SLASH) + 1, imageRef.length());
        }
        String packagePath = OdfPackage.OdfFile.IMAGE_DIRECTORY.getPath() + SLASH + imageRef;
        packagePath = this.mOdfDocument.getDocumentPackagePath() + packagePath;
        String mediaType = OdfFileEntry.getMediaType(imageRef);
        this.setImagePath(packagePath);
        this.mOdfPackage.insert(imageUri, packagePath, mediaType);
        return packagePath;
    }

    public void insertImage(InputStream is, String packagePath, String mediaType) throws Exception {
        this.setImagePath(packagePath);
        this.mOdfPackage.insert(is, packagePath, mediaType);
    }
}

