/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.maven;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Date;

public class SVNSSLUtil {
    public static StringBuffer getServerCertificatePrompt(X509Certificate cert, String realm, String hostName) {
        int failures = SVNSSLUtil.getServerCertificateFailures(cert, hostName);
        StringBuffer prompt = new StringBuffer();
        prompt.append("Error validating server certificate for '");
        prompt.append(realm);
        prompt.append("':\n");
        if ((failures & 8) != 0) {
            prompt.append(" - The certificate is not issued by a trusted authority. Use the\n   fingerprint to validate the certificate manually!\n");
        }
        if ((failures & 4) != 0) {
            prompt.append(" - The certificate hostname does not match.\n");
        }
        if ((failures & 2) != 0) {
            prompt.append(" - The certificate has expired.\n");
        }
        if ((failures & 1) != 0) {
            prompt.append(" - The certificate is not yet valid.\n");
        }
        SVNSSLUtil.getServerCertificateInfo(cert, prompt);
        return prompt;
    }

    private static String getFingerprint(X509Certificate cert) {
        StringBuffer s = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(cert.getEncoded());
            byte[] digest = md.digest();
            for (int i = 0; i < digest.length; ++i) {
                int b;
                String hex;
                if (i != 0) {
                    s.append(':');
                }
                if ((hex = Integer.toHexString(b = digest[i] & 0xFF)).length() == 1) {
                    s.append('0');
                }
                s.append(hex.toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    private static void getServerCertificateInfo(X509Certificate cert, StringBuffer info) {
        info.append("Certificate information:");
        info.append('\n');
        info.append(" - Subject: ");
        info.append(cert.getSubjectDN().getName());
        info.append('\n');
        info.append(" - Valid: ");
        info.append("from " + cert.getNotBefore() + " until " + cert.getNotAfter());
        info.append('\n');
        info.append(" - Issuer: ");
        info.append(cert.getIssuerDN().getName());
        info.append('\n');
        info.append(" - Fingerprint: ");
        info.append(SVNSSLUtil.getFingerprint(cert));
    }

    private static int getServerCertificateFailures(X509Certificate cert, String realHostName) {
        String hostName;
        int index;
        int mask = 8;
        Date time = new Date(System.currentTimeMillis());
        if (time.before(cert.getNotBefore())) {
            mask |= 1;
        }
        if (time.after(cert.getNotAfter())) {
            mask |= 2;
        }
        if ((index = (hostName = cert.getSubjectDN().getName()).indexOf("CN=") + 3) >= 0) {
            if ((hostName = hostName.substring(index)).indexOf(32) >= 0) {
                hostName = hostName.substring(0, hostName.indexOf(32));
            }
            if (hostName.indexOf(44) >= 0) {
                hostName = hostName.substring(0, hostName.indexOf(44));
            }
        }
        if (realHostName != null && !realHostName.equals(hostName)) {
            mask |= 4;
        }
        return mask;
    }
}

