/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.xml.XmlConfiguration;

public class JettyWebXmlConfiguration
implements Configuration {
    private WebAppContext _context;

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureWebApp() throws Exception {
        Resource web_inf;
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Cannot configure webapp after it is started");
            }
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Configuring web-jetty.xml");
        }
        if ((web_inf = this.getWebAppContext().getWebInf()) != null && web_inf.isDirectory()) {
            Resource jetty = web_inf.addPath("jetty6-web.xml");
            if (!jetty.exists()) {
                jetty = web_inf.addPath("jetty-web.xml");
            }
            if (!jetty.exists()) {
                jetty = web_inf.addPath("web-jetty.xml");
            }
            if (jetty.exists()) {
                String[] old_server_classes = this._context.getServerClasses();
                try {
                    String[] server_classes = new String[2 + (old_server_classes == null ? 0 : old_server_classes.length)];
                    server_classes[0] = "-org.mortbay.jetty.";
                    server_classes[1] = "-org.mortbay.util.";
                    if (server_classes != null) {
                        System.arraycopy(old_server_classes, 0, server_classes, 2, old_server_classes.length);
                    }
                    this._context.setServerClasses(server_classes);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Configure: " + jetty));
                    }
                    XmlConfiguration jetty_config = new XmlConfiguration(jetty.getURL());
                    jetty_config.configure((Object)this.getWebAppContext());
                }
                finally {
                    this._context.setServerClasses(old_server_classes);
                }
            }
        }
    }

    public void deconfigureWebApp() throws Exception {
    }
}

