/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.nio.AbstractNIOConnector;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;
import org.mortbay.util.ajax.Continuation;

public class SelectChannelConnector
extends AbstractNIOConnector {
    private transient ServerSocketChannel _acceptChannel;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private SelectorManager _manager = new SelectorManager(){

        protected SocketChannel acceptChannel(SelectionKey key) throws IOException {
            SocketChannel channel = ((ServerSocketChannel)key.channel()).accept();
            if (channel == null) {
                return null;
            }
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            SelectChannelConnector.this.configure(socket);
            return channel;
        }

        public boolean dispatch(Runnable task) throws IOException {
            return SelectChannelConnector.this.getThreadPool().dispatch(task);
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionClosed((HttpConnection)endpoint.getConnection());
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionOpened((HttpConnection)endpoint.getConnection());
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            return SelectChannelConnector.this.newConnection(channel, endpoint);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey sKey) throws IOException {
            return SelectChannelConnector.this.newEndPoint(channel, selectSet, sKey);
        }
    };

    public void accept(int acceptorID) throws IOException {
        this._manager.doSelect(acceptorID);
    }

    public void stopAccept(int acceptorID) throws Exception {
        this._manager.doStop(acceptorID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel != null) {
                this._acceptChannel.close();
            }
            this._acceptChannel = null;
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        ConnectorEndPoint cep = (ConnectorEndPoint)endpoint;
        cep.cancelIdle();
        request.setTimeStamp(cep.getSelectSet().getNow());
        super.customize(endpoint, request);
    }

    public void persist(EndPoint endpoint) throws IOException {
        ((ConnectorEndPoint)endpoint).scheduleIdle();
        super.persist(endpoint);
    }

    public Object getConnection() {
        return this._acceptChannel;
    }

    public boolean getDelaySelectKeyUpdate() {
        return this._manager.isDelaySelectKeyUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalPort() {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
                return -1;
            }
            return this._acceptChannel.socket().getLocalPort();
        }
    }

    public Continuation newContinuation() {
        return new RetryContinuation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null) {
                this._acceptChannel = ServerSocketChannel.open();
                InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
                this._acceptChannel.configureBlocking(false);
            }
        }
    }

    public void setDelaySelectKeyUpdate(boolean delay) {
        this._manager.setDelaySelectKeyUpdate(delay);
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._manager.setMaxIdleTime(maxIdleTime);
        super.setMaxIdleTime(maxIdleTime);
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = lowResourcesConnections;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
        super.setLowResourceMaxIdleTime((int)lowResourcesMaxIdleTime);
    }

    public void setLowResourceMaxIdleTime(int lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
        super.setLowResourceMaxIdleTime(lowResourcesMaxIdleTime);
    }

    protected void doStart() throws Exception {
        this._manager.setSelectSets(this.getAcceptors());
        this._manager.setMaxIdleTime(this.getMaxIdleTime());
        this._manager.setLowResourcesConnections(this.getLowResourcesConnections());
        this._manager.setLowResourcesMaxIdleTime(this.getLowResourcesMaxIdleTime());
        this._manager.start();
        this.open();
        this._manager.register(this._acceptChannel);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._manager.stop();
        super.doStop();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return new ConnectorEndPoint(channel, selectSet, key);
    }

    protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
        return new HttpConnection((Connector)this, (EndPoint)endpoint, this.getServer());
    }

    public static class RetryContinuation
    extends Timeout.Task
    implements Continuation,
    Runnable {
        SelectChannelEndPoint _endPoint = (SelectChannelEndPoint)HttpConnection.getCurrentConnection().getEndPoint();
        boolean _new = true;
        Object _object;
        boolean _pending = false;
        boolean _resumed = false;
        boolean _parked = false;
        RetryRequest _retry;
        long _timeout;

        public Object getObject() {
            return this._object;
        }

        public long getTimeout() {
            return this._timeout;
        }

        public boolean isNew() {
            return this._new;
        }

        public boolean isPending() {
            return this._pending;
        }

        public boolean isResumed() {
            return this._resumed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this;
            synchronized (object) {
                this._resumed = false;
                this._pending = false;
                this._parked = false;
            }
            object = this._endPoint.getSelectSet();
            synchronized (object) {
                this.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean suspend(long timeout) {
            boolean resumed = false;
            Object object = this;
            synchronized (object) {
                resumed = this._resumed;
                this._resumed = false;
                this._new = false;
                if (!this._pending && !resumed && timeout >= 0L) {
                    this._pending = true;
                    this._parked = false;
                    this._timeout = timeout;
                    if (this._retry == null) {
                        this._retry = new RetryRequest();
                    }
                    throw this._retry;
                }
                this._resumed = false;
                this._pending = false;
                this._parked = false;
            }
            object = this._endPoint.getSelectSet();
            synchronized (object) {
                this.cancel();
            }
            return resumed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            boolean redispatch = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                if (this._pending && !this.isExpired()) {
                    this._resumed = true;
                    redispatch = this._parked;
                    this._parked = false;
                }
            }
            if (redispatch) {
                SelectorManager.SelectSet selectSet;
                SelectorManager.SelectSet selectSet2 = selectSet = this._endPoint.getSelectSet();
                synchronized (selectSet2) {
                    this.cancel();
                }
                this._endPoint.scheduleIdle();
                selectSet.addChange(this);
                selectSet.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire() {
            boolean redispatch = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                redispatch = this._parked && this._pending && !this._resumed;
                this._parked = false;
            }
            if (redispatch) {
                this._endPoint.scheduleIdle();
                this._endPoint.getSelectSet().addChange(this);
                this._endPoint.getSelectSet().wakeup();
            }
        }

        public void run() {
            this._endPoint.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean undispatch() {
            boolean redispatch = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                if (!this._pending) {
                    return true;
                }
                redispatch = this.isExpired() || this._resumed;
                this._parked = !redispatch;
            }
            if (redispatch) {
                this._endPoint.scheduleIdle();
                this._endPoint.getSelectSet().addChange(this);
            } else if (this._timeout > 0L) {
                this._endPoint.getSelectSet().scheduleTimeout(this, this._timeout);
            }
            this._endPoint.getSelectSet().wakeup();
            return false;
        }

        public void setObject(Object object) {
            this._object = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                return "RetryContinuation@" + this.hashCode() + (this._new ? ",new" : "") + (this._pending ? ",pending" : "") + (this._resumed ? ",resumed" : "") + (this.isExpired() ? ",expired" : "") + (this._parked ? ",parked" : "");
            }
        }
    }

    public static class ConnectorEndPoint
    extends SelectChannelEndPoint {
        public ConnectorEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) {
            super(channel, selectSet, key);
            this.scheduleIdle();
        }

        public void close() throws IOException {
            RetryContinuation continuation = (RetryContinuation)((HttpConnection)this.getConnection()).getRequest().getContinuation();
            if (continuation != null && continuation.isPending()) {
                continuation.reset();
            }
            super.close();
        }

        public void undispatch() {
            RetryContinuation continuation = (RetryContinuation)((HttpConnection)this.getConnection()).getRequest().getContinuation();
            if (continuation != null) {
                Log.debug((String)"continuation {}", (Object)continuation);
                if (continuation.undispatch()) {
                    super.undispatch();
                }
            } else {
                super.undispatch();
            }
        }
    }
}

